/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.Multimap;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.xml.AWSDescribeInstancesResponseHandler;
import org.jclouds.aws.ec2.xml.AWSRunInstancesResponseHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.binders.IfNotNullBindAvailabilityZoneToFormParam;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface AWSInstanceApi
extends InstanceApi {
    @Named(value="DescribeInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeInstances"})
    @XMLResponseParser(value=AWSDescribeInstancesResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<? extends Reservation<? extends AWSRunningInstance>> describeInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="DescribeInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeInstances"})
    @XMLResponseParser(value=AWSDescribeInstancesResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<? extends Reservation<? extends AWSRunningInstance>> describeInstancesInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2);

    @Named(value="RunInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RunInstances"})
    @XMLResponseParser(value=AWSRunInstancesResponseHandler.class)
    public Reservation<? extends AWSRunningInstance> runInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @Nullable @BinderParam(value=IfNotNullBindAvailabilityZoneToFormParam.class) String var2, @FormParam(value="ImageId") String var3, @FormParam(value="MinCount") int var4, @FormParam(value="MaxCount") int var5, RunInstancesOptions ... var6);
}

