/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.xml;

import java.util.List;
import java.util.Vector;
import org.dlib.tools.Util;
import org.dlib.xml.XmlAttribute;

public class XmlElement {
    private String sName;
    private String sValue;
    private Vector vAttributes = new Vector();
    private Vector vChildren = new Vector();

    public XmlElement() {
        this("?", "");
    }

    public XmlElement(String string) {
        this(string, "");
    }

    public XmlElement(String string, String string2) {
        this.setName(string);
        this.setValue(string2);
    }

    public String getName() {
        return this.sName;
    }

    public String getValue() {
        return this.sValue;
    }

    public XmlElement setName(String string) {
        this.sName = string;
        return this;
    }

    public XmlElement setValue(String string) {
        this.sValue = string;
        return this;
    }

    public int getIntValue(int n) {
        return Util.getIntValue(this.sValue, n);
    }

    public float getFloatValue(float f) {
        return Util.getFloatValue(this.sValue, f);
    }

    public boolean getBooleanValue(boolean bl) {
        return Util.getBooleanValue(this.sValue, bl);
    }

    public boolean isLeaf() {
        return this.vChildren.size() == 0;
    }

    public XmlElement duplicate() {
        int n;
        XmlElement xmlElement = new XmlElement(this.sName, this.sValue);
        for (n = 0; n < this.vAttributes.size(); ++n) {
            xmlElement.setAttribute(((XmlAttribute)this.vAttributes.get(n)).duplicate());
        }
        for (n = 0; n < this.vChildren.size(); ++n) {
            XmlElement xmlElement2 = (XmlElement)this.vChildren.get(n);
            xmlElement.addChild(xmlElement2.duplicate());
        }
        return xmlElement;
    }

    public XmlElement setAttribute(XmlAttribute xmlAttribute) {
        for (int i = 0; i < this.vAttributes.size(); ++i) {
            XmlAttribute xmlAttribute2 = (XmlAttribute)this.vAttributes.elementAt(i);
            if (!xmlAttribute.getName().equals(xmlAttribute2.getName())) continue;
            this.vAttributes.setElementAt(xmlAttribute, i);
            return this;
        }
        this.vAttributes.addElement(xmlAttribute);
        return this;
    }

    public boolean removeAttribute(String string) {
        for (int i = 0; i < this.vAttributes.size(); ++i) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.vAttributes.elementAt(i);
            if (!xmlAttribute.getName().equals(string)) continue;
            this.vAttributes.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void removeAttributes() {
        this.vAttributes.removeAllElements();
    }

    public XmlAttribute getAttribute(String string) {
        for (int i = 0; i < this.vAttributes.size(); ++i) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.vAttributes.elementAt(i);
            if (!xmlAttribute.getName().equals(string)) continue;
            return xmlAttribute;
        }
        return null;
    }

    public String getAttributeValue(String string) {
        XmlAttribute xmlAttribute = this.getAttribute(string);
        if (xmlAttribute != null) {
            return xmlAttribute.getValue();
        }
        return null;
    }

    public List getAttributes() {
        return this.vAttributes;
    }

    public XmlElement addChild(XmlElement xmlElement) {
        this.vChildren.addElement(xmlElement);
        return this;
    }

    public XmlElement insertChildAt(int n, XmlElement xmlElement) {
        this.vChildren.insertElementAt(xmlElement, n);
        return this;
    }

    public boolean removeChild(String string) {
        for (int i = 0; i < this.vChildren.size(); ++i) {
            XmlElement xmlElement = (XmlElement)this.vChildren.elementAt(i);
            if (!xmlElement.getName().equals(string)) continue;
            this.vChildren.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean removeChildren(String string) {
        int n = this.vChildren.size();
        for (int i = 0; i < this.vChildren.size(); ++i) {
            XmlElement xmlElement = (XmlElement)this.vChildren.elementAt(i);
            if (!xmlElement.getName().equals(string)) continue;
            this.vChildren.removeElementAt(i--);
        }
        return n != this.vChildren.size();
    }

    public void removeChildren() {
        this.vChildren.removeAllElements();
    }

    public XmlElement getChild(String string) {
        for (int i = 0; i < this.vChildren.size(); ++i) {
            XmlElement xmlElement = (XmlElement)this.vChildren.elementAt(i);
            if (!xmlElement.getName().equals(string)) continue;
            return xmlElement;
        }
        return null;
    }

    public String getChildValue(String string) {
        XmlElement xmlElement = this.getChild(string);
        if (xmlElement != null) {
            return xmlElement.getValue();
        }
        return null;
    }

    public List getChildren(String string) {
        Vector<XmlElement> vector = new Vector<XmlElement>();
        for (int i = 0; i < this.vChildren.size(); ++i) {
            XmlElement xmlElement = (XmlElement)this.vChildren.elementAt(i);
            if (!xmlElement.getName().equals(string)) continue;
            vector.addElement(xmlElement);
        }
        return vector;
    }

    public List getChildren() {
        return this.vChildren;
    }

    public List preorderEnum() {
        Vector<XmlElement> vector = new Vector<XmlElement>();
        vector.add(this);
        for (int i = 0; i < this.vChildren.size(); ++i) {
            XmlElement xmlElement = (XmlElement)this.vChildren.get(i);
            vector.addAll(xmlElement.preorderEnum());
        }
        return vector;
    }

    public String toString() {
        String string = "[Name:" + this.sName + ", Value:" + this.sValue + "]";
        return string;
    }
}

