/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerConfigurationException;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.api.processing.XslProcessUtils;
import org.fao.geonet.api.processing.report.XsltMetadataProcessingReport;
import org.fao.geonet.api.records.model.suggestion.SuggestionType;
import org.fao.geonet.api.records.model.suggestion.SuggestionsType;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.events.history.RecordProcessingChangeEvent;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="recordProcessing")
@ReadWriteController
public class MetadataProcessApi {
    public static final String XSL_SUGGEST_FILE = "suggest.xsl";
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dm;
    @Autowired
    SettingManager sm;

    @Operation(summary="Get suggestions", description="Analyze the record an suggest processes to improve the quality of the record.<br/><a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/workflow/batchupdate-xsl.html'>More info</a>")
    @RequestMapping(value={"/{metadataUuid}/processes"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record suggestions."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public List<SuggestionType> getSuggestions(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        HashMap<String, String> xslParameter = new HashMap<String, String>();
        xslParameter.put("guiLang", request.getLocale().getISO3Language());
        xslParameter.put("siteUrl", this.sm.getSiteURL(context));
        xslParameter.put("nodeUrl", this.sm.getNodeURL());
        xslParameter.put("baseUrl", context.getBaseUrl());
        xslParameter.put("action", "analyze");
        MetadataSchema metadataSchema = this.dm.getSchema(metadata.getDataInfo().getSchemaId());
        Path xslProcessing = metadataSchema.getSchemaDir().resolve(XSL_SUGGEST_FILE);
        if (Files.exists(xslProcessing, new LinkOption[0])) {
            Element xmlSuggestions;
            boolean forEditing = false;
            boolean withValidationErrors = false;
            boolean keepXlinkAttributes = false;
            Element md = this.dm.getMetadata(context, String.valueOf(metadata.getId()), forEditing, withValidationErrors, keepXlinkAttributes);
            try {
                xmlSuggestions = Xml.transform((Element)md, (Path)xslProcessing, xslParameter);
            }
            catch (TransformerConfigurationException e) {
                throw new WebApplicationException(String.format("Error while retrieving suggestion for record '%s'. Check your suggest.xsl process (and all its imports).", metadataUuid, xslProcessing), (Throwable)e);
            }
            SuggestionsType suggestions = (SuggestionsType)Xml.unmarshall((Element)xmlSuggestions, SuggestionsType.class);
            return suggestions.getSuggestion();
        }
        throw new ResourceNotFoundException(String.format("No %s files available in schema '%s'. No suggestion to provides.", XSL_SUGGEST_FILE, metadata.getDataInfo().getSchemaId()));
    }

    @Operation(summary="Preview process result", description="Process a metadata with an XSL transformation declared in the metadata schema (See the process folder). Parameters sent to the service are forwarded to XSL process.")
    @RequestMapping(value={"/{metadataUuid}/processes/{process:.+}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A preview of the processed record."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public ResponseEntity<Element> processRecordPreview(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Process identifier") @PathVariable String process, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        boolean save = request.getMethod().equals("POST");
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        XsltMetadataProcessingReport report = new XsltMetadataProcessingReport(process);
        Element processedMetadata = this.process((ApplicationContext)applicationContext, process, request, metadata, save, context, this.sm, report);
        return new ResponseEntity((Object)processedMetadata, HttpStatus.OK);
    }

    @Operation(summary="Apply a process", description="Process a metadata with an XSL transformation declared in the metadata schema (See the process folder). Parameters sent to the service are forwarded to XSL process.")
    @RequestMapping(value={"/{metadataUuid}/processes/{process:.+}"}, method={RequestMethod.POST}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Record processed and saved."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public ResponseEntity processRecord(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Process identifier") @PathVariable String process, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        boolean save = true;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        XsltMetadataProcessingReport report = new XsltMetadataProcessingReport(process);
        this.process((ApplicationContext)applicationContext, process, request, metadata, save, context, this.sm, report);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private Element process(ApplicationContext applicationContext, String process, HttpServletRequest request, AbstractMetadata metadata, boolean save, ServiceContext context, SettingManager sm, XsltMetadataProcessingReport report) throws Exception {
        boolean forEditing = false;
        boolean withValidationErrors = false;
        boolean keepXlinkAttributes = true;
        Element beforeMetadata = this.dm.getMetadata(context, Integer.toString(metadata.getId()), false, false, false);
        String siteURL = sm.getSiteURL(context);
        Element processedMetadata = XslProcessUtils.process(context, String.valueOf(metadata.getId()), process, save, true, true, report, siteURL, request.getParameterMap());
        if (processedMetadata == null) {
            throw new BadParameterEx("Processing failed", (Object)("Not found:" + report.getNumberOfRecordNotFound() + ", Not owner:" + report.getNumberOfRecordsNotEditable() + ", No process found:" + report.getNoProcessFoundCount() + "."));
        }
        UserSession userSession = context.getUserSession();
        if (userSession != null) {
            XMLOutputter outp = new XMLOutputter();
            String xmlAfter = outp.outputString(processedMetadata);
            String xmlBefore = outp.outputString(beforeMetadata);
            new RecordProcessingChangeEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(Integer.parseInt(userSession.getUserId())), xmlBefore, xmlAfter, process).publish((ApplicationContext)ApplicationContextHolder.get());
        }
        return processedMetadata;
    }
}

