/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.CurvedRing;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.gml3.bindings.LinearRingTypeBinding;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class RingTypeBinding
extends AbstractComplexBinding
implements Comparable {
    protected GeometryFactory gf;
    protected ArcParameters arcParameters;

    public RingTypeBinding(GeometryFactory gf) {
        this.gf = gf;
    }

    public QName getTarget() {
        return GML.RingType;
    }

    public Class getType() {
        return CurvedRing.class;
    }

    public int getExecutionMode() {
        return 2;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List members = node.getChildValues("curveMember");
        if (members.isEmpty()) {
            return null;
        }
        if (members.size() == 1) {
            Object o = members.get(0);
            if (o.getClass() == LineString.class) {
                LineString ls = (LineString)o;
                return this.gf.createLinearRing(ls.getCoordinates());
            }
            return members.get(0);
        }
        LineString curved = null;
        ArrayList<LineString> components = new ArrayList<LineString>();
        for (LineString ls : members) {
            if (ls instanceof CurvedGeometry) {
                curved = ls;
            }
            components.add(ls);
        }
        CurvedGeometryFactory factory = GML3ParsingUtils.getCurvedGeometryFactory(this.arcParameters, this.gf, curved != null ? curved.getCoordinateSequence() : null);
        return factory.createCurvedGeometry(components);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if ("curveMember".equals(name.getLocalPart())) {
            if (object instanceof CompoundCurvedGeometry) {
                CompoundCurvedGeometry curve = (CompoundCurvedGeometry)object;
                List components = curve.getComponents();
                return components;
            }
            return object;
        }
        return null;
    }

    public void setArcParameters(ArcParameters arcParameters) {
        this.arcParameters = arcParameters;
    }

    public int compareTo(Object o) {
        if (o instanceof LinearRingTypeBinding) {
            return -1;
        }
        return 0;
    }
}

