/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;

public class XPath {
    private XPath() {
    }

    public static String getXPath(Element target) throws JDOMException {
        Element root = target;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)root.getParent();
        }
        return XPath.getXPath(root, target);
    }

    public static String getXPath(Element root, Object target) throws JDOMException {
        StringBuffer xpath = null;
        xpath = root == target ? new StringBuffer("/").append(root.getQualifiedName()) : XPath.followXPath(root, target);
        return xpath.toString();
    }

    public static String getXPath(Element root, Element parent, Object target) throws JDOMException {
        return XPath.computeXPath(root, (Parent)parent, target).toString();
    }

    public static String getChildXPath(Element parent, Object target) throws JDOMException {
        String xpath = null;
        if (parent == target) {
            xpath = ".";
        } else {
            xpath = XPath.followXPath(parent, target).toString();
            if (xpath == null) {
                throw new JDOMException("the target element is not a descendant of the parent element");
            }
        }
        return xpath;
    }

    private static StringBuffer followXPath(Element root, Object target) throws JDOMException {
        StringBuffer xpath;
        if (target instanceof Element) {
            xpath = ((Element)target).isRootElement() ? XPath.computeXPath(root, null, target) : XPath.computeXPath(root, ((Element)target).getParent(), target);
        } else if (target instanceof Comment) {
            xpath = XPath.computeXPath(root, ((Comment)target).getParent(), target);
        } else if (target instanceof ProcessingInstruction) {
            xpath = XPath.computeXPath(root, ((ProcessingInstruction)target).getParent(), target);
        } else if (target instanceof EntityRef) {
            xpath = XPath.computeXPath(root, ((EntityRef)target).getParent(), target);
        } else {
            Element parent = XPath.findTarget(root, target);
            if (parent != null) {
                xpath = XPath.computeXPath(root, (Parent)parent, target);
            } else {
                throw new JDOMException("the target object is not in the tree (" + target + ")");
            }
        }
        return xpath;
    }

    private static StringBuffer computeXPath(Element root, Parent parent, Object target) throws JDOMException {
        StringBuffer xpath;
        if (target == root) {
            xpath = new StringBuffer("/").append(root.getQualifiedName());
        } else if (parent == root) {
            xpath = new StringBuffer("/").append(root.getQualifiedName());
            xpath.append(XPath.targetXPath((Element)parent, target));
        } else {
            xpath = XPath.computeXPathToNode(root, (Element)parent);
            xpath.append(XPath.targetXPath((Element)parent, target));
        }
        return xpath;
    }

    private static StringBuffer targetXPath(Element parent, Object child) throws JDOMException {
        StringBuffer xpath;
        if (parent == null || child == null) {
            throw new JDOMException("can't use null parent or child");
        }
        if (child instanceof Element) {
            xpath = new StringBuffer();
            xpath.append("/").append(((Element)child).getQualifiedName());
            int i = XPath.computeTwinIndex(parent, (Element)child);
            if (i > 0) {
                xpath.append("[").append(i).append("]");
            }
        } else {
            int i = XPath.computeChildIndex(parent, child);
            xpath = new StringBuffer("/self::node()[").append(i).append("]");
        }
        return xpath;
    }

    private static StringBuffer computeXPathToNode(Element root, Element node) throws JDOMException {
        StringBuffer xpath = new StringBuffer();
        Element n = node;
        if (root == null || node == null) {
            throw new JDOMException("can't use null root or node");
        }
        while (n != null) {
            int ti;
            Element p = null;
            if (n.getParent() != null && n.getParent() instanceof Element) {
                p = (Element)n.getParent();
            }
            if (p != null && (ti = XPath.computeTwinIndex(p, n)) > 0) {
                xpath.insert(0, "]");
                xpath.insert(0, ti);
                xpath.insert(0, "[");
            }
            xpath.insert(0, n.getQualifiedName());
            xpath.insert(0, "/");
            n = p;
        }
        return xpath;
    }

    private static Element findTarget(Element parent, Object target) {
        Element rslt = null;
        List children = parent.getContent();
        for (int i = 0; rslt == null && i < children.size(); ++i) {
            Object x = children.get(i);
            if (x == target) {
                rslt = parent;
                continue;
            }
            if (!(x instanceof Element)) continue;
            rslt = XPath.findTarget((Element)x, target);
        }
        return rslt;
    }

    public static Object getElement(Element root, String xpath) throws JDOMException {
        Object rslt;
        block10: {
            block7: {
                rslt = root.getParent();
                boolean atRoot = true;
                int pathPartStart = 0;
                if (xpath.charAt(0) != '/') break block7;
                pathPartStart = 1;
                while ((atRoot || rslt != null) && pathPartStart < xpath.length()) {
                    int pathPartEnd;
                    block9: {
                        String pathPart;
                        block8: {
                            pathPartEnd = xpath.indexOf(47, pathPartStart);
                            if (pathPartEnd < 0) {
                                pathPartEnd = xpath.length();
                            }
                            pathPart = xpath.substring(pathPartStart, pathPartEnd);
                            if (rslt != null) break block8;
                            if (!root.getQualifiedName().equals(pathPart)) break block9;
                            rslt = root;
                            break block9;
                        }
                        int doubleColon = -1;
                        int openBracket = -1;
                        doubleColon = pathPart.indexOf("self::node()[");
                        if (doubleColon >= 0) {
                            int childIndex = XPath.getIndex(pathPart);
                            List children = ((Element)rslt).getContent();
                            rslt = childIndex >= 0 && childIndex < children.size() ? children.get(childIndex) : null;
                        } else {
                            openBracket = pathPart.indexOf(91);
                            if (openBracket >= 0) {
                                String nodeName = XPath.getNodeName(pathPart);
                                int childIndex = XPath.getIndex(pathPart);
                                List<Element> children = XPath.getNamedChildren((Element)rslt, nodeName);
                                rslt = childIndex >= 0 && childIndex < children.size() ? children.get(childIndex) : null;
                            } else {
                                List children = ((Element)rslt).getChildren();
                                for (Element child : children) {
                                    if (!child.getQualifiedName().equals(pathPart)) continue;
                                    rslt = child;
                                    break;
                                }
                            }
                        }
                    }
                    pathPartStart = pathPartEnd + 1;
                    atRoot = false;
                }
                break block10;
            }
            throw new JDOMException("xpath is not absolute (must begin with '/')");
        }
        return rslt;
    }

    public static Element getParentElement(Element root, String xpath) throws JDOMException {
        Element rslt = null;
        String parentXpath = XPath.getParentXpath(xpath);
        if (parentXpath != null) {
            Object x = XPath.getElement(root, parentXpath);
            if (x instanceof Element) {
                rslt = (Element)x;
            } else {
                throw new JDOMException("parent element should be type Element, not " + x.getClass().getName());
            }
        }
        return rslt;
    }

    public static String getParentXpath(String xpath) {
        String rslt = null;
        int lastSlash = xpath.lastIndexOf(47);
        if (lastSlash >= 0) {
            rslt = xpath.substring(0, lastSlash);
        }
        return rslt;
    }

    public static String getNodeName(String pathPart) {
        return pathPart.substring(0, pathPart.indexOf(91));
    }

    public static int getIndex(String pathPart) throws JDOMException {
        int rslt = 0;
        int lbracket = pathPart.indexOf(91);
        int rbracket = pathPart.indexOf(93);
        if (rbracket == pathPart.length() - 1) {
            String numStr = pathPart.substring(lbracket + 1, rbracket);
            try {
                rslt = Integer.parseInt(numStr);
            }
            catch (NumberFormatException e) {
                throw new JDOMException("invalid index in \"" + pathPart + "\"");
            }
        } else {
            throw new JDOMException("index must be the last part of \"" + pathPart + "\"");
        }
        return rslt - 1;
    }

    private static List<Element> getNamedChildren(Element parent, String name) throws JDOMException {
        ArrayList<Element> children = new ArrayList<Element>();
        if (parent == null) {
            throw new JDOMException("can't use null parent");
        }
        for (Object child : parent.getChildren()) {
            if (!(child instanceof Element) || !((Element)child).getQualifiedName().equals(name)) continue;
            children.add((Element)child);
        }
        return children;
    }

    private static int computeTwinIndex(Element parent, Element child) throws JDOMException {
        int index = -1;
        if (parent == null) {
            throw new JDOMException("can't use null parent");
        }
        List<Element> identicalTwins = XPath.getNamedChildren(parent, child.getQualifiedName());
        if (identicalTwins.size() > 1) {
            for (int j = 0; index < 0 && j < identicalTwins.size(); ++j) {
                if (identicalTwins.get(j) != child) continue;
                index = j + 1;
            }
            if (index < 0) {
                throw new JDOMException("error in tree: node is not listed among its parent's children");
            }
        }
        return index;
    }

    private static int computeChildIndex(Element parent, Object child) throws JDOMException {
        int index = -1;
        List content = parent.getContent();
        for (int i = 0; index < 0 && i < content.size(); ++i) {
            if (content.get(i) != child) continue;
            index = i + 1;
        }
        if (index < 0) {
            throw new JDOMException("error in tree: object is not listed among its parent's children");
        }
        return index;
    }
}

