/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.keyword;

import java.text.MessageFormat;
import org.fao.geonet.kernel.rdf.Where;
import org.fao.geonet.kernel.rdf.Wheres;
import org.fao.geonet.kernel.search.keyword.KeywordLabelSearchClause;

public enum KeywordSearchType {
    STARTS_WITH("{0}*"),
    CONTAINS("*{0}*"),
    MATCH("{0}");

    private String template;

    private KeywordSearchType(String template) {
        this.template = template;
    }

    public static KeywordSearchType parseString(String param) {
        String processed = param.toUpperCase().trim();
        if ("0".equals(processed)) {
            return STARTS_WITH;
        }
        if ("1".equals(processed)) {
            return CONTAINS;
        }
        if ("2".equals(processed)) {
            return MATCH;
        }
        return KeywordSearchType.valueOf(processed);
    }

    public Where toWhere(String columnName, KeywordLabelSearchClause clause) {
        return this.toWhere(columnName, clause.keyword, clause.ignoreCase);
    }

    public Where toWhere(String columnName, String value, boolean ignoreCase) {
        String finalValue = MessageFormat.format(this.template, value);
        if (ignoreCase) {
            return Wheres.ilike(columnName, finalValue);
        }
        return Wheres.like(columnName, finalValue);
    }
}

