/*
 * Decompiled with CFR 0.152.
 */
package jeeves.component;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import jeeves.config.springutil.JeevesDelegatingFilterProxy;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;

public class ProfileManager {
    public static Profile getLowestProfile(String[] profiles) {
        Profile lowestProfile = null;
        int numberOfProfilesExtended = Profile.Administrator.getAll().size();
        for (String profileName : profiles) {
            Profile p = Profile.valueOf((String)profileName);
            Set currentProfileSet = p.getAll();
            if (currentProfileSet.size() >= numberOfProfilesExtended) continue;
            lowestProfile = p;
            numberOfProfilesExtended = currentProfileSet.size();
        }
        return lowestProfile;
    }

    public static Profile getHighestProfile(Profile[] profiles) {
        Profile highestProfile = null;
        int numberOfProfilesExtended = 0;
        for (Profile profile : profiles) {
            Set all = profile.getAll();
            if (all.size() <= numberOfProfilesExtended) continue;
            highestProfile = profile;
            numberOfProfilesExtended = all.size();
        }
        return highestProfile;
    }

    public static boolean existsBean(String beanId) {
        return ApplicationContextHolder.get().containsBean(beanId);
    }

    public static boolean isAccessibleService(Object serviceName) {
        ServiceContext serviceContext = ServiceContext.get();
        if (serviceContext == null) {
            return true;
        }
        ServletContext servletContext = serviceContext.getServlet().getServletContext();
        ConfigurableApplicationContext springContext = JeevesDelegatingFilterProxy.getApplicationContextFromServletContext(servletContext);
        SecurityContext context = SecurityContextHolder.getContext();
        if (springContext == null || context == null) {
            return true;
        }
        Map evals = springContext.getBeansOfType(AbstractSecurityInterceptor.class);
        Authentication authentication = context.getAuthentication();
        FilterInvocation fi = new FilterInvocation(null, "/srv/" + serviceContext.getLanguage() + "/" + serviceName, null);
        for (AbstractSecurityInterceptor securityInterceptor : evals.values()) {
            if (securityInterceptor == null) {
                return true;
            }
            Collection attrs = securityInterceptor.obtainSecurityMetadataSource().getAttributes((Object)fi);
            if (attrs == null || authentication == null) continue;
            try {
                securityInterceptor.getAccessDecisionManager().decide(authentication, (Object)fi, attrs);
                return true;
            }
            catch (AccessDeniedException accessDeniedException) {
            }
        }
        if (Log.isDebugEnabled((String)"jeeves.request")) {
            Log.debug((String)"jeeves.request", (Object)(fi.toString() + " denied for " + authentication.toString()));
        }
        return false;
    }

    public static boolean isCasEnabled() {
        return ProfileManager.existsBean("casEntryPoint");
    }

    public boolean exists(String profile) {
        return Profile.exists((String)profile);
    }

    public Profile getCorrectCase(String profileName) {
        return Profile.findProfileIgnoreCase((String)profileName);
    }

    public Profile getProfile(String profileName) {
        return Profile.valueOf((String)profileName);
    }

    public Element getProfilesElement(Profile profile) {
        return profile.asElement();
    }
}

