/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;
import javax.annotation.Nullable;

class PeepholeRemoveDeadCode
extends AbstractPeepholeOptimization {
    static final Predicate<Node> MATCH_UNNAMED_BREAK = new MatchUnnamedBreak();

    PeepholeRemoveDeadCode() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        switch (subtree.getType()) {
            case 86: {
                return this.tryFoldAssignment(subtree);
            }
            case 85: {
                return this.tryFoldComma(subtree);
            }
            case 125: 
            case 132: {
                return this.tryOptimizeBlock(subtree);
            }
            case 130: {
                subtree = this.tryFoldExpr(subtree);
                return subtree;
            }
            case 98: {
                return this.tryFoldHook(subtree);
            }
            case 110: {
                return this.tryOptimizeSwitch(subtree);
            }
            case 108: {
                return this.tryFoldIf(subtree);
            }
            case 113: {
                return this.tryFoldWhile(subtree);
            }
            case 115: {
                Node condition = NodeUtil.getConditionExpression(subtree);
                if (condition != null) {
                    this.tryFoldForCondition(condition);
                }
                return this.tryFoldFor(subtree);
            }
            case 114: {
                Node foldedDo = this.tryFoldDoAway(subtree);
                if (foldedDo.isDo()) {
                    return this.tryFoldEmptyDo(foldedDo);
                }
                return foldedDo;
            }
            case 77: {
                return this.tryFoldTry(subtree);
            }
        }
        return subtree;
    }

    private Node tryFoldTry(Node n) {
        Preconditions.checkState((boolean)n.isTry());
        Node body = n.getFirstChild();
        Node catchBlock = body.getNext();
        Node finallyBlock = catchBlock.getNext();
        if (!(catchBlock.hasChildren() || finallyBlock != null && finallyBlock.hasChildren())) {
            n.removeChild(body);
            n.getParent().replaceChild(n, body);
            this.reportCodeChange();
            return body;
        }
        if (!body.hasChildren()) {
            NodeUtil.redeclareVarsInsideBranch(catchBlock);
            if (finallyBlock != null) {
                n.removeChild(finallyBlock);
                n.getParent().replaceChild(n, finallyBlock);
            } else {
                n.getParent().removeChild(n);
            }
            this.reportCodeChange();
            return finallyBlock;
        }
        return n;
    }

    private Node tryFoldAssignment(Node subtree) {
        Preconditions.checkState((boolean)subtree.isAssign());
        Node left = subtree.getFirstChild();
        Node right = subtree.getLastChild();
        if (left.isName() && right.isName() && left.getString().equals(right.getString())) {
            subtree.getParent().replaceChild(subtree, right.detachFromParent());
            this.reportCodeChange();
            return right;
        }
        return subtree;
    }

    private Node tryFoldExpr(Node subtree) {
        Node result = this.trySimplifyUnusedResult(subtree.getFirstChild());
        if (result == null) {
            Node parent = subtree.getParent();
            if (parent.isLabel()) {
                Node replacement = IR.block().srcref(subtree);
                parent.replaceChild(subtree, replacement);
                subtree = replacement;
            } else {
                subtree.detachFromParent();
                subtree = null;
            }
        }
        return subtree;
    }

    private Node trySimplifyUnusedResult(Node n) {
        return this.trySimplifyUnusedResult(n, true);
    }

    private Node trySimplifyUnusedResult(Node n, boolean removeUnused) {
        Node result = n;
        switch (n.getType()) {
            case 98: {
                Node trueNode = this.trySimplifyUnusedResult(n.getFirstChild().getNext());
                Node falseNode = this.trySimplifyUnusedResult(n.getLastChild());
                if (trueNode == null && falseNode != null) {
                    n.setType(100);
                    Preconditions.checkState((n.getChildCount() == 2 ? 1 : 0) != 0);
                    break;
                }
                if (trueNode != null && falseNode == null) {
                    n.setType(101);
                    Preconditions.checkState((n.getChildCount() == 2 ? 1 : 0) != 0);
                    break;
                }
                if (trueNode == null && falseNode == null) {
                    result = this.trySimplifyUnusedResult(n.getFirstChild());
                    break;
                }
                result = n;
                break;
            }
            case 100: 
            case 101: {
                Node conditionalResultNode = this.trySimplifyUnusedResult(n.getLastChild());
                if (conditionalResultNode != null) break;
                Preconditions.checkState((boolean)n.hasOneChild());
                result = this.trySimplifyUnusedResult(n.getFirstChild());
                break;
            }
            case 105: {
                result = null;
                break;
            }
            case 85: {
                Node left = this.trySimplifyUnusedResult(n.getFirstChild());
                Node right = this.trySimplifyUnusedResult(n.getLastChild());
                if (left == null && right == null) {
                    result = null;
                    break;
                }
                if (left == null) {
                    result = right;
                    break;
                }
                if (right == null) {
                    result = left;
                    break;
                }
                result = n;
                break;
            }
            default: {
                if (this.nodeTypeMayHaveSideEffects(n)) break;
                Node resultList = null;
                Node c = n.getFirstChild();
                while (c != null) {
                    Node next = c.getNext();
                    if ((c = this.trySimplifyUnusedResult(c)) != null) {
                        c.detachFromParent();
                        resultList = resultList == null ? c : IR.comma(resultList, c).srcref(c);
                    }
                    c = next;
                }
                result = resultList;
            }
        }
        if (n != result) {
            Node parent = n.getParent();
            if (result == null) {
                if (removeUnused) {
                    parent.removeChild(n);
                } else {
                    result = IR.empty().srcref(n);
                    parent.replaceChild(n, result);
                }
            } else {
                if (result.getParent() != null) {
                    result.detachFromParent();
                }
                n.getParent().replaceChild(n, result);
            }
            this.reportCodeChange();
        }
        return result;
    }

    private Node tryOptimizeSwitch(Node n) {
        Preconditions.checkState((boolean)n.isSwitch());
        Node defaultCase = this.tryOptimizeDefaultCase(n);
        if (defaultCase == null) {
            Node cond = n.getFirstChild();
            Node prev = null;
            Node next = null;
            Node cur = cond.getNext();
            while (cur != null) {
                next = cur.getNext();
                if (!this.mayHaveSideEffects(cur.getFirstChild()) && this.isUselessCase(cur, prev)) {
                    this.removeCase(n, cur);
                } else {
                    prev = cur;
                }
                cur = next;
            }
            if (NodeUtil.isLiteralValue(cond, false)) {
                TernaryValue caseMatches = TernaryValue.TRUE;
                cur = cond.getNext();
                while (cur != null) {
                    next = cur.getNext();
                    Node caseLabel = cur.getFirstChild();
                    caseMatches = PeepholeFoldConstants.evaluateComparison(45, cond, caseLabel);
                    if (caseMatches == TernaryValue.TRUE || caseMatches == TernaryValue.UNKNOWN) break;
                    this.removeCase(n, cur);
                    cur = next;
                }
                if (caseMatches != TernaryValue.UNKNOWN) {
                    Node block;
                    while (cur != null) {
                        block = cur.getLastChild();
                        Node lastStm = block.getLastChild();
                        cur = cur.getNext();
                        if (lastStm == null || !lastStm.isBreak() || lastStm.hasChildren()) continue;
                        block.removeChild(lastStm);
                        this.reportCodeChange();
                        break;
                    }
                    while (cur != null) {
                        next = cur.getNext();
                        this.removeCase(n, cur);
                        cur = next;
                    }
                    cur = cond.getNext();
                    if (cur != null && cur.getNext() == null && !NodeUtil.has(block = cur.getLastChild(), MATCH_UNNAMED_BREAK, NodeUtil.MATCH_NOT_FUNCTION)) {
                        cur.removeChild(block);
                        block.setIsSyntheticBlock(false);
                        n.getParent().replaceChild(n, block);
                        this.reportCodeChange();
                        return block;
                    }
                }
            }
        }
        if (n.hasOneChild()) {
            Node condition = n.removeFirstChild();
            Node replacement = IR.exprResult(condition).srcref(n);
            n.getParent().replaceChild(n, replacement);
            this.reportCodeChange();
            return replacement;
        }
        return null;
    }

    private Node tryOptimizeDefaultCase(Node n) {
        Preconditions.checkState((boolean)n.isSwitch());
        Node lastNonRemovable = n.getFirstChild();
        for (Node c = n.getFirstChild().getNext(); c != null; c = c.getNext()) {
            if (c.isDefaultCase()) {
                Node prevCase;
                Node caseToRemove = lastNonRemovable.getNext();
                while (caseToRemove != c) {
                    Node next = caseToRemove.getNext();
                    this.removeCase(n, caseToRemove);
                    caseToRemove = next;
                }
                Node node = prevCase = lastNonRemovable == n.getFirstChild() ? null : lastNonRemovable;
                if (this.isUselessCase(c, prevCase)) {
                    this.removeCase(n, c);
                    return null;
                }
                return c;
            }
            Preconditions.checkState((boolean)c.isCase());
            if (!c.getLastChild().hasChildren() && !this.mayHaveSideEffects(c.getFirstChild())) continue;
            lastNonRemovable = c;
        }
        return null;
    }

    private void removeCase(Node switchNode, Node caseNode) {
        NodeUtil.redeclareVarsInsideBranch(caseNode);
        switchNode.removeChild(caseNode);
        this.reportCodeChange();
    }

    private boolean isUselessCase(Node caseNode, @Nullable Node previousCase) {
        Node previousBlock;
        Preconditions.checkState((previousCase == null || previousCase.getNext() == caseNode ? 1 : 0) != 0);
        Node switchNode = caseNode.getParent();
        if (!(switchNode.getLastChild() == caseNode || previousCase == null || (previousBlock = previousCase.getLastChild()).hasChildren() && PeepholeRemoveDeadCode.isExit(previousBlock.getLastChild()))) {
            return false;
        }
        for (Node executingCase = caseNode; executingCase != null; executingCase = executingCase.getNext()) {
            Preconditions.checkState((executingCase.isDefaultCase() || executingCase.isCase() ? 1 : 0) != 0);
            Preconditions.checkState((caseNode == executingCase || !executingCase.isDefaultCase() ? 1 : 0) != 0);
            Node block = executingCase.getLastChild();
            Preconditions.checkState((boolean)block.isBlock());
            if (!block.hasChildren()) continue;
            block5: for (Node blockChild : block.children()) {
                switch (blockChild.getType()) {
                    case 116: {
                        return blockChild.getFirstChild() == null;
                    }
                    case 118: {
                        if (blockChild.hasOneChild() && blockChild.getFirstChild().getFirstChild() == null) continue block5;
                        return false;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private static boolean isExit(Node n) {
        switch (n.getType()) {
            case 4: 
            case 49: 
            case 116: 
            case 117: {
                return true;
            }
        }
        return false;
    }

    private Node tryFoldComma(Node n) {
        Node parent = n.getParent();
        Node left = n.getFirstChild();
        Node right = left.getNext();
        if ((left = this.trySimplifyUnusedResult(left)) == null || !this.mayHaveSideEffects(left)) {
            n.removeChild(right);
            parent.replaceChild(n, right);
            this.reportCodeChange();
            return right;
        }
        return n;
    }

    Node tryOptimizeBlock(Node n) {
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            if (!PeepholeRemoveDeadCode.isUnremovableNode(c) && !this.mayHaveSideEffects(c)) {
                n.removeChild(c);
                this.reportCodeChange();
            } else {
                this.tryOptimizeConditionalAfterAssign(c);
            }
            c = next;
        }
        if (n.isSyntheticBlock() || n.isScript() || n.getParent() == null) {
            return n;
        }
        if (NodeUtil.tryMergeBlock(n)) {
            this.reportCodeChange();
            return null;
        }
        return n;
    }

    private static boolean isUnremovableNode(Node n) {
        return n.isBlock() && n.isSyntheticBlock() || n.isScript();
    }

    private void tryOptimizeConditionalAfterAssign(Node n) {
        Node next = n.getNext();
        if (PeepholeRemoveDeadCode.isSimpleAssignment(n) && this.isConditionalStatement(next)) {
            Node rhsAssign;
            TernaryValue value;
            Node lhsAssign = this.getSimpleAssignmentName(n);
            Node condition = this.getConditionalStatementCondition(next);
            if (lhsAssign.isName() && condition.isName() && lhsAssign.getString().equals(condition.getString()) && (value = NodeUtil.getImpureBooleanValue(rhsAssign = this.getSimpleAssignmentValue(n))) != TernaryValue.UNKNOWN) {
                Node replacementConditionNode = NodeUtil.booleanNode(value.toBoolean(true));
                condition.getParent().replaceChild(condition, replacementConditionNode);
                this.reportCodeChange();
            }
        }
    }

    private static boolean isSimpleAssignment(Node n) {
        if (NodeUtil.isExprAssign(n) && n.getFirstChild().getFirstChild().isName()) {
            return true;
        }
        return n.isVar() && n.hasOneChild() && n.getFirstChild().getFirstChild() != null;
    }

    private Node getSimpleAssignmentName(Node n) {
        Preconditions.checkState((boolean)PeepholeRemoveDeadCode.isSimpleAssignment(n));
        if (NodeUtil.isExprAssign(n)) {
            return n.getFirstChild().getFirstChild();
        }
        return n.getFirstChild();
    }

    private Node getSimpleAssignmentValue(Node n) {
        Preconditions.checkState((boolean)PeepholeRemoveDeadCode.isSimpleAssignment(n));
        return n.getFirstChild().getLastChild();
    }

    private boolean isConditionalStatement(Node n) {
        return n != null && (n.isIf() || PeepholeRemoveDeadCode.isExprConditional(n));
    }

    private static boolean isExprConditional(Node n) {
        if (n.isExprResult()) {
            switch (n.getFirstChild().getType()) {
                case 98: 
                case 100: 
                case 101: {
                    return true;
                }
            }
        }
        return false;
    }

    private Node getConditionalStatementCondition(Node n) {
        if (n.isIf()) {
            return NodeUtil.getConditionExpression(n);
        }
        Preconditions.checkState((boolean)PeepholeRemoveDeadCode.isExprConditional(n));
        return n.getFirstChild().getFirstChild();
    }

    private Node tryFoldIf(Node n) {
        Preconditions.checkState((boolean)n.isIf());
        Node parent = n.getParent();
        Preconditions.checkNotNull((Object)parent);
        int type = n.getType();
        Node cond = n.getFirstChild();
        Node thenBody = cond.getNext();
        Node elseBody = thenBody.getNext();
        if (elseBody != null && !this.mayHaveSideEffects(elseBody)) {
            n.removeChild(elseBody);
            elseBody = null;
            this.reportCodeChange();
        }
        if (!this.mayHaveSideEffects(thenBody) && elseBody != null) {
            n.removeChild(elseBody);
            n.replaceChild(thenBody, elseBody);
            Node notCond = new Node(26);
            n.replaceChild(cond, notCond);
            notCond.addChildToFront(cond);
            cond = notCond;
            thenBody = cond.getNext();
            elseBody = null;
            this.reportCodeChange();
        }
        if (!this.mayHaveSideEffects(thenBody) && elseBody == null) {
            if (this.mayHaveSideEffects(cond)) {
                n.removeChild(cond);
                Node replacement = NodeUtil.newExpr(cond);
                parent.replaceChild(n, replacement);
                this.reportCodeChange();
                return replacement;
            }
            NodeUtil.removeChild(parent, n);
            this.reportCodeChange();
            return null;
        }
        TernaryValue condValue = NodeUtil.getImpureBooleanValue(cond);
        if (condValue == TernaryValue.UNKNOWN) {
            return n;
        }
        if (this.mayHaveSideEffects(cond)) {
            boolean newConditionValue;
            boolean bl = newConditionValue = condValue == TernaryValue.TRUE;
            if (!newConditionValue && elseBody == null) {
                elseBody = IR.block().srcref(n);
                n.addChildToBack(elseBody);
            }
            Node newCond = NodeUtil.booleanNode(newConditionValue);
            n.replaceChild(cond, newCond);
            Node branchToKeep = newConditionValue ? thenBody : elseBody;
            branchToKeep.addChildToFront(IR.exprResult(cond).srcref(cond));
            this.reportCodeChange();
            cond = newCond;
        }
        boolean condTrue = condValue.toBoolean(true);
        if (n.getChildCount() == 2) {
            Preconditions.checkState((type == 108 ? 1 : 0) != 0);
            if (condTrue) {
                Node thenStmt = n.getFirstChild().getNext();
                n.removeChild(thenStmt);
                parent.replaceChild(n, thenStmt);
                this.reportCodeChange();
                return thenStmt;
            }
            NodeUtil.redeclareVarsInsideBranch(n);
            NodeUtil.removeChild(parent, n);
            this.reportCodeChange();
            return null;
        }
        Node trueBranch = n.getFirstChild().getNext();
        Node falseBranch = trueBranch.getNext();
        Node branchToKeep = condTrue ? trueBranch : falseBranch;
        Node branchToRemove = condTrue ? falseBranch : trueBranch;
        NodeUtil.redeclareVarsInsideBranch(branchToRemove);
        n.removeChild(branchToKeep);
        parent.replaceChild(n, branchToKeep);
        this.reportCodeChange();
        return branchToKeep;
    }

    private Node tryFoldHook(Node n) {
        Preconditions.checkState((boolean)n.isHook());
        Node parent = n.getParent();
        Preconditions.checkNotNull((Object)parent);
        Node cond = n.getFirstChild();
        Node thenBody = cond.getNext();
        Node elseBody = thenBody.getNext();
        TernaryValue condValue = NodeUtil.getImpureBooleanValue(cond);
        if (condValue == TernaryValue.UNKNOWN && !this.areNodesEqualForInlining(thenBody, elseBody)) {
            return n;
        }
        Node branchToKeep = condValue.toBoolean(true) ? thenBody : elseBody;
        boolean condHasSideEffects = this.mayHaveSideEffects(cond);
        n.detachChildren();
        Node replacement = condHasSideEffects ? IR.comma(cond, branchToKeep).srcref(n) : branchToKeep;
        parent.replaceChild(n, replacement);
        this.reportCodeChange();
        return replacement;
    }

    Node tryFoldWhile(Node n) {
        Preconditions.checkArgument((boolean)n.isWhile());
        Node cond = NodeUtil.getConditionExpression(n);
        if (NodeUtil.getPureBooleanValue(cond) != TernaryValue.FALSE) {
            return n;
        }
        NodeUtil.redeclareVarsInsideBranch(n);
        NodeUtil.removeChild(n.getParent(), n);
        this.reportCodeChange();
        return null;
    }

    Node tryFoldFor(Node n) {
        Preconditions.checkArgument((boolean)n.isFor());
        if (NodeUtil.isForIn(n)) {
            return n;
        }
        Node init = n.getFirstChild();
        Node cond = init.getNext();
        Node increment = cond.getNext();
        if (!init.isEmpty() && !init.isVar()) {
            init = this.trySimplifyUnusedResult(init, false);
        }
        if (!increment.isEmpty()) {
            increment = this.trySimplifyUnusedResult(increment, false);
        }
        if (!n.getFirstChild().isEmpty()) {
            return n;
        }
        if (NodeUtil.getImpureBooleanValue(cond) != TernaryValue.FALSE) {
            return n;
        }
        Node parent = n.getParent();
        NodeUtil.redeclareVarsInsideBranch(n);
        if (!this.mayHaveSideEffects(cond)) {
            NodeUtil.removeChild(parent, n);
        } else {
            Node statement = IR.exprResult(cond.detachFromParent()).copyInformationFrom(cond);
            if (parent.isLabel()) {
                Node block = IR.block();
                block.copyInformationFrom(statement);
                block.addChildToFront(statement);
                statement = block;
            }
            parent.replaceChild(n, statement);
        }
        this.reportCodeChange();
        return null;
    }

    Node tryFoldDoAway(Node n) {
        Preconditions.checkArgument((boolean)n.isDo());
        Node cond = NodeUtil.getConditionExpression(n);
        if (NodeUtil.getImpureBooleanValue(cond) != TernaryValue.FALSE) {
            return n;
        }
        if (PeepholeRemoveDeadCode.hasBreakOrContinue(n)) {
            return n;
        }
        Preconditions.checkState((boolean)NodeUtil.isControlStructureCodeBlock(n, n.getFirstChild()));
        Node block = n.removeFirstChild();
        Node parent = n.getParent();
        parent.replaceChild(n, block);
        if (this.mayHaveSideEffects(cond)) {
            Node condStatement = IR.exprResult(cond.detachFromParent()).srcref(cond);
            parent.addChildAfter(condStatement, block);
        }
        this.reportCodeChange();
        return block;
    }

    Node tryFoldEmptyDo(Node n) {
        Preconditions.checkArgument((boolean)n.isDo());
        Node body = NodeUtil.getLoopCodeBlock(n);
        if (body.isBlock() && !body.hasChildren()) {
            Node cond = NodeUtil.getConditionExpression(n);
            Node whileNode = IR.forNode(IR.empty().srcref(n), cond.detachFromParent(), IR.empty().srcref(n), body.detachFromParent()).srcref(n);
            n.getParent().replaceChild(n, whileNode);
            this.reportCodeChange();
            return whileNode;
        }
        return n;
    }

    static boolean hasBreakOrContinue(Node n) {
        return NodeUtil.has(n, (Predicate<Node>)Predicates.or((Predicate)new NodeUtil.MatchNodeType(116), (Predicate)new NodeUtil.MatchNodeType(117)), NodeUtil.MATCH_NOT_FUNCTION);
    }

    private void tryFoldForCondition(Node forCondition) {
        if (NodeUtil.getPureBooleanValue(forCondition) == TernaryValue.TRUE) {
            forCondition.getParent().replaceChild(forCondition, IR.empty());
            this.reportCodeChange();
        }
    }

    private static class MatchUnnamedBreak
    implements Predicate<Node> {
        private MatchUnnamedBreak() {
        }

        public boolean apply(Node n) {
            return n.isBreak() && !n.hasChildren();
        }
    }
}

