/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;
import java.io.Serializable;

public class LongRange
implements Comparable,
Serializable {
    private long first;
    private long last;

    public LongRange(long first, long last) {
        if (last < first) {
            Exceptions.invalidRangeBounds(String.valueOf(first), String.valueOf(last));
        }
        this.first = first;
        this.last = last;
    }

    public long first() {
        return this.first;
    }

    public long last() {
        return this.last;
    }

    public int length() {
        return (int)(this.last - this.first + 1L);
    }

    public boolean intersects(LongRange range) {
        return this.first >= range.first && this.first <= range.last || range.first >= this.first && range.first <= this.last;
    }

    public boolean adjacentTo(LongRange range) {
        return this.last + 1L == range.first || range.last + 1L == this.first;
    }

    public boolean canMergeWith(LongRange range) {
        return this.intersects(range) || this.adjacentTo(range);
    }

    public LongRange mergeWith(LongRange range) {
        if (!this.canMergeWith(range)) {
            Exceptions.cannotMergeRanges(this, range);
        }
        return this.quickMergeWith(range);
    }

    private LongRange quickMergeWith(LongRange range) {
        long nfirst = this.first < range.first ? this.first : range.first;
        long nlast = this.last > range.last ? this.last : range.last;
        return new LongRange(nfirst, nlast);
    }

    public LongRange tryMergeWith(LongRange range) {
        if (!this.canMergeWith(range)) {
            return null;
        }
        return this.quickMergeWith(range);
    }

    public int intersectionLength(LongRange range) {
        int len;
        if (this.first >= range.first && this.first <= range.last) {
            long end = this.last <= range.last ? this.last : range.last;
            len = (int)(end - this.first) + 1;
        } else if (range.first >= this.first && range.first <= this.last) {
            long end = this.last <= range.last ? this.last : range.last;
            len = (int)(end - range.first) + 1;
        } else {
            len = 0;
        }
        return len;
    }

    public boolean contains(long v) {
        return v >= this.first && v <= this.last;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongRange)) {
            return false;
        }
        LongRange range = (LongRange)obj;
        return this.first == range.first && this.last == range.last;
    }

    public int compareTo(Object obj) {
        LongRange range = (LongRange)obj;
        if (this.first < range.first) {
            return -1;
        }
        if (this.first > range.first) {
            return 1;
        }
        if (this.last < range.last) {
            return -1;
        }
        if (this.last > range.last) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)(this.first ^ this.last);
    }

    public String toString() {
        return Display.display(this.first) + "-" + Display.display(this.last);
    }
}

