/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;
import java.io.Serializable;

public class ByteRange
implements Comparable,
Serializable {
    private byte first;
    private byte last;

    public ByteRange(byte first, byte last) {
        if (last < first) {
            Exceptions.invalidRangeBounds(String.valueOf(first), String.valueOf(last));
        }
        this.first = first;
        this.last = last;
    }

    public byte first() {
        return this.first;
    }

    public byte last() {
        return this.last;
    }

    public int length() {
        return this.last - this.first + 1;
    }

    public boolean intersects(ByteRange range) {
        return this.first >= range.first && this.first <= range.last || range.first >= this.first && range.first <= this.last;
    }

    public boolean adjacentTo(ByteRange range) {
        return this.last + 1 == range.first || range.last + 1 == this.first;
    }

    public boolean canMergeWith(ByteRange range) {
        return this.intersects(range) || this.adjacentTo(range);
    }

    public ByteRange mergeWith(ByteRange range) {
        if (!this.canMergeWith(range)) {
            Exceptions.cannotMergeRanges(this, range);
        }
        return this.quickMergeWith(range);
    }

    private ByteRange quickMergeWith(ByteRange range) {
        byte nfirst = this.first < range.first ? this.first : range.first;
        byte nlast = this.last > range.last ? this.last : range.last;
        return new ByteRange(nfirst, nlast);
    }

    public ByteRange tryMergeWith(ByteRange range) {
        if (!this.canMergeWith(range)) {
            return null;
        }
        return this.quickMergeWith(range);
    }

    public int intersectionLength(ByteRange range) {
        int len;
        if (this.first >= range.first && this.first <= range.last) {
            byte end = this.last <= range.last ? this.last : range.last;
            len = end - this.first + 1;
        } else if (range.first >= this.first && range.first <= this.last) {
            byte end = this.last <= range.last ? this.last : range.last;
            len = end - range.first + 1;
        } else {
            len = 0;
        }
        return len;
    }

    public boolean contains(byte v) {
        return v >= this.first && v <= this.last;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteRange)) {
            return false;
        }
        ByteRange range = (ByteRange)obj;
        return this.first == range.first && this.last == range.last;
    }

    public int compareTo(Object obj) {
        ByteRange range = (ByteRange)obj;
        if (this.first < range.first) {
            return -1;
        }
        if (this.first > range.first) {
            return 1;
        }
        if (this.last < range.last) {
            return -1;
        }
        if (this.last > range.last) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.first ^ this.last;
    }

    public String toString() {
        return Display.display(this.first) + "-" + Display.display(this.last);
    }
}

