/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.LongCollection;
import bak.pcj.adapter.CollectionToLongCollectionAdapter;
import bak.pcj.adapter.SetToShortSetAdapter;
import bak.pcj.map.AbstractShortKeyLongMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyLongMap;
import bak.pcj.map.ShortKeyLongMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToShortKeyLongMapAdapter
extends AbstractShortKeyLongMap
implements ShortKeyLongMap {
    protected Map map;
    protected Long lastValue;

    public MapToShortKeyLongMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToShortKeyLongMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(short key) {
        this.lastValue = (Long)this.map.get(new Short(key));
        return this.lastValue != null;
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(new Long(value));
    }

    public ShortKeyLongMapIterator entries() {
        return new ShortKeyLongMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToShortKeyLongMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public short getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getKey();
            }

            public long getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Long)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public long get(short key) {
        Long value = (Long)this.map.get(new Short(key));
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public ShortSet keySet() {
        return new SetToShortSetAdapter(this.map.keySet());
    }

    public long lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public long put(short key, long value) {
        Long oldValue = this.map.put(new Short(key), new Long(value));
        return oldValue == null ? MapDefaults.defaultLong() : oldValue;
    }

    public long remove(short key) {
        Long value = (Long)this.map.remove(new Short(key));
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public int size() {
        return this.map.size();
    }

    public LongCollection values() {
        return new CollectionToLongCollectionAdapter(this.map.values());
    }

    public long tget(short key) {
        Long value = (Long)this.map.get(new Short(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isShortKeyLongAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

