/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.comp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.comp.ModuleInfo;
import org.jzkit.a2j.codec.comp.TaggedMember;

public abstract class TypeInfo {
    protected String type_reference;
    protected int tag_class;
    protected int tag_number;
    protected boolean is_implicit;
    protected String basetype;
    protected boolean has_tagging = false;
    protected String internal_type;
    protected boolean extends_builtin_type;
    protected ModuleInfo parent = null;
    protected Vector cons_members = new Vector();
    protected String codec_class_name = null;
    protected String type_class_name = null;
    protected Set codecs_used_by_this_codec = Collections.synchronizedSet(new HashSet());
    private static Logger log = Logger.getLogger(TypeInfo.class.getName());

    public TypeInfo(String type_reference, boolean builtin_type, int tag_class, int tag_number, boolean is_implicit, String basetype, String internal_type, ModuleInfo parent) {
        this.type_reference = type_reference;
        this.extends_builtin_type = builtin_type;
        this.has_tagging = true;
        this.tag_class = tag_class;
        this.tag_number = tag_number;
        this.is_implicit = is_implicit;
        this.basetype = basetype;
        this.internal_type = internal_type;
        this.parent = parent;
        this.codec_class_name = type_reference.replace('-', '_') + "_codec";
        this.type_class_name = type_reference.replace('-', '_') + "_type";
        log.fine("TypeInfo::TypeInfo(" + type_reference + "," + builtin_type + "," + tag_class + "," + tag_number + "," + is_implicit + "," + basetype + "," + internal_type + ")");
    }

    public TypeInfo(String type_reference, boolean builtin_type, String basetype, String internal_type, ModuleInfo parent) {
        this.type_reference = type_reference;
        this.extends_builtin_type = builtin_type;
        this.basetype = basetype;
        this.internal_type = internal_type;
        this.parent = parent;
        this.codec_class_name = type_reference.replace('-', '_');
        log.fine("TypeInfo::TypeInfo(" + type_reference + "," + builtin_type + "," + basetype + "," + internal_type + ")");
    }

    public void registerTaggedMember(String element_name, int tag_class, int tag_number, boolean is_implicit, String type_reference, boolean is_optional) {
        this.cons_members.add(new TaggedMember(element_name, type_reference, tag_class, tag_number, is_implicit, is_optional));
    }

    public void registerTaggedMember(String element_name, int tag_class, int tag_number, boolean is_implicit, String type_reference, boolean is_optional, Object default_value) {
        this.cons_members.add(new TaggedMember(element_name, type_reference, tag_class, tag_number, is_implicit, is_optional, default_value));
    }

    public void createCode() {
        Enumeration e = this.cons_members.elements();
        while (e.hasMoreElements()) {
            TaggedMember t = (TaggedMember)e.nextElement();
            log.fine("Processing Element name: " + t.getMemberName() + " " + t.getTypeReference());
            TypeInfo ti = this.parent.lookup(t.getModuleReference(), t.getTypeReference(), true);
            if (null != ti) {
                this.registerUsedCodec(ti);
                continue;
            }
            log.log(Level.WARNING, "Unable to lookup type info for " + t.getTypeReference() + " element name is " + t.getMemberName());
        }
        log.fine("Create codec file");
        this.createCodecClassFile();
        log.fine("Create type file");
        this.createTypeClassFile();
    }

    public void createCodecClassFile() {
        String codec_file_name = this.parent.getModulePackageDir() + File.separatorChar + this.type_reference.replace('-', '_') + "_codec.java";
        File codec_source_file = new File(codec_file_name);
        FileWriter codec_writer = null;
        try {
            if (codec_source_file.exists()) {
                log.fine(codec_file_name + " codec already exists");
            } else {
                log.fine("            create codec source file : " + codec_file_name);
                codec_source_file.createNewFile();
            }
            codec_writer = new FileWriter(codec_source_file);
            log.fine("Package is " + this.parent.getModulePackageName() + "." + this.type_reference.replace('-', '_'));
            StringWriter imports_stream = new StringWriter();
            StringWriter declarations_stream = new StringWriter();
            StringWriter static_get_stream = new StringWriter();
            StringWriter serialize_method_stream = new StringWriter();
            codec_writer.write("package " + this.parent.getModulePackageName() + ";\n\n");
            codec_writer.write("// For logging\nimport java.util.logging.*;\n");
            codec_writer.write("import java.math.BigInteger;\n");
            this.parent.addImportStatementsToClass(imports_stream, true, true);
            codec_writer.write("import org.jzkit.a2j.codec.runtime.*;\n");
            codec_writer.write("import org.jzkit.a2j.gen.AsnUseful.*;\n\n");
            codec_writer.write(imports_stream.toString());
            codec_writer.write("/** \n *  A Java codec for the ASN type : " + this.codec_class_name + " \n");
            codec_writer.write(" *  @author Auto generated by A2J: An ASN to Java Precompiler - http://developer.k-int.com/projects/a2j\n");
            codec_writer.write(" */ \n");
            codec_writer.write("public class " + this.codec_class_name + " extends base_codec\n{\n");
            codec_writer.write("  private static transient Logger cat = Logger.getLogger(" + this.codec_class_name + ".class.getName());\n");
            this.createStaticGetMethod(static_get_stream, declarations_stream);
            this.writeSerializeMethod(serialize_method_stream, declarations_stream);
            codec_writer.write(declarations_stream.toString());
            codec_writer.write(static_get_stream.toString());
            codec_writer.write(serialize_method_stream.toString());
            codec_writer.write("\n}\n");
            codec_writer.flush();
            codec_writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(0);
        }
    }

    public abstract void createTypeClassFile();

    public void createStaticGetMethod(StringWriter func, StringWriter declarations) {
        declarations.write("  public static " + this.codec_class_name + " me = null;\n\n");
        func.write("  public synchronized static " + this.codec_class_name + " getCodec()\n  {\n");
        func.write("    if ( me == null )\n    {\n      me = new " + this.codec_class_name + "();\n");
        this.writeTypeSpecificStaticInitialisationCode(func, declarations);
        func.write("    }\n");
        func.write("    return me;\n");
        func.write("  }\n\n");
    }

    public abstract void writeTypeSpecificStaticInitialisationCode(StringWriter var1, StringWriter var2);

    public void writeSerializeMethod(StringWriter func, StringWriter declarations) {
        TypeInfo derived_from = this.parent.lookup(null, this.basetype, true);
        if (null != derived_from) {
            declarations.write("  private " + derived_from.getCodecClassName() + " i_" + derived_from.getCodecClassName().toLowerCase() + " = " + derived_from.getCodecClassName() + ".getCodec();\n\n");
            func.write("  public Object serialize(SerializationManager sm,\n");
            func.write("                          Object type_instance,\n");
            func.write("                          boolean is_optional,\n");
            func.write("                          String type_name) throws java.io.IOException\n");
            func.write("  {\n");
            if (this.tag_class == -1) {
                func.write("    return i_" + derived_from.getCodecClassName().toLowerCase() + ".serialize(sm, type_instance, is_optional, type_name);\n");
            } else if (this.is_implicit) {
                func.write("    return sm.implicit_tag(i_" + derived_from.getCodecClassName().toLowerCase() + ", type_instance, " + this.tag_class + ", " + this.tag_number + ", is_optional, \"" + this.type_reference + "\");\n");
            } else {
                func.write("    return sm.explicit_tag(i_" + derived_from.getCodecClassName().toLowerCase() + ", type_instance, " + this.tag_class + ", " + this.tag_number + ", is_optional, \"" + this.type_reference + "\");\n");
            }
            func.write("  }\n");
        } else {
            log.log(Level.WARNING, "WARNING: Unable to locate type we are derived from : " + this.basetype);
        }
    }

    public String getCodecClassName() {
        return this.codec_class_name;
    }

    public String getTypeClassName() {
        return this.type_class_name;
    }

    public void registerUsedCodec(TypeInfo ti) {
        this.codecs_used_by_this_codec.add(ti);
    }

    public String getInternalType() {
        log.fine("TypeInfo::getInternalType()");
        if (this.internal_type == null) {
            log.fine("Looking up internal type based on basetype: " + this.basetype);
            TypeInfo derived_from = this.parent.lookup(null, this.basetype, true);
            if (null != derived_from) {
                log.fine("OK.. Located that internal type");
                this.internal_type = derived_from.getInternalType();
            } else {
                log.log(Level.WARNING, "Unable to locate base type");
            }
        }
        log.fine("getInternalType returns " + this.internal_type);
        return this.internal_type;
    }

    public ModuleInfo getParent() {
        return this.parent;
    }
}

