/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.component.csw;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.component.csw.GetRecordByIdMetadataTransformer;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.OutputSchema;
import org.fao.geonet.csw.common.ResultType;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.csw.common.exceptions.MissingParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.csw.CatalogConfiguration;
import org.fao.geonet.kernel.csw.CatalogService;
import org.fao.geonet.kernel.csw.services.AbstractOperation;
import org.fao.geonet.kernel.csw.services.getrecords.SearchController;
import org.fao.geonet.lib.Lib;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="CswService.GetRecordById")
public class GetRecordById
extends AbstractOperation
implements CatalogService {
    static final String NAME = "GetRecordById";
    private SearchController _searchController;
    @Autowired
    private CatalogConfiguration _catalogConfig;
    @Autowired
    private SchemaManager _schemaManager;

    @Autowired
    public GetRecordById(ApplicationContext applicationContext) {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Element execute(Element request, ServiceContext context) throws CatalogException {
        this.checkService(request);
        this.checkVersion(request);
        this.checkOutputFormat(request);
        String outSchema = OutputSchema.parse(request.getAttributeValue("outputSchema"), this._schemaManager);
        ElementSetName setName = this.getElementSetName(request, ElementSetName.SUMMARY);
        Element response = new Element(this.getName() + "Response", Csw.NAMESPACE_CSW);
        Iterator ids = request.getChildren("Id", Csw.NAMESPACE_CSW).iterator();
        if (!ids.hasNext()) {
            throw new MissingParameterValueEx("id");
        }
        try {
            while (ids.hasNext()) {
                String uuid = ((Element)ids.next()).getText();
                GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
                String id = ((DataManager)gc.getBean(DataManager.class)).getMetadataId(uuid);
                if (id == null) continue;
                Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
                String displayLanguage = context.getLanguage();
                Element md = SearchController.retrieveMetadata(context, id, setName, outSchema, null, null, ResultType.RESULTS, null, displayLanguage);
                if (md == null) continue;
                Map transformers = context.getApplicationContext().getBeansOfType(GetRecordByIdMetadataTransformer.class);
                for (GetRecordByIdMetadataTransformer transformer : transformers.values()) {
                    Optional<Element> transformedMd = transformer.apply(context, md, outSchema);
                    if (!transformedMd.isPresent()) continue;
                    md = (Element)transformedMd.get();
                }
                response.addContent((Content)md);
                if (!this._catalogConfig.isIncreasePopularity()) continue;
                ((DataManager)gc.getBean(DataManager.class)).increasePopularity(context, id);
            }
        }
        catch (Exception e) {
            context.error("Raised : " + e);
            context.error(" (C) Stacktrace is\n" + Util.getStackTrace((Throwable)e));
            throw new NoApplicableCodeEx(e.toString());
        }
        return response;
    }

    @Override
    public Element adaptGetRequest(Map<String, String> params) {
        String service = params.get("service");
        String version = params.get("version");
        String elemSetName = params.get("elementsetname");
        String ids = params.get("id");
        String outputFormat = params.get("outputformat");
        String outputSchema = params.get("outputschema");
        Element request = new Element(this.getName(), Csw.NAMESPACE_CSW);
        this.setAttrib(request, "service", service);
        this.setAttrib(request, "version", version);
        this.setAttrib(request, "outputFormat", outputFormat);
        this.setAttrib(request, "outputSchema", outputSchema);
        this.fill(request, "Id", ids);
        this.addElement(request, "ElementSetName", elemSetName);
        return request;
    }

    @Override
    public Element retrieveValues(String parameterName) throws CatalogException {
        return null;
    }

    private void checkOutputFormat(Element request) throws InvalidParameterValueEx {
        String format = request.getAttributeValue("outputFormat");
        if (format == null) {
            return;
        }
        if (!format.equals("application/xml")) {
            throw new InvalidParameterValueEx("outputFormat", format);
        }
    }
}

