/*
 * Decompiled with CFR 0.152.
 */
package au.com.objectix.jgridshift.jca;

import au.com.objectix.jgridshift.GridShift;
import au.com.objectix.jgridshift.GridShiftFile;
import au.com.objectix.jgridshift.jca.GridShiftConnectionImpl;
import au.com.objectix.jgridshift.jca.ManagedConnectionMetaDataImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedConnectionImpl
implements ManagedConnection {
    private static String NO_TRANSACTION = "Transactions not supported";
    private PrintWriter log;
    private GridShiftConnectionImpl conn;
    private ArrayList listenerList = new ArrayList();
    private boolean destroyed = false;
    private GridShiftFile gridShiftFile;
    private boolean randomFile = false;

    public ManagedConnectionImpl(String gsf) throws ResourceException {
        try {
            RandomAccessFile raf = new RandomAccessFile(gsf, "r");
            this.gridShiftFile = new GridShiftFile();
            this.gridShiftFile.loadGridShiftFile(raf);
            this.randomFile = true;
        }
        catch (IOException ioe) {
            ResourceException re = new ResourceException("Filed to open GridShiftFile: " + gsf);
            re.setLinkedException((Exception)ioe);
        }
    }

    public ManagedConnectionImpl(GridShiftFile gsf) throws ResourceException {
        this.gridShiftFile = gsf;
        this.randomFile = false;
    }

    public synchronized Object getConnection(Subject subject, ConnectionRequestInfo req) throws ResourceException {
        if (this.conn == null) {
            this.conn = new GridShiftConnectionImpl(this);
        }
        return this.conn;
    }

    public synchronized void destroy() throws ResourceException {
        this.destroyed = true;
        if (this.conn != null) {
            this.conn.disconnect();
        }
        this.conn = null;
        this.listenerList = null;
        try {
            if (this.gridShiftFile != null) {
                if (this.randomFile) {
                    this.gridShiftFile.unload();
                }
                this.gridShiftFile = null;
            }
        }
        catch (IOException ioe) {
            ResourceException re = new ResourceException("Failed to close GridShiftFile");
            re.setLinkedException((Exception)ioe);
        }
    }

    public void cleanup() throws ResourceException {
        if (this.conn == null) {
            this.conn.disconnect();
        }
        this.conn = null;
    }

    public void associateConnection(Object connection) throws ResourceException {
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.listenerList.add(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listenerList.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException(NO_TRANSACTION);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException(NO_TRANSACTION);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new ManagedConnectionMetaDataImpl("jgridshift");
    }

    public void setLogWriter(PrintWriter log) throws ResourceException {
        this.log = log;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.log;
    }

    synchronized void close(Connection c) {
        if (this.listenerList != null) {
            ConnectionEvent evt = new ConnectionEvent((ManagedConnection)this, 1);
            evt.setConnectionHandle((Object)c);
            for (int i = 0; i < this.listenerList.size(); ++i) {
                ConnectionEventListener listener = (ConnectionEventListener)this.listenerList.get(i);
                listener.connectionClosed(evt);
            }
        }
    }

    public boolean gridShiftForward(GridShift gs) throws ResourceException {
        try {
            return this.gridShiftFile.gridShiftForward(gs);
        }
        catch (IOException ioe) {
            ResourceException re = new ResourceException("Faled to shift coordinate");
            re.setLinkedException((Exception)ioe);
            throw re;
        }
    }

    public boolean gridShiftReverse(GridShift gs) throws ResourceException {
        try {
            return this.gridShiftFile.gridShiftReverse(gs);
        }
        catch (IOException ioe) {
            ResourceException re = new ResourceException("Faled to shift coordinate");
            re.setLinkedException((Exception)ioe);
            throw re;
        }
    }

    private void signalError(IOException ioe) {
        if (this.listenerList != null) {
            ConnectionEvent evt = new ConnectionEvent((ManagedConnection)this, 5, (Exception)ioe);
            evt.setConnectionHandle((Object)this.conn);
            for (int i = 0; i < this.listenerList.size(); ++i) {
                ConnectionEventListener listener = (ConnectionEventListener)this.listenerList.get(i);
                listener.connectionErrorOccurred(evt);
            }
        }
    }
}

