/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.DestinationMapEntry;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.DefaultAuthorizationMap;
import org.apache.activemq.security.TempDestinationAuthorizationEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class CachedLDAPAuthorizationMap
extends DefaultAuthorizationMap
implements NamespaceChangeListener,
ObjectChangeListener,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(CachedLDAPAuthorizationMap.class);
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String connectionURL = "ldap://localhost:1024";
    private String connectionUsername = "uid=admin,ou=system";
    private String connectionPassword = "secret";
    private String connectionProtocol = "s";
    private String authentication = "simple";
    private String baseDn = "ou=system";
    private int cnsLength = 5;
    private int refreshInterval = -1;
    private long lastUpdated;
    private static String ANY_DESCENDANT = "\\$";
    private DirContext context;
    private EventDirContext eventContext;
    HashMap<ActiveMQDestination, AuthorizationEntry> entries = new HashMap();

    protected DirContext open() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.initialContextFactory);
            if (this.connectionUsername != null || !"".equals(this.connectionUsername)) {
                env.put("java.naming.security.principal", this.connectionUsername);
            }
            if (this.connectionPassword != null || !"".equals(this.connectionPassword)) {
                env.put("java.naming.security.credentials", this.connectionPassword);
            }
            env.put("java.naming.security.protocol", this.connectionProtocol);
            env.put("java.naming.provider.url", this.connectionURL);
            env.put("java.naming.security.authentication", this.authentication);
            this.context = new InitialDirContext(env);
            if (this.refreshInterval == -1) {
                this.eventContext = (EventDirContext)this.context.lookup("");
                SearchControls constraints = new SearchControls();
                constraints.setSearchScope(2);
                LOG.debug("Listening for: 'ou=Destination,ou=ActiveMQ," + this.baseDn + "'");
                this.eventContext.addNamingListener("ou=Destination,ou=ActiveMQ," + this.baseDn, "cn=*", constraints, (NamingListener)this);
            }
        }
        catch (NamingException e) {
            LOG.error(e.toString());
            throw e;
        }
        return this.context;
    }

    public void query() throws Exception {
        try {
            this.context = this.open();
        }
        catch (NamingException e) {
            LOG.error(e.toString());
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = this.context.search("ou=Destination,ou=ActiveMQ," + this.baseDn, "(|(cn=admin)(cn=write)(cn=read))", constraints);
        while (results.hasMore()) {
            SearchResult result = results.next();
            AuthorizationEntry entry = this.getEntry(result.getNameInNamespace());
            this.applyACL(entry, result);
        }
        this.setEntries(new ArrayList<DestinationMapEntry>(this.entries.values()));
        this.updated();
    }

    protected void updated() {
        this.lastUpdated = System.currentTimeMillis();
    }

    protected AuthorizationEntry getEntry(String name) {
        ActiveMQDestination dest;
        String[] cns = name.split(",");
        if (cns.length == this.cnsLength && cns[1].equals("ou=Temp")) {
            TempDestinationAuthorizationEntry tempEntry = this.getTempDestinationAuthorizationEntry();
            if (tempEntry == null) {
                tempEntry = new TempDestinationAuthorizationEntry();
                this.setTempDestinationAuthorizationEntry(tempEntry);
            }
            return tempEntry;
        }
        if (cns.length != this.cnsLength + 1) {
            LOG.warn("Policy not applied! Wrong cn for authorization entry " + name);
        }
        if ((dest = this.formatDestination(cns[1], cns[2])) != null) {
            AuthorizationEntry entry = this.entries.get(dest);
            if (entry == null) {
                entry = new AuthorizationEntry();
                entry.setDestination(dest);
                this.entries.put(dest, entry);
            }
            return entry;
        }
        return null;
    }

    protected ActiveMQDestination formatDestination(String destinationName, String destinationType) {
        ActiveMQDestination dest = null;
        if (destinationType.equalsIgnoreCase("ou=queue")) {
            dest = new ActiveMQQueue(this.formatDestinationName(destinationName));
        } else if (destinationType.equalsIgnoreCase("ou=topic")) {
            dest = new ActiveMQTopic(this.formatDestinationName(destinationName));
        } else {
            LOG.warn("Policy not applied! Unknown destination type " + destinationType);
        }
        return dest;
    }

    protected void applyACL(AuthorizationEntry entry, SearchResult result) throws NamingException {
        Attribute cn = result.getAttributes().get("cn");
        Attribute member = result.getAttributes().get("member");
        NamingEnumeration<?> memberEnum = member.getAll();
        HashSet<Object> members = new HashSet<Object>();
        while (memberEnum.hasMoreElements()) {
            String elem = (String)memberEnum.nextElement();
            members.add(new GroupPrincipal(elem.replaceAll("cn=", "")));
        }
        if (cn.get().equals("admin")) {
            entry.setAdminACLs(members);
        } else if (cn.get().equals("write")) {
            entry.setWriteACLs(members);
        } else if (cn.get().equals("read")) {
            entry.setReadACLs(members);
        } else {
            LOG.warn("Policy not applied! Unknown privilege " + result.getName());
        }
    }

    protected String formatDestinationName(String cn) {
        return cn.replaceFirst("cn=", "").replaceAll(ANY_DESCENDANT, ">");
    }

    protected boolean isPriviledge(Binding binding) {
        String name = binding.getName();
        return name.startsWith("cn=admin") || name.startsWith("cn=write") || name.startsWith("cn=read");
    }

    @Override
    protected Set<AuthorizationEntry> getAllEntries(ActiveMQDestination destination) {
        if (this.refreshInterval != -1 && System.currentTimeMillis() >= this.lastUpdated + (long)this.refreshInterval) {
            this.reset();
            this.entries.clear();
            LOG.debug("Updating authorization map!");
            try {
                this.query();
            }
            catch (Exception e) {
                LOG.error("Error updating authorization map", (Throwable)e);
            }
        }
        return super.getAllEntries(destination);
    }

    @Override
    public void objectAdded(NamingEvent namingEvent) {
        LOG.debug("Adding object: " + namingEvent.getNewBinding());
        SearchResult result = (SearchResult)namingEvent.getNewBinding();
        if (!this.isPriviledge(result)) {
            return;
        }
        AuthorizationEntry entry = this.getEntry(result.getName());
        if (entry != null) {
            try {
                this.applyACL(entry, result);
                if (!(entry instanceof TempDestinationAuthorizationEntry)) {
                    this.put(entry.getDestination(), entry);
                }
            }
            catch (NamingException ne) {
                LOG.warn("Unable to add entry", (Throwable)ne);
            }
        }
    }

    @Override
    public void objectRemoved(NamingEvent namingEvent) {
        LOG.debug("Removing object: " + namingEvent.getOldBinding());
        Binding result = namingEvent.getOldBinding();
        if (!this.isPriviledge(result)) {
            return;
        }
        AuthorizationEntry entry = this.getEntry(result.getName());
        String[] cns = result.getName().split(",");
        if (!this.isPriviledge(result)) {
            return;
        }
        if (cns[0].equalsIgnoreCase("cn=admin")) {
            entry.setAdminACLs(new HashSet<Object>());
        } else if (cns[0].equalsIgnoreCase("cn=write")) {
            entry.setWriteACLs(new HashSet<Object>());
        } else if (cns[0].equalsIgnoreCase("cn=read")) {
            entry.setReadACLs(new HashSet<Object>());
        } else {
            LOG.warn("Policy not removed! Unknown privilege " + result.getName());
        }
    }

    @Override
    public void objectRenamed(NamingEvent namingEvent) {
        Binding oldBinding = namingEvent.getOldBinding();
        Binding newBinding = namingEvent.getNewBinding();
        LOG.debug("Renaming object: " + oldBinding + " to " + newBinding);
        String[] oldCns = oldBinding.getName().split(",");
        ActiveMQDestination oldDest = this.formatDestination(oldCns[0], oldCns[1]);
        String[] newCns = newBinding.getName().split(",");
        ActiveMQDestination newDest = this.formatDestination(newCns[0], newCns[1]);
        if (oldDest != null && newDest != null) {
            AuthorizationEntry entry = this.entries.remove(oldDest);
            if (entry != null) {
                entry.setDestination(newDest);
                this.put(newDest, entry);
                this.remove(oldDest, entry);
            } else {
                LOG.warn("No authorization entry for " + oldDest);
            }
        }
    }

    @Override
    public void objectChanged(NamingEvent namingEvent) {
        LOG.debug("Changing object " + namingEvent.getOldBinding() + " to " + namingEvent.getNewBinding());
        this.objectRemoved(namingEvent);
        this.objectAdded(namingEvent);
    }

    @Override
    public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
        LOG.error("Caught Unexpected Exception", (Throwable)namingExceptionEvent.getException());
    }

    public void afterPropertiesSet() throws Exception {
        this.query();
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getConnectionUsername() {
        return this.connectionUsername;
    }

    public void setConnectionUsername(String connectionUsername) {
        this.connectionUsername = connectionUsername;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getConnectionProtocol() {
        return this.connectionProtocol;
    }

    public void setConnectionProtocol(String connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
        this.cnsLength = baseDn.split(",").length + 4;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }
}

