/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.MetaData;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.PortrayalCatalogueReference;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.ReferenceSystem;

public class MetaDataImpl
extends MetadataEntity
implements MetaData {
    private static final long serialVersionUID = -5600409558876701144L;
    private String fileIdentifier;
    private Locale language;
    private Collection<Locale> locales;
    private CharacterSet characterSet;
    private String parentIdentifier;
    private Collection<ScopeCode> hierarchyLevels;
    private Collection<String> hierarchyLevelNames;
    private Collection<ResponsibleParty> contacts;
    private String dataSetUri;
    private long dateStamp = Long.MIN_VALUE;
    private String metadataStandardName;
    private String metadataStandardVersion;
    private Collection<SpatialRepresentation> spatialRepresentationInfo;
    private Collection<ReferenceSystem> referenceSystemInfo;
    private Collection<MetadataExtensionInformation> metadataExtensionInfo;
    private Collection<Identification> identificationInfo;
    private Collection<ContentInformation> contentInfo;
    private Distribution distributionInfo;
    private Collection<DataQuality> dataQualityInfo;
    private Collection<PortrayalCatalogueReference> portrayalCatalogueInfo;
    private Collection<Constraints> metadataConstraints;
    private Collection<ApplicationSchemaInformation> applicationSchemaInfo;
    private MaintenanceInformation metadataMaintenance;

    public MetaDataImpl() {
    }

    public MetaDataImpl(MetaData source) {
        super(source);
    }

    public MetaDataImpl(ResponsibleParty contact, Date dateStamp, Identification identificationInfo) {
        this.setContacts(Collections.singleton(contact));
        this.setDateStamp(dateStamp);
        this.setIdentificationInfo(Collections.singleton(identificationInfo));
    }

    @Override
    public String getFileIdentifier() {
        return this.fileIdentifier;
    }

    public void setFileIdentifier(String newValue) {
        this.checkWritePermission();
        this.fileIdentifier = newValue;
    }

    @Override
    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale newValue) {
        this.checkWritePermission();
        this.language = newValue;
    }

    @Override
    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(CharacterSet newValue) {
        this.checkWritePermission();
        this.characterSet = newValue;
    }

    @Override
    public String getParentIdentifier() {
        return this.parentIdentifier;
    }

    public void setParentIdentifier(String newValue) {
        this.checkWritePermission();
        this.parentIdentifier = newValue;
    }

    @Override
    public Collection<ScopeCode> getHierarchyLevels() {
        this.hierarchyLevels = this.nonNullCollection(this.hierarchyLevels, ScopeCode.class);
        return this.hierarchyLevels;
    }

    public void setHierarchyLevels(Collection<? extends ScopeCode> newValues) {
        this.hierarchyLevels = this.copyCollection(newValues, this.hierarchyLevels, ScopeCode.class);
    }

    @Override
    public Collection<String> getHierarchyLevelNames() {
        this.hierarchyLevelNames = this.nonNullCollection(this.hierarchyLevelNames, String.class);
        return this.hierarchyLevelNames;
    }

    public void setHierarchyLevelNames(Collection<? extends String> newValues) {
        this.hierarchyLevelNames = this.copyCollection(newValues, this.hierarchyLevelNames, String.class);
    }

    public Collection<ResponsibleParty> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return this.contacts;
    }

    public void setContacts(Collection<? extends ResponsibleParty> newValues) {
        this.checkWritePermission();
        this.contacts = this.copyCollection(newValues, this.contacts, ResponsibleParty.class);
    }

    @Override
    public Date getDateStamp() {
        return this.dateStamp != Long.MIN_VALUE ? new Date(this.dateStamp) : (Date)null;
    }

    public void setDateStamp(Date newValue) {
        this.checkWritePermission();
        this.dateStamp = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    @Override
    public String getMetadataStandardName() {
        return this.metadataStandardName;
    }

    public void setMetadataStandardName(String newValue) {
        this.checkWritePermission();
        this.metadataStandardName = newValue;
    }

    @Override
    public String getMetadataStandardVersion() {
        return this.metadataStandardVersion;
    }

    public void setMetadataStandardVersion(String newValue) {
        this.checkWritePermission();
        this.metadataStandardVersion = newValue;
    }

    public Collection<SpatialRepresentation> getSpatialRepresentationInfo() {
        this.spatialRepresentationInfo = this.nonNullCollection(this.spatialRepresentationInfo, SpatialRepresentation.class);
        return this.spatialRepresentationInfo;
    }

    public void setSpatialRepresentationInfo(Collection<? extends SpatialRepresentation> newValues) {
        this.spatialRepresentationInfo = this.copyCollection(newValues, this.spatialRepresentationInfo, SpatialRepresentation.class);
    }

    public Collection<ReferenceSystem> getReferenceSystemInfo() {
        this.referenceSystemInfo = this.nonNullCollection(this.referenceSystemInfo, ReferenceSystem.class);
        return this.referenceSystemInfo;
    }

    public void setReferenceSystemInfo(Collection<? extends ReferenceSystem> newValues) {
        this.referenceSystemInfo = this.copyCollection(newValues, this.referenceSystemInfo, ReferenceSystem.class);
    }

    public Collection<MetadataExtensionInformation> getMetadataExtensionInfo() {
        this.metadataExtensionInfo = this.nonNullCollection(this.metadataExtensionInfo, MetadataExtensionInformation.class);
        return this.metadataExtensionInfo;
    }

    public void setMetadataExtensionInfo(Collection<? extends MetadataExtensionInformation> newValues) {
        this.metadataExtensionInfo = this.copyCollection(newValues, this.metadataExtensionInfo, MetadataExtensionInformation.class);
    }

    public Collection<Identification> getIdentificationInfo() {
        this.identificationInfo = this.nonNullCollection(this.identificationInfo, Identification.class);
        return this.identificationInfo;
    }

    public void setIdentificationInfo(Collection<? extends Identification> newValues) {
        this.identificationInfo = this.copyCollection(newValues, this.identificationInfo, Identification.class);
    }

    public Collection<ContentInformation> getContentInfo() {
        this.contentInfo = this.nonNullCollection(this.contentInfo, ContentInformation.class);
        return this.contentInfo;
    }

    public void setContentInfo(Collection<? extends ContentInformation> newValues) {
        this.contentInfo = this.copyCollection(newValues, this.contentInfo, ContentInformation.class);
    }

    @Override
    public Distribution getDistributionInfo() {
        return this.distributionInfo;
    }

    public void setDistributionInfo(Distribution newValue) {
        this.checkWritePermission();
        this.distributionInfo = newValue;
    }

    public Collection<DataQuality> getDataQualityInfo() {
        this.dataQualityInfo = this.nonNullCollection(this.dataQualityInfo, DataQuality.class);
        return this.dataQualityInfo;
    }

    public void setDataQualityInfo(Collection<? extends DataQuality> newValues) {
        this.dataQualityInfo = this.copyCollection(newValues, this.dataQualityInfo, DataQuality.class);
    }

    public Collection<PortrayalCatalogueReference> getPortrayalCatalogueInfo() {
        this.portrayalCatalogueInfo = this.nonNullCollection(this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
        return this.portrayalCatalogueInfo;
    }

    public void setPortrayalCatalogueInfo(Collection<? extends PortrayalCatalogueReference> newValues) {
        this.portrayalCatalogueInfo = this.copyCollection(newValues, this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
    }

    public Collection<Constraints> getMetadataConstraints() {
        this.metadataConstraints = this.nonNullCollection(this.metadataConstraints, Constraints.class);
        return this.metadataConstraints;
    }

    public void setMetadataConstraints(Collection<? extends Constraints> newValues) {
        this.metadataConstraints = this.copyCollection(newValues, this.metadataConstraints, Constraints.class);
    }

    public Collection<ApplicationSchemaInformation> getApplicationSchemaInfo() {
        this.applicationSchemaInfo = this.nonNullCollection(this.applicationSchemaInfo, ApplicationSchemaInformation.class);
        return this.applicationSchemaInfo;
    }

    public void setApplicationSchemaInfo(Collection<? extends ApplicationSchemaInformation> newValues) {
        this.applicationSchemaInfo = this.copyCollection(newValues, this.applicationSchemaInfo, ApplicationSchemaInformation.class);
    }

    @Override
    public MaintenanceInformation getMetadataMaintenance() {
        return this.metadataMaintenance;
    }

    public void setMetadataMaintenance(MaintenanceInformation newValue) {
        this.checkWritePermission();
        this.metadataMaintenance = newValue;
    }

    @Override
    public Collection<Locale> getLocales() {
        this.locales = this.nonNullCollection(this.locales, Locale.class);
        return this.locales;
    }

    public void setLocales(Collection<? extends Locale> newValues) {
        this.locales = this.copyCollection(newValues, this.locales, Locale.class);
    }

    @Override
    public String getDataSetUri() {
        return this.dataSetUri;
    }

    public void setDataSetUri(String newValue) {
        this.checkWritePermission();
        this.dataSetUri = newValue;
    }
}

