/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Point;
import org.postgis.PointComposedGeom;

public class LineString
extends PointComposedGeom {
    private static final long serialVersionUID = 256L;
    double len = -1.0;

    public LineString() {
        super(2);
    }

    public LineString(Point[] points) {
        super(2, points);
    }

    public LineString(String value) throws SQLException {
        super(2, value);
    }

    public LineString(String value, boolean haveM) throws SQLException {
        super(2, value, haveM);
    }

    public LineString reverse() {
        Point[] points = this.getPoints();
        int l = points.length;
        Point[] p = new Point[l];
        int i = 0;
        int j = l - 1;
        while (i < l) {
            p[i] = points[j];
            ++i;
            --j;
        }
        return new LineString(p);
    }

    public LineString concat(LineString other) {
        int i;
        Point[] points = this.getPoints();
        Point[] opoints = other.getPoints();
        boolean cutPoint = this.getLastPoint() == null || this.getLastPoint().equals(other.getFirstPoint());
        int count = points.length + points.length - (cutPoint ? 1 : 0);
        Point[] p = new Point[count];
        for (i = 0; i < points.length; ++i) {
            p[i] = points[i];
        }
        if (!cutPoint) {
            p[i++] = other.getFirstPoint();
        }
        int j = 1;
        while (j < opoints.length) {
            p[i] = opoints[j];
            ++j;
            ++i;
        }
        return new LineString(p);
    }

    public double length() {
        if (this.len < 0.0) {
            Point[] points = this.getPoints();
            if (points == null || points.length < 2) {
                this.len = 0.0;
            } else {
                double sum = 0.0;
                for (int i = 1; i < points.length; ++i) {
                    sum += points[i - 1].distance(points[i]);
                }
                this.len = sum;
            }
        }
        return this.len;
    }
}

