/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.reports;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.reports.ReportDownloads;
import org.fao.geonet.api.reports.ReportFilter;
import org.fao.geonet.api.reports.ReportInternalMetadata;
import org.fao.geonet.api.reports.ReportUpdatedMetadata;
import org.fao.geonet.api.reports.ReportUploads;
import org.fao.geonet.api.reports.ReportUsers;
import org.fao.geonet.api.reports.ReportUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/reports"})
@Tag(name="records", description="Metadata record operations")
public class ReportApi {
    @Operation(summary="Get list of metadata file downloads")
    @RequestMapping(value={"/datadownloads"}, method={RequestMethod.GET}, produces={"text/x-csv; charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of metadata file downloads.")})
    @PreAuthorize(value="hasAuthority('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public void getReportDataDownloads(@Parameter(description="From date of the metadata downloads", required=true) @RequestParam String dateFrom, @Parameter(description="To date of the metadata downloads", required=true) @RequestParam String dateTo, @Parameter(description="Metadata group(s)") @RequestParam(required=false) List<Integer> groups, HttpServletResponse response, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        ReportFilter filter = new ReportFilter(dateFrom, dateTo, ReportUtils.groupsForFilter(context, groups));
        ReportDownloads report = new ReportDownloads(filter);
        response.setHeader("Content-Disposition", "attachment; filename=\"downloads.csv\"");
        report.create(context, response.getWriter());
    }

    @Operation(summary="Get uploaded files to metadata records during a period.")
    @RequestMapping(value={"/datauploads"}, method={RequestMethod.GET}, produces={"text/x-csv; charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={})
    @PreAuthorize(value="hasAuthority('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public void getReportDataUploads(@Parameter(description="From date of the metadata uploads", required=true) @RequestParam String dateFrom, @Parameter(description="To date of the metadata uploads", required=true) @RequestParam String dateTo, @Parameter(description="Metadata group(s)") @RequestParam(required=false) List<Integer> groups, HttpServletResponse response, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        ReportFilter filter = new ReportFilter(dateFrom, dateTo, ReportUtils.groupsForFilter(context, groups));
        ReportUploads report = new ReportUploads(filter);
        response.setHeader("Content-Disposition", "attachment; filename=\"uploads.csv\"");
        report.create(context, response.getWriter());
    }

    @Operation(summary="Get the list of users \"active\" during a time period.")
    @RequestMapping(value={"/users"}, method={RequestMethod.GET}, produces={"text/x-csv; charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of users \"active\" during a time period.")})
    @PreAuthorize(value="hasAuthority('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public void getActiveUsers(@Parameter(description="From date of users login date", required=true) @RequestParam String dateFrom, @Parameter(description="To date of users login date", required=true) @RequestParam String dateTo, @Parameter(description="Group(s) for the users") @RequestParam(required=false) List<Integer> groups, HttpServletResponse response, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        ReportFilter filter = new ReportFilter(dateFrom, dateTo, ReportUtils.groupsForFilter(context, groups));
        ReportUsers report = new ReportUsers(filter);
        response.setHeader("Content-Disposition", "attachment; filename=\"users.csv\"");
        report.create(context, response.getWriter());
    }

    @Operation(summary="Get the metadata not published during a period.")
    @RequestMapping(value={"/metadatainternal"}, method={RequestMethod.GET}, produces={"text/x-csv; charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Metadata not published during a period.")})
    @PreAuthorize(value="hasAuthority('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public void getReportInternalMetadata(@Parameter(description="From date of metadata change date", required=true) @RequestParam String dateFrom, @Parameter(description="To date of metadata change date", required=true) @RequestParam String dateTo, @Parameter(description="Metadata group(s)") @RequestParam(required=false) List<Integer> groups, HttpServletResponse response, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        ReportFilter filter = new ReportFilter(dateFrom, dateTo, ReportUtils.groupsForFilter(context, groups));
        ReportInternalMetadata report = new ReportInternalMetadata(filter);
        response.setHeader("Content-Disposition", "attachment; filename=\"internalmetadata.csv\"");
        report.create(context, response.getWriter());
    }

    @Operation(summary="Get the updated metadata during a period.")
    @RequestMapping(value={"/metadataupdated"}, method={RequestMethod.GET}, produces={"text/x-csv; charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated metadata during a period.")})
    @PreAuthorize(value="hasAuthority('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public void getReportUpdatedMetadata(@Parameter(description="From date of metadata change date", required=true) @RequestParam String dateFrom, @Parameter(description="To date of metadata change date", required=true) @RequestParam String dateTo, @Parameter(description="Metadata group(s)") @RequestParam(required=false) List<Integer> groups, HttpServletResponse response, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        ReportFilter filter = new ReportFilter(dateFrom, dateTo, ReportUtils.groupsForFilter(context, groups));
        ReportUpdatedMetadata report = new ReportUpdatedMetadata(filter);
        response.setHeader("Content-Disposition", "attachment; filename=\"updatedmetadata.csv\"");
        report.create(context, response.getWriter());
    }
}

