/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions.metadata;

import com.google.common.base.Optional;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.regions.MetadataRegion;
import org.fao.geonet.api.regions.metadata.GeomUtils;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.kernel.region.Request;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.search.spatial.ErrorHandler;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.util.GMLParsers;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xsd.Parser;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.Filter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class MetadataRegionSearchRequest
extends Request {
    public static final String PREFIX = "metadata:";
    private static final FindByNodeName EXTENT_FINDER = new FindByNodeName("EX_BoundingPolygon", "EX_GeographicBoundingBox", "polygon");
    ServiceContext context;
    private String id;
    private String label;
    private final GeometryFactory factory;

    public MetadataRegionSearchRequest(ServiceContext context, GeometryFactory factory) {
        this.context = context;
        this.factory = factory;
    }

    public Request label(String labelParam) {
        this.label = labelParam;
        return this;
    }

    public Request categoryId(String categoryIdParam) {
        return this;
    }

    public Request maxRecords(int maxRecordsParam) {
        return this;
    }

    public Collection<Region> execute() throws Exception {
        if (this.label == null && this.id == null || this.id != null && !this.id.startsWith(PREFIX)) {
            return Collections.emptySet();
        }
        List<Object> regions = new ArrayList<Region>();
        if (this.label != null) {
            this.loadAll(regions, Id.create(this.label));
        } else if (this.id != null) {
            String[] parts = this.id.split(":", 3);
            String mdId = parts[1];
            if (parts.length > 2) {
                String id = parts[2];
                this.loadOnly(regions, Id.create(mdId), id);
            } else {
                this.loadSpatialExtent(regions, Id.create(mdId));
            }
            if (regions.size() > 1) {
                regions = Collections.singletonList(regions.get(0));
            }
        }
        return regions;
    }

    private void loadOnly(List<Region> regions, Id mdId, String id) throws Exception {
        String schemaId;
        DataManager dataManager;
        MetadataSchema schema;
        String xpath;
        Element geomEl;
        Element metadata;
        if (id.startsWith("@xpath") && (metadata = this.findMetadata(mdId, false)) != null && (geomEl = Xml.selectElement((Element)metadata, (String)(xpath = id.substring("@xpath".length())), (List)(schema = (dataManager = (DataManager)ApplicationContextHolder.get().getBean(DataManager.class)).getSchema(schemaId = dataManager.getMetadataSchema(mdId.getId()))).getNamespaces())) != null) {
            this.findContainingGmdEl(regions, mdId, geomEl);
        }
    }

    boolean findContainingGmdEl(List<Region> regions, Id mdId, Element el) throws Exception {
        for (Element parent = el; parent != null; parent = parent.getParentElement()) {
            if (!EXTENT_FINDER.matches(parent)) continue;
            regions.add(this.parseRegion(mdId, parent));
            return true;
        }
        return false;
    }

    private void loadAll(List<Region> regions, Id id) throws Exception {
        Element metadata = this.findMetadata(id, false);
        if (metadata != null) {
            Iterator<?> extents = null;
            extents = this.descentOrSelf(metadata);
            while (extents.hasNext()) {
                Object object = extents.next();
                if (!(object instanceof Element)) continue;
                regions.add(this.parseRegion(id, (Element)object));
            }
        }
    }

    private void loadSpatialExtent(List<Region> regions, Id id) throws Exception {
        Element metadata = this.findMetadata(id, false);
        if (metadata != null) {
            Path schemaDir = this.getSchemaDir(id);
            MultiPolygon geom = GeomUtils.getSpatialExtent(schemaDir, metadata, new SpatialExtentErrorHandler());
            MetadataRegion region = new MetadataRegion(id, null, (Geometry)geom);
            regions.add(region);
        }
    }

    Iterator<?> descentOrSelf(Element metadata) {
        Iterator extents = EXTENT_FINDER.matches(metadata) ? Collections.singletonList(metadata).iterator() : metadata.getDescendants((Filter)EXTENT_FINDER);
        return extents;
    }

    private double getCoordinateValue(String coord, Element bbox) {
        List children;
        Element coordElement = bbox.getChild(coord, bbox.getNamespace());
        if (coordElement != null && (children = coordElement.getChildren()).size() == 1 && children.get(0) instanceof Element) {
            return Double.parseDouble(((Element)children.get(0)).getText());
        }
        return 0.0;
    }

    Region parseRegion(Id mdId, Element extentObj) throws Exception {
        GeonetContext gc = (GeonetContext)this.context.getHandlerContext("contextName");
        ((DataManager)gc.getBean(DataManager.class)).getEditLib().removeEditingInfo(extentObj);
        String id = null;
        MultiPolygon geometry = null;
        Namespace objNamespace = extentObj.getNamespace();
        if ("polygon".equals(extentObj.getName())) {
            String gml = Xml.getString((Element)extentObj);
            geometry = GeomUtils.parseGml(this.getParser(extentObj), gml);
        } else if ("EX_BoundingPolygon".equals(extentObj.getName())) {
            Element polygon = extentObj.getChild("polygon", objNamespace);
            String gml = Xml.getString((Element)polygon);
            geometry = GeomUtils.parseGml(this.getParser(polygon), gml);
            Element xmlGeom = (Element)polygon.getChildren().get(0);
            String srs = xmlGeom.getAttributeValue("srsName");
            DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
            if (srs != null && !srs.equals("")) {
                sourceCRS = CRS.decode((String)srs);
            }
            if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)DefaultGeographicCRS.WGS84)) {
                MathTransform tform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                geometry = (MultiPolygon)JTS.transform((Geometry)geometry, (MathTransform)tform);
            }
        } else if ("EX_GeographicBoundingBox".equals(extentObj.getName())) {
            double minx = this.getCoordinateValue("westBoundLongitude", extentObj);
            double maxx = this.getCoordinateValue("eastBoundLongitude", extentObj);
            double miny = this.getCoordinateValue("southBoundLatitude", extentObj);
            double maxy = this.getCoordinateValue("northBoundLatitude", extentObj);
            geometry = this.factory.toGeometry(new Envelope(minx, maxx, miny, maxy));
        }
        if (geometry != null) {
            Element element = extentObj.getChild("element", Geonet.Namespaces.GEONET);
            if (element != null) {
                id = element.getAttributeValue("ref");
            }
            return new MetadataRegion(mdId, id, (Geometry)geometry);
        }
        return null;
    }

    private Parser getParser(Element polygon) {
        try {
            return GMLParsers.create((Element)((Element)polygon.getChildren().get(0)));
        }
        catch (Exception e) {
            return GMLParsers.createGML();
        }
    }

    private Element findMetadata(Id id, boolean includeEditData) throws Exception {
        DataManager dataManager = (DataManager)this.context.getBean(DataManager.class);
        String mdId = id.getMdId();
        try {
            if (((IMetadataUtils)this.context.getBean(IMetadataUtils.class)).exists(Integer.valueOf(Integer.parseInt(mdId)))) {
                Lib.resource.checkPrivilege(this.context, mdId, ReservedOperation.view);
                return dataManager.getMetadata(this.context, mdId, includeEditData, false, true);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Path getSchemaDir(Id id) throws Exception {
        DataManager dataManager = (DataManager)this.context.getBean(DataManager.class);
        String mdId = id.getMdId();
        String schemaId = dataManager.getMetadataSchema(mdId);
        IMetadataSchemaUtils schemaUtils = (IMetadataSchemaUtils)this.context.getBean(IMetadataSchemaUtils.class);
        return schemaUtils.getSchemaDir(schemaId);
    }

    public Request id(String regionId) {
        this.id = regionId;
        return this;
    }

    public Optional<Long> getLastModified() throws Exception {
        Metadata metadata;
        ISODate docChangeDate;
        String[] idParts;
        String mdId;
        if (this.id.startsWith(PREFIX) && (mdId = Id.create((idParts = this.id.substring(PREFIX.length()).split(":"))[0]).getMdId()) != null && (docChangeDate = (metadata = ((MetadataRepository)ApplicationContextHolder.get().getBean(MetadataRepository.class)).findOneById(Integer.valueOf(mdId).intValue())).getDataInfo().getChangeDate()) != null) {
            return Optional.of((Object)docChangeDate.toDate().getTime());
        }
        return Optional.absent();
    }

    private class SpatialExtentErrorHandler
    implements ErrorHandler {
        private SpatialExtentErrorHandler() {
        }

        public void handleParseException(Exception e, String gml) {
            Log.error((String)"geonetwork.spatial", (Object)("Failed to convert gml to jts object: " + gml + "\n\t" + e.getMessage()), (Throwable)e);
        }

        public void handleBuildException(Exception e, List<Polygon> polygons) {
            Log.error((String)"geonetwork.spatial", (Object)("Failed to create a MultiPolygon from: " + polygons), (Throwable)e);
        }
    }

    private static final class FindByNodeName
    implements Filter {
        private static final long serialVersionUID = 1L;
        private final String[] names;

        public FindByNodeName(String ... names) {
            this.names = names;
        }

        public boolean matches(Object obj) {
            if (obj instanceof Element) {
                Element el = (Element)obj;
                for (String name : this.names) {
                    if (!el.getName().equals(name)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class MdId
    extends Id {
        private static final String PREFIX = "@id";

        public MdId(String id) {
            super(PREFIX, id.substring(PREFIX.length()));
        }

        @Override
        public String getMdId() {
            return this.id;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    public static abstract class Id {
        protected String id;
        private final String prefix;

        public Id(String prefix, String id) {
            this.id = id;
            this.prefix = prefix;
        }

        static Id create(String id) {
            return new MdId(id);
        }

        public abstract String getMdId() throws Exception;

        abstract String getId();

        public String getIdentifiedId() {
            return this.prefix + this.id;
        }
    }
}

