/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.domain.JsonBall;
import org.jclouds.javax.annotation.Nullable;

public class Environment {
    private final String name;
    @SerializedName(value="default_attributes")
    private final Map<String, JsonBall> attributes;
    @SerializedName(value="override_attributes")
    private final Map<String, JsonBall> overrideAttributes;
    private final String description;
    @SerializedName(value="cookbook_versions")
    private final Map<String, String> cookbookVersions;
    @SerializedName(value="json_class")
    private final String _jsonClass = "Chef::Environment";
    @SerializedName(value="chef_type")
    private final String _chefType = "environment";

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"name", "default_attributes", "override_attributes", "description", "cookbook_versions"})
    protected Environment(String name, @Nullable Map<String, JsonBall> attributes, @Nullable Map<String, JsonBall> overrideAttributes, String description, @Nullable Map<String, String> cookbookVersions) {
        this.name = name;
        this.attributes = CollectionUtils.copyOfOrEmpty(attributes);
        this.overrideAttributes = CollectionUtils.copyOfOrEmpty(overrideAttributes);
        this.description = description;
        this.cookbookVersions = CollectionUtils.copyOfOrEmpty(cookbookVersions);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, JsonBall> getAttributes() {
        return this.attributes;
    }

    public Map<String, JsonBall> getOverrideAttributes() {
        return this.overrideAttributes;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getCookbookVersions() {
        return this.cookbookVersions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment that = (Environment)o;
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.cookbookVersions != null ? !this.cookbookVersions.equals(that.cookbookVersions) : that.cookbookVersions != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.overrideAttributes != null ? !this.overrideAttributes.equals(that.overrideAttributes) : that.overrideAttributes != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + (this.overrideAttributes != null ? this.overrideAttributes.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.cookbookVersions != null ? this.cookbookVersions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Environment [name='" + this.name + '\'' + ", attributes=" + this.attributes + ", overrideAttributes=" + this.overrideAttributes + ", description='" + this.description + '\'' + ", cookbookVersions=" + this.cookbookVersions + ']';
    }

    public static class Builder {
        private String name;
        private ImmutableMap.Builder<String, JsonBall> attributes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, JsonBall> overrideAttributes = ImmutableMap.builder();
        private String description = "";
        private ImmutableMap.Builder<String, String> cookbookVersions = ImmutableMap.builder();

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder attribute(String key, JsonBall value) {
            this.attributes.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder attributes(Map<String, JsonBall> attributes) {
            this.attributes.putAll((Map)Preconditions.checkNotNull(attributes, (Object)"attributes"));
            return this;
        }

        public Builder overrideAttribute(String key, JsonBall value) {
            this.overrideAttributes.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder overrideAttributes(Map<String, JsonBall> overrideAttributes) {
            this.overrideAttributes.putAll((Map)Preconditions.checkNotNull(overrideAttributes, (Object)"overrideAttributes"));
            return this;
        }

        public Builder cookbookVersion(String key, String version) {
            this.cookbookVersions.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)version, (Object)"version"));
            return this;
        }

        public Builder cookbookVersions(Map<String, String> cookbookVersions) {
            this.cookbookVersions.putAll((Map)Preconditions.checkNotNull(cookbookVersions, (Object)"cookbookVersions"));
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            return this;
        }

        public Environment build() {
            return new Environment(this.name, (Map<String, JsonBall>)this.attributes.build(), (Map<String, JsonBall>)this.overrideAttributes.build(), this.description, (Map<String, String>)this.cookbookVersions.build());
        }
    }
}

