/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery.plan;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.get.shard.GetShardSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.shard.GetShardSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.shard.GetShardSnapshotResponse;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.plan.ShardSnapshot;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.ShardSnapshotInfo;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.threadpool.ThreadPool;

public class ShardSnapshotsService {
    private final Logger logger = LogManager.getLogger(ShardSnapshotsService.class);
    private final Client client;
    private final RepositoriesService repositoriesService;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;

    public ShardSnapshotsService(Client client, RepositoriesService repositoriesService, ThreadPool threadPool, ClusterService clusterService) {
        this.client = client;
        this.repositoriesService = repositoriesService;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
    }

    public void fetchLatestSnapshotsForShard(ShardId shardId, ActionListener<Optional<ShardSnapshot>> listener) {
        assert (shardId != null) : "SharId was null but a value was expected";
        RepositoriesMetadata currentReposMetadata = this.clusterService.state().metadata().custom("repositories", RepositoriesMetadata.EMPTY);
        List<String> repositories = currentReposMetadata.repositories().stream().filter(repositoryMetadata -> BlobStoreRepository.USE_FOR_PEER_RECOVERY_SETTING.get(repositoryMetadata.settings())).map(RepositoryMetadata::name).collect(Collectors.toList());
        if (repositories.isEmpty() || !this.masterSupportsFetchingLatestSnapshots()) {
            this.logger.debug("Unable to use snapshots during peer recovery use_for_peer_recovery_repositories=[{}], masterSupportsFetchingLatestSnapshots=[{}]", repositories, (Object)this.masterSupportsFetchingLatestSnapshots());
            listener.onResponse(Optional.empty());
            return;
        }
        this.logger.debug("Searching for peer recovery compatible snapshots in [{}]", repositories);
        GetShardSnapshotRequest request = GetShardSnapshotRequest.latestSnapshotInRepositories(shardId, repositories);
        this.client.execute(GetShardSnapshotAction.INSTANCE, request, new ThreadedActionListener(this.logger, this.threadPool, "generic", listener.map(this::fetchSnapshotFiles), false));
    }

    private Optional<ShardSnapshot> fetchSnapshotFiles(GetShardSnapshotResponse shardSnapshotResponse) {
        assert (Thread.currentThread().getName().contains("generic"));
        Optional<ShardSnapshotInfo> latestShardSnapshotOpt = shardSnapshotResponse.getLatestShardSnapshot();
        if (!latestShardSnapshotOpt.isPresent()) {
            return Optional.empty();
        }
        ShardSnapshotInfo latestShardSnapshot = latestShardSnapshotOpt.get();
        try {
            Snapshot snapshot = latestShardSnapshot.getSnapshot();
            Repository repository = this.repositoriesService.repository(snapshot.getRepository());
            if (!(repository instanceof BlobStoreRepository)) {
                return Optional.empty();
            }
            BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
            BlobContainer blobContainer = blobStoreRepository.shardContainer(latestShardSnapshot.getIndexId(), latestShardSnapshot.getShardId().getId());
            BlobStoreIndexShardSnapshot blobStoreIndexShardSnapshot = blobStoreRepository.loadShardSnapshot(blobContainer, snapshot.getSnapshotId());
            return Optional.of(new ShardSnapshot(latestShardSnapshot, blobStoreIndexShardSnapshot.indexFiles()));
        }
        catch (Exception e) {
            this.logger.warn((Message)new ParameterizedMessage("Unable to fetch shard snapshot files for {}", (Object)latestShardSnapshot), (Throwable)e);
            return Optional.empty();
        }
    }

    protected boolean masterSupportsFetchingLatestSnapshots() {
        return this.clusterService.state().nodes().getMinNodeVersion().onOrAfter(RecoverySettings.SNAPSHOT_RECOVERIES_SUPPORTED_VERSION);
    }
}

