/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;

public abstract class DocumentParserContext {
    private final IndexSettings indexSettings;
    private final IndexAnalyzers indexAnalyzers;
    private final MappingLookup mappingLookup;
    private final Function<DateFormatter, MappingParserContext> parserContextFunction;
    private final SourceToParse sourceToParse;
    private final Set<String> ignoredFields;
    private final Set<String> fieldNameFields;
    private final List<Mapper> dynamicMappers;
    private final Set<String> newFieldsSeen;
    private final Map<String, ObjectMapper> dynamicObjectMappers;
    private final List<RuntimeField> dynamicRuntimeFields;
    private Field version;
    private SeqNoFieldMapper.SequenceIDFields seqID;

    private DocumentParserContext(DocumentParserContext in) {
        this.mappingLookup = in.mappingLookup;
        this.indexSettings = in.indexSettings;
        this.indexAnalyzers = in.indexAnalyzers;
        this.parserContextFunction = in.parserContextFunction;
        this.sourceToParse = in.sourceToParse;
        this.ignoredFields = in.ignoredFields;
        this.fieldNameFields = in.fieldNameFields;
        this.dynamicMappers = in.dynamicMappers;
        this.newFieldsSeen = in.newFieldsSeen;
        this.dynamicObjectMappers = in.dynamicObjectMappers;
        this.dynamicRuntimeFields = in.dynamicRuntimeFields;
        this.version = in.version;
        this.seqID = in.seqID;
    }

    protected DocumentParserContext(MappingLookup mappingLookup, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, Function<DateFormatter, MappingParserContext> parserContextFunction, SourceToParse source) {
        this.mappingLookup = mappingLookup;
        this.indexSettings = indexSettings;
        this.indexAnalyzers = indexAnalyzers;
        this.parserContextFunction = parserContextFunction;
        this.sourceToParse = source;
        this.ignoredFields = new HashSet<String>();
        this.fieldNameFields = new HashSet<String>();
        this.dynamicMappers = new ArrayList<Mapper>();
        this.newFieldsSeen = new HashSet<String>();
        this.dynamicObjectMappers = new HashMap<String, ObjectMapper>();
        this.dynamicRuntimeFields = new ArrayList<RuntimeField>();
    }

    public final IndexSettings indexSettings() {
        return this.indexSettings;
    }

    public final IndexAnalyzers indexAnalyzers() {
        return this.indexAnalyzers;
    }

    public final RootObjectMapper root() {
        return this.mappingLookup.getMapping().getRoot();
    }

    public final MappingLookup mappingLookup() {
        return this.mappingLookup;
    }

    public final MetadataFieldMapper getMetadataMapper(String mapperName) {
        return this.mappingLookup.getMapping().getMetadataMapperByName(mapperName);
    }

    public final MappingParserContext dynamicTemplateParserContext(DateFormatter dateFormatter) {
        return this.parserContextFunction.apply(dateFormatter);
    }

    public final SourceToParse sourceToParse() {
        return this.sourceToParse;
    }

    public final void addIgnoredField(String field) {
        this.ignoredFields.add(field);
    }

    public final Collection<String> getIgnoredFields() {
        return Collections.unmodifiableCollection(this.ignoredFields);
    }

    public final void addToFieldNames(String field) {
        this.fieldNameFields.add(field);
    }

    public final Collection<String> getFieldNames() {
        return Collections.unmodifiableCollection(this.fieldNameFields);
    }

    public final Field version() {
        return this.version;
    }

    public final void version(Field version) {
        this.version = version;
    }

    public final SeqNoFieldMapper.SequenceIDFields seqID() {
        return this.seqID;
    }

    public final void seqID(SeqNoFieldMapper.SequenceIDFields seqID) {
        this.seqID = seqID;
    }

    public final void addDynamicMapper(Mapper mapper) {
        if (this.mappingLookup.getMapper(mapper.name()) == null && !this.mappingLookup.objectMappers().containsKey(mapper.name()) && this.newFieldsSeen.add(mapper.name())) {
            this.mappingLookup.checkFieldLimit(this.indexSettings().getMappingTotalFieldsLimit(), this.newFieldsSeen.size());
        }
        if (mapper instanceof ObjectMapper) {
            this.dynamicObjectMappers.put(mapper.name(), (ObjectMapper)mapper);
        }
        this.dynamicMappers.add(mapper);
    }

    public final List<Mapper> getDynamicMappers() {
        return this.dynamicMappers;
    }

    public final boolean isShadowed(String field) {
        return this.mappingLookup.isShadowed(field);
    }

    public final ObjectMapper getObjectMapper(String name) {
        return this.dynamicObjectMappers.get(name);
    }

    public final void addDynamicRuntimeField(RuntimeField runtimeField) {
        this.dynamicRuntimeFields.add(runtimeField);
    }

    public final List<RuntimeField> getDynamicRuntimeFields() {
        return Collections.unmodifiableList(this.dynamicRuntimeFields);
    }

    public abstract Iterable<LuceneDocument> nonRootDocuments();

    public final DocumentParserContext createCopyToContext() {
        return new Wrapper(this){

            @Override
            public boolean isWithinCopyTo() {
                return true;
            }
        };
    }

    public boolean isWithinCopyTo() {
        return false;
    }

    public final DocumentParserContext createMultiFieldContext() {
        return new Wrapper(this){

            @Override
            public boolean isWithinMultiFields() {
                return true;
            }
        };
    }

    public boolean isWithinMultiFields() {
        return false;
    }

    public final DocumentParserContext createNestedContext(String fullPath) {
        LuceneDocument doc = new LuceneDocument(fullPath, this.doc());
        this.addDoc(doc);
        return this.switchDoc(doc);
    }

    public final DocumentParserContext switchDoc(final LuceneDocument document) {
        return new Wrapper(this){

            @Override
            public LuceneDocument doc() {
                return document;
            }
        };
    }

    public final DocumentParserContext overridePath(final ContentPath path) {
        return new Wrapper(this){

            @Override
            public ContentPath path() {
                return path;
            }
        };
    }

    @Deprecated
    public final DocumentParserContext switchParser(final XContentParser parser) {
        return new Wrapper(this){

            @Override
            public XContentParser parser() {
                return parser;
            }
        };
    }

    public abstract ContentPath path();

    public abstract XContentParser parser();

    public abstract LuceneDocument rootDoc();

    public abstract List<LuceneDocument> docs();

    public abstract LuceneDocument doc();

    protected abstract void addDoc(LuceneDocument var1);

    public final DynamicTemplate findDynamicTemplate(String fieldName, DynamicTemplate.XContentFieldType matchType) {
        String pathAsString = this.path().pathAsText(fieldName);
        String matchTemplateName = this.sourceToParse().dynamicTemplates().get(pathAsString);
        for (DynamicTemplate template : this.root().dynamicTemplates()) {
            if (!template.match(matchTemplateName, pathAsString, fieldName, matchType)) continue;
            return template;
        }
        if (matchTemplateName != null) {
            throw new MapperParsingException("Can't find dynamic template for dynamic template name [" + matchTemplateName + "] of field [" + pathAsString + "]");
        }
        return null;
    }

    private static class Wrapper
    extends DocumentParserContext {
        private final DocumentParserContext in;

        private Wrapper(DocumentParserContext in) {
            super(in);
            this.in = in;
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            return this.in.nonRootDocuments();
        }

        @Override
        public boolean isWithinCopyTo() {
            return this.in.isWithinCopyTo();
        }

        @Override
        public boolean isWithinMultiFields() {
            return this.in.isWithinMultiFields();
        }

        @Override
        public ContentPath path() {
            return this.in.path();
        }

        @Override
        public XContentParser parser() {
            return this.in.parser();
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.in.rootDoc();
        }

        @Override
        public List<LuceneDocument> docs() {
            return this.in.docs();
        }

        @Override
        public LuceneDocument doc() {
            return this.in.doc();
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            this.in.addDoc(doc);
        }
    }
}

