/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetIndexAction
extends TransportClusterInfoAction<GetIndexRequest, GetIndexResponse> {
    private final IndicesService indicesService;
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportGetIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, IndexScopedSettings indexScopedSettings) {
        super("indices:admin/get", transportService, clusterService, threadPool, actionFilters, GetIndexRequest::new, indexNameExpressionResolver, GetIndexResponse::new);
        this.indicesService = indicesService;
        this.settingsFilter = settingsFilter;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected void doMasterOperation(Task task, GetIndexRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetIndexResponse> listener) {
        ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappingsResult = ImmutableOpenMap.of();
        ImmutableOpenMap<String, List<AliasMetadata>> aliasesResult = ImmutableOpenMap.of();
        ImmutableOpenMap<String, Settings> settings = ImmutableOpenMap.of();
        ImmutableOpenMap<String, Settings> defaultSettings = ImmutableOpenMap.of();
        ImmutableOpenMap<String, String> dataStreams = ImmutableOpenMap.builder().putAll(StreamSupport.stream(state.metadata().findDataStreams(concreteIndices).spliterator(), false).collect(Collectors.toMap(k -> (String)k.key, v -> ((IndexAbstraction.DataStream)v.value).getName()))).build();
        GetIndexRequest.Feature[] features = request.features();
        boolean doneAliases = false;
        boolean doneMappings = false;
        boolean doneSettings = false;
        block7: for (GetIndexRequest.Feature feature : features) {
            switch (feature) {
                case MAPPINGS: {
                    if (doneMappings) continue block7;
                    try {
                        mappingsResult = state.metadata().findMappings(concreteIndices, request.types(), this.indicesService.getFieldFilter(), Metadata.ON_NEXT_INDEX_FIND_MAPPINGS_NOOP);
                        doneMappings = true;
                        continue block7;
                    }
                    catch (IOException e) {
                        listener.onFailure(e);
                        return;
                    }
                }
                case ALIASES: {
                    if (doneAliases) continue block7;
                    aliasesResult = state.metadata().findAllAliases(concreteIndices);
                    doneAliases = true;
                    continue block7;
                }
                case SETTINGS: {
                    if (doneSettings) continue block7;
                    ImmutableOpenMap.Builder<String, Settings> settingsMapBuilder = ImmutableOpenMap.builder();
                    ImmutableOpenMap.Builder<String, Settings> defaultSettingsMapBuilder = ImmutableOpenMap.builder();
                    for (String index : concreteIndices) {
                        Settings indexSettings = state.metadata().index(index).getSettings();
                        if (request.humanReadable()) {
                            indexSettings = IndexMetadata.addHumanReadableSettings(indexSettings);
                        }
                        settingsMapBuilder.put(index, indexSettings);
                        if (!request.includeDefaults()) continue;
                        Settings defaultIndexSettings = this.settingsFilter.filter(this.indexScopedSettings.diff(indexSettings, Settings.EMPTY));
                        defaultSettingsMapBuilder.put(index, defaultIndexSettings);
                    }
                    settings = settingsMapBuilder.build();
                    defaultSettings = defaultSettingsMapBuilder.build();
                    doneSettings = true;
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("feature [" + (Object)((Object)feature) + "] is not valid");
                }
            }
        }
        listener.onResponse(new GetIndexResponse(concreteIndices, mappingsResult, aliasesResult, settings, defaultSettings, dataStreams));
    }
}

