/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.LongCollection;
import bak.pcj.adapter.CollectionToLongCollectionAdapter;
import bak.pcj.adapter.SetToByteSetAdapter;
import bak.pcj.map.AbstractByteKeyLongMap;
import bak.pcj.map.ByteKeyLongMap;
import bak.pcj.map.ByteKeyLongMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToByteKeyLongMapAdapter
extends AbstractByteKeyLongMap
implements ByteKeyLongMap {
    protected Map map;
    protected Long lastValue;

    public MapToByteKeyLongMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToByteKeyLongMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(byte key) {
        this.lastValue = (Long)this.map.get(new Byte(key));
        return this.lastValue != null;
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(new Long(value));
    }

    public ByteKeyLongMapIterator entries() {
        return new ByteKeyLongMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToByteKeyLongMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public byte getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getKey();
            }

            public long getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Long)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public long get(byte key) {
        Long value = (Long)this.map.get(new Byte(key));
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public ByteSet keySet() {
        return new SetToByteSetAdapter(this.map.keySet());
    }

    public long lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public long put(byte key, long value) {
        Long oldValue = this.map.put(new Byte(key), new Long(value));
        return oldValue == null ? MapDefaults.defaultLong() : oldValue;
    }

    public long remove(byte key) {
        Long value = (Long)this.map.remove(new Byte(key));
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public int size() {
        return this.map.size();
    }

    public LongCollection values() {
        return new CollectionToLongCollectionAdapter(this.map.values());
    }

    public long tget(byte key) {
        Long value = (Long)this.map.get(new Byte(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isByteKeyLongAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

