/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.model.resource.locator.ServletContextUriLocator;
import ro.isdc.wro.util.WroUtil;

public final class StandaloneServletContextUriLocator
extends ServletContextUriLocator {
    private final StandaloneContext standaloneContext;
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneServletContextUriLocator.class);

    public StandaloneServletContextUriLocator(StandaloneContext standaloneContext) {
        Validate.notNull((Object)standaloneContext);
        this.standaloneContext = standaloneContext;
    }

    public InputStream locate(String uri) throws IOException {
        String[] contextFolders;
        IOException lastException = null;
        for (String contextFolder : contextFolders = this.standaloneContext.getContextFolders()) {
            try {
                return this.locateStreamWithContextFolder(uri, contextFolder);
            }
            catch (IOException e) {
                lastException = e;
                LOG.debug("Could not locate: {} using contextFolder: {}", (Object)uri, (Object)contextFolder);
            }
        }
        String exceptionMessage = String.format("No valid resource '%s' found inside any of contextFolders: %s", uri, Arrays.toString(this.standaloneContext.getContextFolders()));
        throw new IOException(exceptionMessage, lastException);
    }

    private InputStream locateStreamWithContextFolder(String uri, String contextFolder) throws IOException, FileNotFoundException {
        if (this.getWildcardStreamLocator().hasWildcard(uri)) {
            String fullPath = WroUtil.getFullPath(uri);
            String realPath = contextFolder + fullPath;
            return this.getWildcardStreamLocator().locateStream(uri, new File(realPath));
        }
        String uriWithoutPrefix = uri.replaceFirst("/", "");
        File file = new File(contextFolder, uriWithoutPrefix);
        LOG.debug("Opening file: " + file.getPath());
        return new FileInputStream(file);
    }
}

