/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.GraphPatternQuery;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.TriplePattern;
import org.openrdf.sesame.sail.query.Var;

public class ConstructQuery
extends GraphPatternQuery {
    private TriplePattern[] _projection;
    private Set _anonymousVars = new HashSet(8);

    public ConstructQuery(boolean distinct, List projection, GraphPattern graphPattern) {
        this(distinct, 0, Integer.MAX_VALUE, projection, graphPattern);
    }

    public ConstructQuery(boolean distinct, int offset, int limit, List projection, GraphPattern graphPattern) {
        super(distinct, offset, limit, graphPattern);
        this.setProjection(projection);
    }

    public TriplePattern[] getProjection() {
        return this._projection;
    }

    public void setProjection(List projection) {
        TriplePattern[] projArray = new TriplePattern[projection.size()];
        projArray = projection.toArray(projArray);
        this.setProjection(projArray);
    }

    public void setProjection(TriplePattern[] projection) {
        this._projection = projection;
        this._anonymousVars.clear();
        for (int i = 0; i < projection.length; ++i) {
            TriplePattern tp = projection[i];
            if (tp.getSubjectVar().isAnonymous()) {
                this._anonymousVars.add(tp.getSubjectVar());
            }
            if (tp.getPredicateVar().isAnonymous()) {
                this._anonymousVars.add(tp.getPredicateVar());
            }
            if (!tp.getObjectVar().isAnonymous()) continue;
            this._anonymousVars.add(tp.getObjectVar());
        }
    }

    public void getProjectionVariables(Collection variables) {
        for (int i = 0; i < this._projection.length; ++i) {
            this._projection[i].getVariables(variables);
        }
    }

    public String[] getColumnHeaders() {
        return new String[]{"subject", "predicate", "object"};
    }

    protected boolean _reportQueryAnswer(RdfSource rdfSource, QueryAnswerListener listener) throws IOException {
        int i;
        ArrayList<Var> filledVars = new ArrayList<Var>(8);
        ValueFactory valFactory = rdfSource.getValueFactory();
        Iterator iter = this._anonymousVars.iterator();
        while (iter.hasNext()) {
            Var var = (Var)iter.next();
            if (var.hasValue()) continue;
            var.setValue((Value)valFactory.createBNode());
            filledVars.add(var);
        }
        boolean reportMore = true;
        for (i = 0; reportMore && i < this._projection.length; ++i) {
            TriplePattern tp = this._projection[i];
            Value subject = tp.getSubjectVar().getValue();
            Value predicate = tp.getPredicateVar().getValue();
            Value object = tp.getObjectVar().getValue();
            if (subject == null || predicate == null || object == null) continue;
            Value[] values = new Value[]{subject, predicate, object};
            reportMore = listener.queryAnswer(new QueryAnswer(values));
        }
        for (i = 0; i < filledVars.size(); ++i) {
            Var var = (Var)filledVars.get(i);
            var.setValue(null);
        }
        return reportMore;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("construct ");
        if (this.isDistinct()) {
            result.append("distinct ");
        }
        for (int i = 0; i < this._projection.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this._projection[i].toString());
        }
        result.append("\nfrom\n");
        result.append(this.getGraphPattern().toString());
        if (this.hasLimit()) {
            result.append("\nlimit ").append(this.getLimit());
        }
        if (this.hasOffset()) {
            result.append("\noffset ").append(this.getOffset());
        }
        return result.toString();
    }
}

