/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.lib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import org.fao.geonet.Util;
import org.fao.geonet.utils.IO;

public class TextLib {
    private static final Random RANDOM = new Random();

    public List<String> load(ServletContext servletContext, Path appPath, Path file) throws IOException {
        return this.load(servletContext, appPath, file, "ISO-8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> load(ServletContext servletContext, Path appPath, Path file, String encoding) throws IOException {
        BufferedReader reader = IO.newBufferedReader((Path)file, (Charset)Charset.forName(encoding));
        ArrayList<String> al = new ArrayList<String>();
        String line = reader.readLine();
        try {
            while (line != null) {
                al.add(line);
                line = reader.readLine();
            }
            ArrayList<String> arrayList = al;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    public void save(Path file, List<String> lines) throws IOException {
        try (BufferedWriter ow = Files.newBufferedWriter(file, Charset.forName("ISO-8859-1"), new OpenOption[0]);){
            for (String line : lines) {
                ow.write(line);
                ow.newLine();
            }
        }
    }

    public String getProperty(List<String> lines, String name) {
        for (String line : lines) {
            int pos;
            if (line.startsWith("#") || (pos = line.indexOf("=")) == -1) continue;
            String curName = line.substring(0, pos).trim();
            String curValue = line.substring(pos + 1).trim();
            if (!name.equals(curName)) continue;
            return curValue;
        }
        return null;
    }

    public void setProperty(List<String> lines, String name, String value) {
        for (int i = 0; i < lines.size(); ++i) {
            String curName;
            String line = lines.get(i).trim();
            int pos = line.indexOf(61);
            if (line.startsWith("#") || pos == -1 || !name.equals(curName = line.substring(0, pos).trim())) continue;
            lines.set(i, name + "=" + value);
            return;
        }
        lines.add(name + "=" + value);
    }

    public String getRandomString(int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append(this.getRandomChar());
        }
        return sb.toString();
    }

    public char getRandomChar() {
        int pos = RANDOM.nextInt() * 62;
        if (pos < 26) {
            return (char)(97 + pos);
        }
        if ((pos -= 26) < 26) {
            return (char)(65 + pos);
        }
        return (char)(48 + (pos -= 26));
    }

    public void replace(List<String> lines, Map<String, ? extends Object> vars) {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            for (Map.Entry<String, ? extends Object> entry : vars.entrySet()) {
                line = Util.replaceString((String)line, (String)entry.getKey(), (String)entry.getValue().toString());
            }
            lines.set(i, line);
        }
    }
}

