/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.mef;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Constants;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.api.records.attachments.StoreUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.Log;

class MEFExporter {
    MEFExporter() {
    }

    public static Path doExport(ServiceContext context, String uuid, MEFLib.Format format, boolean skipUUID, boolean resolveXlink, boolean removeXlinkAttribute, boolean addSchemaLocation, boolean approved) throws Exception {
        int id = approved ? Integer.parseInt(context.getBean(IMetadataUtils.class).getMetadataId(uuid)) : context.getBean(IMetadataUtils.class).findOneByUuid(uuid).getId();
        Pair<AbstractMetadata, String> recordAndMetadata = MEFLib.retrieveMetadata(context, id, resolveXlink, removeXlinkAttribute, addSchemaLocation);
        return MEFExporter.export(context, approved, format, skipUUID, recordAndMetadata);
    }

    public static Path doExport(ServiceContext context, Integer id, MEFLib.Format format, boolean skipUUID, boolean resolveXlink, boolean removeXlinkAttribute, boolean addSchemaLocation) throws Exception {
        Pair<AbstractMetadata, String> recordAndMetadata = MEFLib.retrieveMetadata(context, id, resolveXlink, removeXlinkAttribute, addSchemaLocation);
        return MEFExporter.export(context, true, format, skipUUID, recordAndMetadata);
    }

    private static Path export(ServiceContext context, boolean approved, MEFLib.Format format, boolean skipUUID, Pair<AbstractMetadata, String> recordAndMetadata) throws Exception {
        AbstractMetadata record = (AbstractMetadata)recordAndMetadata.one();
        String xmlDocumentAsString = (String)recordAndMetadata.two();
        if (record.getDataInfo().getType() == MetadataType.SUB_TEMPLATE || record.getDataInfo().getType() == MetadataType.TEMPLATE_OF_SUB_TEMPLATE) {
            throw new Exception("Cannot export sub template");
        }
        Path file = Files.createTempFile("mef-", ".mef", new FileAttribute[0]);
        Store store = context.getBean("resourceStore", Store.class);
        try (FileSystem zipFs = ZipUtil.createZipFs((Path)file);){
            byte[] binData = xmlDocumentAsString.getBytes(Constants.ENCODING);
            Files.write(zipFs.getPath("metadata.xml", new String[0]), binData, new OpenOption[0]);
            List<MetadataResource> publicResources = store.getResources(context, record.getUuid(), MetadataResourceVisibility.PUBLIC, null, (Boolean)approved);
            List<MetadataResource> privateResources = store.getResources(context, record.getUuid(), MetadataResourceVisibility.PRIVATE, null, (Boolean)approved);
            binData = MEFLib.buildInfoFile(context, record, format, publicResources, privateResources, skipUUID).getBytes(Constants.ENCODING);
            Files.write(zipFs.getPath("info.xml", new String[0]), binData, new OpenOption[0]);
            if (format == MEFLib.Format.PARTIAL || format == MEFLib.Format.FULL && !publicResources.isEmpty()) {
                StoreUtils.extract(context, record.getUuid(), publicResources, zipFs.getPath("public", new String[0]), approved);
            }
            if (format == MEFLib.Format.FULL && !privateResources.isEmpty()) {
                try {
                    Lib.resource.checkPrivilege(context, "" + record.getId(), ReservedOperation.download);
                    StoreUtils.extract(context, record.getUuid(), privateResources, zipFs.getPath("private", new String[0]), approved);
                }
                catch (Exception e) {
                    Log.warning((String)"geonetwork.mef", (Object)("Error encountered while trying to import private resources of MEF file. MEF ID: " + record.getId()), (Throwable)e);
                }
            }
        }
        return file;
    }
}

