/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.base;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.UserGroupId;
import org.fao.geonet.events.md.MetadataPublished;
import org.fao.geonet.events.md.MetadataUnpublished;
import org.fao.geonet.exceptions.ServiceNotAllowedEx;
import org.fao.geonet.kernel.SvnManager;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.repository.specification.UserSpecs;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.jpa.domain.Specification;

public class BaseMetadataOperations
implements IMetadataOperations,
ApplicationEventPublisherAware {
    @Autowired
    private IMetadataUtils metadataUtils;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OperationAllowedRepository opAllowedRepo;
    @Autowired
    private UserGroupRepository userGroupRepo;
    @Autowired
    @Lazy
    private SettingManager settingManager;
    @Autowired(required=false)
    private SvnManager svnManager;
    private ApplicationEventPublisher eventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void init(ServiceContext context, Boolean force) throws Exception {
    }

    @Override
    public void deleteMetadataOper(ServiceContext context, String metadataId, boolean skipAllReservedGroup) throws Exception {
        this.deleteMetadataOper(metadataId, skipAllReservedGroup);
    }

    @Override
    public void deleteMetadataOper(String metadataId, boolean skipAllReservedGroup) throws Exception {
        if (skipAllReservedGroup) {
            List<Integer> exclude = Arrays.asList(ReservedGroup.all.getId(), ReservedGroup.intranet.getId(), ReservedGroup.guest.getId());
            this.opAllowedRepo.deleteAllByMetadataIdExceptGroupId(Integer.parseInt(metadataId), exclude);
        } else {
            this.opAllowedRepo.deleteAllByMetadataId(Integer.parseInt(metadataId));
        }
    }

    @Override
    public void setOperation(ServiceContext context, String mdId, String grpId, ReservedOperation op) throws Exception {
        this.setOperation(context, Integer.parseInt(mdId), Integer.parseInt(grpId), op.getId());
    }

    @Override
    public void setOperation(ServiceContext context, String mdId, String grpId, String opId) throws Exception {
        this.setOperation(context, Integer.parseInt(mdId), Integer.parseInt(grpId), Integer.valueOf(opId));
    }

    @Override
    public boolean setOperation(ServiceContext context, int mdId, int grpId, int opId) throws Exception {
        Optional<OperationAllowed> opAllowed = this.getOperationAllowedToAdd(context, mdId, grpId, opId);
        if (opAllowed.isPresent()) {
            return this.forceSetOperation(context, mdId, grpId, opId);
        }
        return false;
    }

    @Override
    public boolean forceSetOperation(ServiceContext context, int mdId, int grpId, int opId) throws Exception {
        Optional<OperationAllowed> opAllowed = this._getOperationAllowedToAdd(context, mdId, grpId, opId, false);
        if (opAllowed.isPresent()) {
            Log.trace((String)"geonetwork.datamanager", (Object)"Operation is allowed");
            this.opAllowedRepo.save(opAllowed.get());
            this.svnManager.setHistory(mdId + "", context);
            if (opId == ReservedOperation.view.getId() && grpId == ReservedGroup.all.getId()) {
                Log.trace((String)"geonetwork.datamanager", (Object)"This is a publish event");
                this.eventPublisher.publishEvent((ApplicationEvent)new MetadataPublished(this.metadataUtils.findOne(mdId)));
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<OperationAllowed> getOperationAllowedToAdd(ServiceContext context, int mdId, int grpId, int opId) {
        return this._getOperationAllowedToAdd(context, mdId, grpId, opId, true);
    }

    private Optional<OperationAllowed> _getOperationAllowedToAdd(ServiceContext context, int mdId, int grpId, int opId, boolean shouldCheckPermission) {
        Log.trace((String)"geonetwork.datamanager", (Object)("_getOperationAllowedToAdd(" + mdId + ", " + grpId + ", " + opId + ", " + shouldCheckPermission + ")"));
        OperationAllowed operationAllowed = this.opAllowedRepo.findOneById_GroupIdAndId_MetadataIdAndId_OperationId(grpId, mdId, opId);
        if (operationAllowed == null && shouldCheckPermission) {
            Log.trace((String)"geonetwork.datamanager", (Object)"Checking if the operation is allowed, the operation is not yet present");
            this.checkOperationPermission(context, grpId, this.userGroupRepo);
        }
        if (operationAllowed == null) {
            Log.trace((String)"geonetwork.datamanager", (Object)"Returning operation to add");
            return Optional.of((Object)new OperationAllowed(new OperationAllowedId().setGroupId(grpId).setMetadataId(mdId).setOperationId(opId)));
        }
        Log.trace((String)"geonetwork.datamanager", (Object)"Operation is already available");
        return Optional.absent();
    }

    @Override
    public void checkOperationPermission(ServiceContext context, int grpId, UserGroupRepository userGroupRepo) {
        Profile userProfile;
        if (context.getUserSession() != null && (userProfile = context.getUserSession().getProfile()) != Profile.Administrator && userProfile != Profile.UserAdmin) {
            int userId = context.getUserSession().getUserIdAsInt();
            if (ReservedGroup.isReserved((int)grpId)) {
                Specification hasUserIdAndProfile = Specification.where((Specification)UserGroupSpecs.hasProfile((Profile)Profile.Reviewer)).and(UserGroupSpecs.hasUserId((int)userId));
                List groupIds = userGroupRepo.findGroupIds(hasUserIdAndProfile);
                if (groupIds.isEmpty()) {
                    throw new ServiceNotAllowedEx("User can't set operation for group " + grpId + " because the user in not a Reviewer of any group.");
                }
            } else {
                String userGroupsOnly = this.settingManager.getValue("system/metadataprivs/usergrouponly");
                if (userGroupsOnly.equals("true") && userGroupRepo.existsById((Object)new UserGroupId().setGroupId(grpId).setUserId(userId))) {
                    throw new ServiceNotAllowedEx("User can't set operation for group " + grpId + " because the user in not member of this group.");
                }
            }
        }
    }

    @Override
    public void unsetOperation(ServiceContext context, String mdId, String grpId, ReservedOperation opId) throws Exception {
        this.unsetOperation(context, Integer.parseInt(mdId), Integer.parseInt(grpId), opId.getId());
    }

    @Override
    public void unsetOperation(ServiceContext context, String mdId, String grpId, String opId) throws Exception {
        this.unsetOperation(context, Integer.parseInt(mdId), Integer.parseInt(grpId), Integer.valueOf(opId));
    }

    @Override
    public void unsetOperation(ServiceContext context, int mdId, int groupId, int operId) throws Exception {
        this.checkOperationPermission(context, groupId, context.getBean(UserGroupRepository.class));
        this.forceUnsetOperation(context, mdId, groupId, operId);
    }

    @Override
    public void forceUnsetOperation(ServiceContext context, int mdId, int groupId, int operId) throws Exception {
        OperationAllowedId id = new OperationAllowedId().setGroupId(groupId).setMetadataId(mdId).setOperationId(operId);
        if (this.opAllowedRepo.existsById((Object)id)) {
            this.opAllowedRepo.deleteById((Object)id);
            if (this.svnManager != null) {
                this.svnManager.setHistory(mdId + "", context);
            }
            if (operId == ReservedOperation.view.getId() && groupId == ReservedGroup.all.getId()) {
                this.eventPublisher.publishEvent((ApplicationEvent)new MetadataUnpublished(this.metadataUtils.findOne(mdId)));
            }
        }
    }

    @Override
    public void copyDefaultPrivForGroup(ServiceContext context, String id, String groupId, boolean fullRightsForGroup) throws Exception {
        if (StringUtils.isBlank((String)groupId)) {
            Log.info((String)"geonetwork.datamanager", (Object)("Attempt to set default privileges for metadata " + id + " to an empty groupid"));
            return;
        }
        this.setOperation(context, id, groupId, ReservedOperation.view);
        this.setOperation(context, id, groupId, ReservedOperation.notify);
        if (fullRightsForGroup) {
            this.setOperation(context, id, groupId, ReservedOperation.editing);
            this.setOperation(context, id, groupId, ReservedOperation.download);
            this.setOperation(context, id, groupId, ReservedOperation.dynamic);
        }
    }

    @Override
    public boolean isUserMetadataOwner(int userId) throws Exception {
        return this.metadataUtils.count((Specification<? extends AbstractMetadata>)MetadataSpecs.isOwnedByUser((int)userId)) > 0L;
    }

    @Override
    public boolean existsUser(ServiceContext context, int id) throws Exception {
        return this.userRepository.count(Specification.where((Specification)UserSpecs.hasUserId((int)id))) > 0L;
    }

    @Override
    public Collection<OperationAllowed> getAllOperations(int id) {
        return this.opAllowedRepo.findAllById_MetadataId(id);
    }
}

