/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import org.geotools.data.postgis.FilterToSqlHelper;
import org.geotools.data.postgis.PostGISPSDialect;
import org.geotools.data.postgis.filter.FilterFunction_pgNearest;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.InArrayFunction;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DistanceBufferOperator;

public class PostgisPSFilterToSql
extends PreparedFilterToSQL {
    FilterToSqlHelper helper = new FilterToSqlHelper(this);
    boolean functionEncodingEnabled;

    public PostgisPSFilterToSql(PostGISPSDialect dialect) {
        super(dialect);
    }

    public boolean isLooseBBOXEnabled() {
        return this.helper.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.helper.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean isEncodeBBOXFilterAsEnvelope(boolean encodeBBOXFilterAsEnvelope) {
        return this.helper.encodeBBOXFilterAsEnvelope;
    }

    public void setEncodeBBOXFilterAsEnvelope(boolean encodeBBOXFilterAsEnvelope) {
        this.helper.encodeBBOXFilterAsEnvelope = encodeBBOXFilterAsEnvelope;
    }

    @Override
    protected FilterCapabilities createFilterCapabilities() {
        return FilterToSqlHelper.createFilterCapabilities(this.functionEncodingEnabled);
    }

    @Override
    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        this.helper.out = this.out;
        return this.helper.visitBinarySpatialOperator(filter, property, geometry, swapped, extraData);
    }

    @Override
    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        this.helper.out = this.out;
        return this.helper.visitBinarySpatialOperator(filter, e1, e2, extraData);
    }

    GeometryDescriptor getCurrentGeometry() {
        return this.currentGeometry;
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.functionEncodingEnabled = functionEncodingEnabled;
    }

    @Override
    protected String getFunctionName(Function function) {
        return this.helper.getFunctionName(function);
    }

    @Override
    public double getDistanceInMeters(DistanceBufferOperator operator) {
        return super.getDistanceInMeters(operator);
    }

    @Override
    public double getDistanceInNativeUnits(DistanceBufferOperator operator) {
        return super.getDistanceInNativeUnits(operator);
    }

    @Override
    public Object visit(Function function, Object extraData) throws RuntimeException {
        this.helper.out = this.out;
        try {
            this.encodingFunction = true;
            boolean encoded = this.helper.visitFunction(function, extraData);
            this.encodingFunction = false;
            if (encoded) {
                return extraData;
            }
            return super.visit(function, extraData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter, Object extraData) throws RuntimeException {
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        Class rightContext = super.getExpressionType(left);
        Class leftContext = super.getExpressionType(right);
        String type = (String)extraData;
        if ((this.helper.isArray(rightContext) || this.helper.isArray(leftContext)) && (left instanceof PropertyName || right instanceof PropertyName)) {
            this.helper.out = this.out;
            this.helper.visitArrayComparison(filter, left, right, rightContext, leftContext, type);
        } else {
            super.visitBinaryComparisonOperator(filter, extraData);
        }
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyIsBetween");
        Expression expr = filter.getExpression();
        Class context = super.getExpressionType(expr);
        if (this.helper.isArray(context)) {
            this.helper.out = this.out;
            this.helper.visitArrayBetween(filter, context.getComponentType(), extraData);
            return extraData;
        }
        return super.visit(filter, extraData);
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.helper.out = this.out;
        FilterFunction_pgNearest nearest = this.helper.getNearestFilter(filter);
        InArrayFunction inArray = this.helper.getInArray(filter);
        if (nearest != null) {
            return this.helper.visit(nearest, extraData, new FilterToSqlHelper.NearestHelperContext(this.dialect, (a, b) -> {
                try {
                    ((PostGISPSDialect)this.dialect).encodeGeometryValue((Geometry)a, this.helper.getFeatureTypeGeometryDimension(), this.helper.getFeatureTypeGeometrySRID(), (StringBuffer)b);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        if (inArray != null) {
            return this.helper.visit(inArray, extraData);
        }
        return super.visit(filter, extraData);
    }
}

