/*
 * Decompiled with CFR 0.152.
 */
package au.com.objectix.jgridshift.jca;

import au.com.objectix.jgridshift.GridShiftFile;
import au.com.objectix.jgridshift.jca.ConnectionFactoryImpl;
import au.com.objectix.jgridshift.jca.ManagedConnectionImpl;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory {
    public static final String RANDOM_FILE = "RandomFile";
    public static final String FILE_STREAM = "FileStream";
    public static final String JDBC_STREAM = "JdbcStream";
    private String dataSource;
    private String gridShiftFile;
    private boolean loadAccuracy = false;
    private String streamLoadedJniName = "java:/ra/jgridshiftfile";
    private transient PrintWriter log;

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        return new ConnectionFactoryImpl(cm, this);
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("Only Managed Connections are supported");
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (RANDOM_FILE.equalsIgnoreCase(this.dataSource)) {
            return new ManagedConnectionImpl(this.gridShiftFile);
        }
        if (FILE_STREAM.equalsIgnoreCase(this.dataSource)) {
            GridShiftFile gsf = null;
            InitialContext ic = null;
            try {
                ic = new InitialContext();
                gsf = (GridShiftFile)ic.lookup(this.streamLoadedJniName);
            }
            catch (NameNotFoundException nnfe) {
                try {
                    gsf = new GridShiftFile();
                    FileInputStream fis = new FileInputStream(this.gridShiftFile);
                    gsf.loadGridShiftFile(fis, this.loadAccuracy);
                    ic.bind(this.streamLoadedJniName, (Object)gsf);
                }
                catch (NameAlreadyBoundException nabe) {
                    try {
                        gsf = (GridShiftFile)ic.lookup(this.streamLoadedJniName);
                    }
                    catch (NamingException ne) {
                        ne.printStackTrace(this.log);
                        ResourceException re = new ResourceException("Failed to find GridShiftFile as name: " + this.streamLoadedJniName);
                        re.setLinkedException((Exception)ne);
                        throw re;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(this.log);
                    ResourceException re = new ResourceException("Failed to bind GridShiftFile as name: " + this.streamLoadedJniName);
                    re.setLinkedException(e);
                    throw re;
                }
            }
            catch (Exception e) {
                e.printStackTrace(this.log);
                ResourceException re = new ResourceException("Failed to acquire stream loaded GridShiftFile");
                re.setLinkedException(e);
                throw re;
            }
            return new ManagedConnectionImpl(gsf);
        }
        throw new ResourceException("Data source type not recognized: " + this.dataSource);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        ManagedConnectionImpl match = null;
        Iterator iterator = connectionSet.iterator();
        if (iterator.hasNext()) {
            match = (ManagedConnectionImpl)iterator.next();
        }
        return match;
    }

    public void setLogWriter(PrintWriter log) throws ResourceException {
        this.log = log;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.log;
    }

    public String getGridShiftFile() {
        return this.gridShiftFile;
    }

    public void setGridShiftFile(String string) {
        this.gridShiftFile = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public String getStreamLoadedJniName() {
        return this.streamLoadedJniName;
    }

    public void setStreamLoadedJniName(String string) {
        this.streamLoadedJniName = string;
    }

    public Boolean isLoadAccuracy() {
        return this.loadAccuracy;
    }

    public void setLoadAccuracy(Boolean b) {
        this.loadAccuracy = b;
    }
}

