/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import io.undertow.UndertowOptions;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.unit.DataSize;
import org.xnio.Option;

public class UndertowWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableUndertowWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public UndertowWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableUndertowWebServerFactory factory) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        FactoryOptions options = new FactoryOptions(factory);
        ServerProperties properties = this.serverProperties;
        map.from(properties::getMaxHttpHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(options.server(UndertowOptions.MAX_HEADER_SIZE));
        map.from(properties::getConnectionTimeout).asInt(Duration::toMillis).to(options.server(UndertowOptions.NO_REQUEST_TIMEOUT));
        this.mapUndertowProperties(factory, options);
        this.mapAccessLogProperties(factory);
        map.from(this::getOrDeduceUseForwardHeaders).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setUseForwardHeaders(arg_0));
    }

    private void mapUndertowProperties(ConfigurableUndertowWebServerFactory factory, FactoryOptions options) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        ServerProperties.Undertow properties = this.serverProperties.getUndertow();
        map.from(properties::getBufferSize).whenNonNull().asInt(DataSize::toBytes).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setBufferSize(arg_0));
        map.from(properties::getIoThreads).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setIoThreads(arg_0));
        map.from(properties::getWorkerThreads).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setWorkerThreads(arg_0));
        map.from(properties::getDirectBuffers).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setUseDirectBuffers(arg_0));
        map.from(properties::getMaxHttpPostSize).as(DataSize::toBytes).when(this::isPositive).to(options.server(UndertowOptions.MAX_ENTITY_SIZE));
        map.from(properties::getMaxParameters).to(options.server(UndertowOptions.MAX_PARAMETERS));
        map.from(properties::getMaxHeaders).to(options.server(UndertowOptions.MAX_HEADERS));
        map.from(properties::getMaxCookies).to(options.server(UndertowOptions.MAX_COOKIES));
        map.from(properties::isAllowEncodedSlash).to(options.server(UndertowOptions.ALLOW_ENCODED_SLASH));
        map.from(properties::isDecodeUrl).to(options.server(UndertowOptions.DECODE_URL));
        map.from(properties::getUrlCharset).as(Charset::name).to(options.server(UndertowOptions.URL_CHARSET));
        map.from(properties::isAlwaysSetKeepAlive).to(options.server(UndertowOptions.ALWAYS_SET_KEEP_ALIVE));
        map.from(properties::getNoRequestTimeout).asInt(Duration::toMillis).to(options.server(UndertowOptions.NO_REQUEST_TIMEOUT));
        map.from(properties.getOptions()::getServer).to(options.forEach(options::server));
        map.from(properties.getOptions()::getSocket).to(options.forEach(options::socket));
    }

    private boolean isPositive(Number value) {
        return value.longValue() > 0L;
    }

    private void mapAccessLogProperties(ConfigurableUndertowWebServerFactory factory) {
        ServerProperties.Undertow.Accesslog properties = this.serverProperties.getUndertow().getAccesslog();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::isEnabled).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogEnabled(arg_0));
        map.from(properties::getDir).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogDirectory(arg_0));
        map.from(properties::getPattern).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogPattern(arg_0));
        map.from(properties::getPrefix).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogPrefix(arg_0));
        map.from(properties::getSuffix).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogSuffix(arg_0));
        map.from(properties::isRotate).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogRotate(arg_0));
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NONE)) {
            CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private static class FactoryOptions {
        private static final Map<String, Option<?>> NAME_LOOKUP;
        private final ConfigurableUndertowWebServerFactory factory;

        FactoryOptions(ConfigurableUndertowWebServerFactory factory) {
            this.factory = factory;
        }

        <T> Consumer<T> server(Option<T> option) {
            return value -> this.factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(option, value)});
        }

        <T> Consumer<T> socket(Option<T> option) {
            return value -> this.factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setSocketOption(option, value)});
        }

        <T> Consumer<Map<String, String>> forEach(Function<Option<T>, Consumer<T>> function) {
            return map -> map.forEach((? super K key, ? super V value) -> {
                Option<?> option = NAME_LOOKUP.get(FactoryOptions.getCanonicalName(key));
                Assert.state((option != null ? 1 : 0) != 0, (String)("Unable to find '" + key + "' in UndertowOptions"));
                Object parsed = option.parseValue(value, this.getClass().getClassLoader());
                ((Consumer)function.apply(option)).accept(parsed);
            });
        }

        private static String getCanonicalName(String name) {
            StringBuilder canonicalName = new StringBuilder(name.length());
            name.chars().filter(Character::isLetterOrDigit).map(Character::toLowerCase).forEach((int c) -> canonicalName.append((char)c));
            return canonicalName.toString();
        }

        static {
            HashMap lookup = new HashMap();
            ReflectionUtils.doWithLocalFields(UndertowOptions.class, field -> {
                int modifiers = field.getModifiers();
                if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Option.class.isAssignableFrom(field.getType())) {
                    try {
                        Option option = (Option)field.get(null);
                        lookup.put(FactoryOptions.getCanonicalName(field.getName()), option);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            });
            NAME_LOOKUP = Collections.unmodifiableMap(lookup);
        }
    }
}

