/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/{portal}/api/site/threads"})
@Controller(value="/thread")
public class Threads {
    @RequestMapping(value={"/status"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public ThreadResponse status() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = bean.dumpAllThreads(true, true);
        ThreadResponse response = new ThreadResponse();
        response.threadContentionMonitoringEnabled = bean.isThreadContentionMonitoringEnabled();
        response.threadContentionMonitoringSupported = bean.isThreadContentionMonitoringSupported();
        response.threadCpuTimeEnabled = bean.isThreadCpuTimeEnabled();
        response.threadCpuTimeSupported = bean.isThreadCpuTimeSupported();
        HashSet deadlockedThreadIds = Sets.newHashSet();
        long[] deadlockedThreads = bean.findDeadlockedThreads();
        if (deadlockedThreads != null) {
            for (long id : deadlockedThreads) {
                deadlockedThreadIds.add(id);
            }
        }
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo.getThreadId() == Thread.currentThread().getId()) continue;
            long userTime = bean.getThreadUserTime(threadInfo.getThreadId());
            long cpuTime = bean.getThreadCpuTime(threadInfo.getThreadId());
            boolean isDeadlocked = deadlockedThreadIds.contains(threadInfo.getThreadId());
            response.threads.add(new ThreadDetail(threadInfo, userTime, cpuTime, isDeadlocked));
        }
        return response;
    }

    @RequestMapping(value={"/trace/{threadid}"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public StackTrace trace(@PathVariable String threadid) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        StackTraceElement[] stackTrace = bean.getThreadInfo(Long.parseLong(threadid), 50).getStackTrace();
        return new StackTrace(stackTrace);
    }

    @RequestMapping(value={"/debugging/{contention}/{enablement}"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public ThreadResponse debugging(@PathVariable(value="contention") boolean threadContentionMonitoring, @PathVariable boolean enablement) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        if (threadContentionMonitoring && bean.isThreadContentionMonitoringSupported()) {
            bean.setThreadContentionMonitoringEnabled(enablement);
        }
        if (!threadContentionMonitoring && bean.isThreadCpuTimeSupported()) {
            bean.setThreadCpuTimeEnabled(enablement);
        }
        return this.status();
    }

    @XmlRootElement(name="stackTrace")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class StackTrace
    implements Serializable {
        @XmlElement(name="stackTrace")
        private final String stackTrace;

        private StackTrace() {
            this.stackTrace = "";
        }

        private StackTrace(StackTraceElement[] stackTrace) {
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement element : stackTrace) {
                builder.append(element.toString()).append('\n');
            }
            this.stackTrace = builder.toString();
        }

        public String getStackTrace() {
            return this.stackTrace;
        }
    }

    @XmlRootElement(name="thread")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ThreadDetail
    implements Serializable {
        @XmlElement(name="name")
        private final String name;
        @XmlElement(name="id")
        private final long id;
        @XmlElement(name="state")
        private final String state;
        @XmlElement(name="userTime")
        private final long userTime;
        @XmlElement(name="cpuTime")
        private final long cpuTime;
        @XmlElement(name="waitTime")
        private final long waitTime;
        @XmlElement(name="blockedTime")
        private final long blockedTime;
        @XmlElement(name="deadlocked")
        private final boolean deadlocked;

        public ThreadDetail() {
            this.name = "";
            this.id = -1L;
            this.state = Thread.State.RUNNABLE.name();
            this.userTime = -1L;
            this.cpuTime = -1L;
            this.deadlocked = false;
            this.waitTime = -1L;
            this.blockedTime = -1L;
        }

        public ThreadDetail(ThreadInfo threadInfo, long userTime, long cpuTime, boolean isDeadlocked) {
            this.name = threadInfo.getThreadName();
            this.id = threadInfo.getThreadId();
            this.state = threadInfo.getThreadState().name();
            this.userTime = userTime;
            this.cpuTime = cpuTime;
            this.deadlocked = isDeadlocked;
            this.blockedTime = threadInfo.getBlockedTime();
            this.waitTime = threadInfo.getWaitedTime();
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public String getState() {
            return this.state;
        }

        public long getUserTime() {
            return this.userTime;
        }

        public long getCpuTime() {
            return this.cpuTime;
        }

        public long getWaitTime() {
            return this.waitTime;
        }

        public long getBlockedTime() {
            return this.blockedTime;
        }

        public boolean isDeadlocked() {
            return this.deadlocked;
        }
    }

    @XmlRootElement(name="threads")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ThreadResponse
    implements Serializable {
        public boolean threadContentionMonitoringEnabled;
        public boolean threadContentionMonitoringSupported;
        public boolean threadCpuTimeSupported;
        public boolean threadCpuTimeEnabled;
        @XmlElement(name="thread")
        private List<ThreadDetail> threads = Lists.newArrayList();

        public boolean isThreadContentionMonitoringEnabled() {
            return this.threadContentionMonitoringEnabled;
        }

        public boolean isThreadContentionMonitoringSupported() {
            return this.threadContentionMonitoringSupported;
        }

        public boolean isThreadCpuTimeSupported() {
            return this.threadCpuTimeSupported;
        }

        public boolean isThreadCpuTimeEnabled() {
            return this.threadCpuTimeEnabled;
        }

        public List<ThreadDetail> getThreads() {
            return this.threads;
        }
    }
}

