/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import java.util.Collection;
import java.util.Locale;
import org.geotools.metadata.iso.identification.IdentificationImpl;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.util.InternationalString;

public class DataIdentificationImpl
extends IdentificationImpl
implements DataIdentification {
    private static final long serialVersionUID = -4418520352804939785L;
    private Collection<SpatialRepresentationType> spatialRepresentationTypes;
    private Collection<Resolution> spatialResolutions;
    private Collection<Locale> language;
    private Collection<CharacterSet> characterSets;
    private Collection<TopicCategory> topicCategories;
    private InternationalString environmentDescription;
    private Collection<Extent> extent;
    private InternationalString supplementalInformation;

    public DataIdentificationImpl() {
    }

    public DataIdentificationImpl(DataIdentification source) {
        super(source);
    }

    public DataIdentificationImpl(Citation citation, InternationalString abstracts, Collection<? extends Locale> language, Collection<? extends TopicCategory> topicCategories) {
        super(citation, abstracts);
        this.setLanguage(language);
        this.setTopicCategories(topicCategories);
    }

    @Override
    public Collection<SpatialRepresentationType> getSpatialRepresentationTypes() {
        this.spatialRepresentationTypes = this.nonNullCollection(this.spatialRepresentationTypes, SpatialRepresentationType.class);
        return this.spatialRepresentationTypes;
    }

    public void setSpatialRepresentationTypes(Collection<? extends SpatialRepresentationType> newValues) {
        this.spatialRepresentationTypes = this.copyCollection(newValues, this.spatialRepresentationTypes, SpatialRepresentationType.class);
    }

    public Collection<Resolution> getSpatialResolutions() {
        this.spatialResolutions = this.nonNullCollection(this.spatialResolutions, Resolution.class);
        return this.spatialResolutions;
    }

    public void setSpatialResolutions(Collection<? extends Resolution> newValues) {
        this.spatialResolutions = this.copyCollection(newValues, this.spatialResolutions, Resolution.class);
    }

    @Override
    public Collection<Locale> getLanguage() {
        this.language = this.nonNullCollection(this.language, Locale.class);
        return this.language;
    }

    public void setLanguage(Collection<? extends Locale> newValues) {
        this.language = this.copyCollection(newValues, this.language, Locale.class);
    }

    @Override
    public Collection<CharacterSet> getCharacterSets() {
        this.characterSets = this.nonNullCollection(this.characterSets, CharacterSet.class);
        return this.characterSets;
    }

    public void setCharacterSets(Collection<? extends CharacterSet> newValues) {
        this.characterSets = this.copyCollection(newValues, this.characterSets, CharacterSet.class);
    }

    @Override
    public Collection<TopicCategory> getTopicCategories() {
        this.topicCategories = this.nonNullCollection(this.topicCategories, TopicCategory.class);
        return this.topicCategories;
    }

    public void setTopicCategories(Collection<? extends TopicCategory> newValues) {
        this.topicCategories = this.copyCollection(newValues, this.topicCategories, TopicCategory.class);
    }

    @Override
    public InternationalString getEnvironmentDescription() {
        return this.environmentDescription;
    }

    public void setEnvironmentDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.environmentDescription = newValue;
    }

    public Collection<Extent> getExtent() {
        this.extent = this.nonNullCollection(this.extent, Extent.class);
        return this.extent;
    }

    public void setExtent(Collection<? extends Extent> newValues) {
        this.extent = this.copyCollection(newValues, this.extent, Extent.class);
    }

    @Override
    public InternationalString getSupplementalInformation() {
        return this.supplementalInformation;
    }

    public void setSupplementalInformation(InternationalString newValue) {
        this.checkWritePermission();
        this.supplementalInformation = newValue;
    }
}

