/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Metrics;
import org.fusesource.hawtdispatch.internal.AbstractDispatchObject;
import org.fusesource.hawtdispatch.internal.ActiveMetricsCollector;
import org.fusesource.hawtdispatch.internal.GlobalDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.InactiveMetricsCollector;
import org.fusesource.hawtdispatch.internal.MetricsCollector;
import org.fusesource.hawtdispatch.internal.ThreadDispatchQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialDispatchQueue
extends AbstractDispatchObject
implements HawtDispatchQueue,
Runnable {
    protected volatile String label;
    protected final AtomicBoolean triggered = new AtomicBoolean();
    protected final ConcurrentLinkedQueue<Runnable> externalQueue = new ConcurrentLinkedQueue();
    private final LinkedList<Runnable> localQueue = new LinkedList();
    private final LinkedList<Runnable> sourceQueue = new LinkedList();
    private final ThreadLocal<Boolean> executing = new ThreadLocal();
    private MetricsCollector metricsCollector = InactiveMetricsCollector.INSTANCE;

    public SerialDispatchQueue(String label) {
        this.label = label;
    }

    @Override
    public void execute(Runnable runnable) {
        assert (runnable != null);
        this.enqueue(this.metricsCollector.track(runnable));
    }

    @Override
    public LinkedList<Runnable> getSourceQueue() {
        return this.sourceQueue;
    }

    private void enqueue(Runnable runnable) {
        if (this.executing.get() != null) {
            this.localQueue.add(runnable);
        } else {
            this.externalQueue.add(runnable);
            this.triggerExecution();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        original = HawtDispatcher.CURRENT_QUEUE.get();
        HawtDispatcher.CURRENT_QUEUE.set(this);
        this.executing.set(Boolean.TRUE);
        try {
            while ((runnable = this.externalQueue.poll()) != null) {
                this.localQueue.add(runnable);
            }
lbl9:
            // 3 sources

            while (true) {
                if (this.isSuspended()) {
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var5_9) {
            for (Runnable runnable : this.sourceQueue) {
                runnable.run();
            }
            this.sourceQueue.clear();
            this.executing.remove();
            HawtDispatcher.CURRENT_QUEUE.set(original);
            this.triggered.set(false);
            v0 = empty = this.externalQueue.isEmpty() != false && this.localQueue.isEmpty() != false;
            if (!this.isSuspended() && !empty) {
                this.triggerExecution();
            }
            throw var5_9;
        }
        for (Runnable runnable : this.sourceQueue) {
            runnable.run();
        }
        this.sourceQueue.clear();
        this.executing.remove();
        HawtDispatcher.CURRENT_QUEUE.set(original);
        this.triggered.set(false);
        v1 = empty = this.externalQueue.isEmpty() != false && this.localQueue.isEmpty() != false;
        if (!this.isSuspended() && !empty) {
            this.triggerExecution();
        }
        return;
lbl-1000:
        // 1 sources

        {
            runnable = this.localQueue.poll();
            if (runnable != null) ** GOTO lbl-1000
        }
        for (Runnable runnable : this.sourceQueue) {
            runnable.run();
        }
        this.sourceQueue.clear();
        this.executing.remove();
        HawtDispatcher.CURRENT_QUEUE.set(original);
        this.triggered.set(false);
        v2 = empty = this.externalQueue.isEmpty() != false && this.localQueue.isEmpty() != false;
        if (!this.isSuspended() && !empty) {
            this.triggerExecution();
        }
        return;
lbl-1000:
        // 1 sources

        {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                thread = Thread.currentThread();
                thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                ** continue;
            }
        }
    }

    protected void triggerExecution() {
        if (this.triggered.compareAndSet(false, true)) {
            this.getTargetQueue().execute(this);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isExecuting() {
        return this.executing.get() != null;
    }

    @Override
    public void assertExecuting() {
        assert (this.isExecuting()) : this.getDispatcher().assertMessage();
    }

    @Override
    protected void onStartup() {
        this.triggerExecution();
    }

    @Override
    protected void onResume() {
        this.triggerExecution();
    }

    @Override
    public DispatchQueue.QueueType getQueueType() {
        return DispatchQueue.QueueType.SERIAL_QUEUE;
    }

    @Override
    public void executeAfter(long delay, TimeUnit unit, Runnable runnable) {
        this.getDispatcher().timerThread.addRelative(runnable, this, delay, unit);
    }

    @Override
    public DispatchQueue createQueue(String label) {
        SerialDispatchQueue rc = this.getDispatcher().createQueue(label);
        rc.setTargetQueue(this);
        return rc;
    }

    @Override
    public HawtDispatcher getDispatcher() {
        HawtDispatchQueue target = this.getTargetQueue();
        if (target == null) {
            throw new UnsupportedOperationException();
        }
        return target.getDispatcher();
    }

    @Override
    public SerialDispatchQueue isSerialDispatchQueue() {
        return this;
    }

    @Override
    public ThreadDispatchQueue isThreadDispatchQueue() {
        return null;
    }

    @Override
    public GlobalDispatchQueue isGlobalDispatchQueue() {
        return null;
    }

    @Override
    public void profile(boolean on) {
        if (!on && this.metricsCollector == InactiveMetricsCollector.INSTANCE) {
            return;
        }
        if (on) {
            this.metricsCollector = new ActiveMetricsCollector(this);
            this.getDispatcher().track(this);
        } else {
            this.metricsCollector = InactiveMetricsCollector.INSTANCE;
        }
    }

    @Override
    public Metrics metrics() {
        return this.metricsCollector.metrics();
    }

    private int drains() {
        return this.getDispatcher().drains;
    }

    public String toString() {
        if (this.label == null) {
            return "serial queue";
        }
        return "serial queue { label: \"" + this.label + "\" }";
    }
}

