/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.concurrent;

public abstract class SynchronousTarget {
    private Runnable completedCallback;
    private boolean done = false;
    private final String name;

    public SynchronousTarget(Runnable completedCallback, String name) {
        this.name = name;
        this.completedCallback = completedCallback;
    }

    public abstract void setTarget(int var1);

    public Runnable registerCompletedCallback(Runnable completedCallback) {
        if (!this.isVirgin()) {
            throw new RuntimeException("Cannot add a sub barrier if it has already been used");
        }
        Runnable previous = this.completedCallback;
        this.completedCallback = completedCallback;
        return previous;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    protected synchronized void call() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.completedCallback != null) {
            this.completedCallback.run();
        }
    }

    protected abstract boolean isVirgin();

    public String getName() {
        return this.name;
    }
}

