/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.renderers.BitmapTileRenderer;
import org.mapfish.print.map.renderers.PDFTileRenderer;
import org.mapfish.print.map.renderers.SVGTileRenderer;

public abstract class TileRenderer {
    private static final Map<Format, TileRenderer> renderers = new HashMap<Format, TileRenderer>();

    public static TileRenderer get(Format format) {
        return renderers.get((Object)format);
    }

    public abstract void render(Transformer var1, List<URI> var2, ParallelMapTileLoader var3, RenderingContext var4, float var5, int var6, double var7, double var9, long var11, long var13) throws IOException;

    static {
        renderers.put(Format.BITMAP, new BitmapTileRenderer());
        renderers.put(Format.PDF, new PDFTileRenderer());
        renderers.put(Format.SVG, new SVGTileRenderer());
    }

    public static enum Format {
        BITMAP,
        PDF,
        SVG;

    }
}

