/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain.vpn;

import org.jclouds.azurecompute.arm.domain.AddressSpace;
import org.jclouds.azurecompute.arm.domain.vpn.BGPSettings;
import org.jclouds.azurecompute.arm.domain.vpn.LocalNetworkGatewayProperties;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_LocalNetworkGatewayProperties
extends LocalNetworkGatewayProperties {
    private final BGPSettings bgpSettings;
    private final String gatewayIpAddress;
    private final AddressSpace localNetworkAddressSpace;
    private final String provisioningState;
    private final String resourceGuid;

    private AutoValue_LocalNetworkGatewayProperties(@Nullable BGPSettings bgpSettings, String gatewayIpAddress, @Nullable AddressSpace localNetworkAddressSpace, @Nullable String provisioningState, @Nullable String resourceGuid) {
        this.bgpSettings = bgpSettings;
        this.gatewayIpAddress = gatewayIpAddress;
        this.localNetworkAddressSpace = localNetworkAddressSpace;
        this.provisioningState = provisioningState;
        this.resourceGuid = resourceGuid;
    }

    @Override
    @Nullable
    public BGPSettings bgpSettings() {
        return this.bgpSettings;
    }

    @Override
    public String gatewayIpAddress() {
        return this.gatewayIpAddress;
    }

    @Override
    @Nullable
    public AddressSpace localNetworkAddressSpace() {
        return this.localNetworkAddressSpace;
    }

    @Override
    @Nullable
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    @Nullable
    public String resourceGuid() {
        return this.resourceGuid;
    }

    public String toString() {
        return "LocalNetworkGatewayProperties{bgpSettings=" + this.bgpSettings + ", " + "gatewayIpAddress=" + this.gatewayIpAddress + ", " + "localNetworkAddressSpace=" + this.localNetworkAddressSpace + ", " + "provisioningState=" + this.provisioningState + ", " + "resourceGuid=" + this.resourceGuid + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LocalNetworkGatewayProperties) {
            LocalNetworkGatewayProperties that = (LocalNetworkGatewayProperties)o;
            return (this.bgpSettings == null ? that.bgpSettings() == null : this.bgpSettings.equals(that.bgpSettings())) && this.gatewayIpAddress.equals(that.gatewayIpAddress()) && (this.localNetworkAddressSpace == null ? that.localNetworkAddressSpace() == null : this.localNetworkAddressSpace.equals(that.localNetworkAddressSpace())) && (this.provisioningState == null ? that.provisioningState() == null : this.provisioningState.equals(that.provisioningState())) && (this.resourceGuid == null ? that.resourceGuid() == null : this.resourceGuid.equals(that.resourceGuid()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.bgpSettings == null ? 0 : this.bgpSettings.hashCode();
        h *= 1000003;
        h ^= this.gatewayIpAddress.hashCode();
        h *= 1000003;
        h ^= this.localNetworkAddressSpace == null ? 0 : this.localNetworkAddressSpace.hashCode();
        h *= 1000003;
        h ^= this.provisioningState == null ? 0 : this.provisioningState.hashCode();
        h *= 1000003;
        return h ^= this.resourceGuid == null ? 0 : this.resourceGuid.hashCode();
    }

    @Override
    public LocalNetworkGatewayProperties.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends LocalNetworkGatewayProperties.Builder {
        private BGPSettings bgpSettings;
        private String gatewayIpAddress;
        private AddressSpace localNetworkAddressSpace;
        private String provisioningState;
        private String resourceGuid;

        Builder() {
        }

        private Builder(LocalNetworkGatewayProperties source) {
            this.bgpSettings = source.bgpSettings();
            this.gatewayIpAddress = source.gatewayIpAddress();
            this.localNetworkAddressSpace = source.localNetworkAddressSpace();
            this.provisioningState = source.provisioningState();
            this.resourceGuid = source.resourceGuid();
        }

        @Override
        public LocalNetworkGatewayProperties.Builder bgpSettings(@Nullable BGPSettings bgpSettings) {
            this.bgpSettings = bgpSettings;
            return this;
        }

        @Override
        public LocalNetworkGatewayProperties.Builder gatewayIpAddress(String gatewayIpAddress) {
            if (gatewayIpAddress == null) {
                throw new NullPointerException("Null gatewayIpAddress");
            }
            this.gatewayIpAddress = gatewayIpAddress;
            return this;
        }

        @Override
        public LocalNetworkGatewayProperties.Builder localNetworkAddressSpace(@Nullable AddressSpace localNetworkAddressSpace) {
            this.localNetworkAddressSpace = localNetworkAddressSpace;
            return this;
        }

        @Override
        public LocalNetworkGatewayProperties.Builder provisioningState(@Nullable String provisioningState) {
            this.provisioningState = provisioningState;
            return this;
        }

        @Override
        public LocalNetworkGatewayProperties.Builder resourceGuid(@Nullable String resourceGuid) {
            this.resourceGuid = resourceGuid;
            return this;
        }

        @Override
        public LocalNetworkGatewayProperties build() {
            String missing = "";
            if (this.gatewayIpAddress == null) {
                missing = missing + " gatewayIpAddress";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_LocalNetworkGatewayProperties(this.bgpSettings, this.gatewayIpAddress, this.localNetworkAddressSpace, this.provisioningState, this.resourceGuid);
        }
    }
}

