/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.reports;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.context.ServiceContext;
import org.apache.commons.csv.CSVPrinter;
import org.fao.geonet.api.reports.IReport;
import org.fao.geonet.api.reports.ReportFilter;
import org.fao.geonet.api.reports.ReportUtils;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.User_;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.repository.specification.UserSpecs;
import org.springframework.data.domain.Sort;

public class ReportUsers
implements IReport {
    private final ReportFilter reportFilter;

    public ReportUsers(ReportFilter filter) {
        this.reportFilter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(ServiceContext context, PrintWriter writer) throws Exception {
        CSVPrinter csvFilePrinter = null;
        try {
            csvFilePrinter = new CSVPrinter((Appendable)writer, ReportUtils.CSV_FORMAT);
            UserRepository userRepository = (UserRepository)context.getBean(UserRepository.class);
            Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{User_.lastLoginDate})});
            List records = userRepository.findAll(UserSpecs.loginDateBetweenAndByGroups((ISODate)this.reportFilter.getBeginDate(), (ISODate)this.reportFilter.getEndDate(), this.reportFilter.getGroups()), sort);
            csvFilePrinter.printRecord(new Object[]{"Users"});
            csvFilePrinter.println();
            String[] entries = "Username#Surname#Name#Email#User groups#Last login date".split("#");
            csvFilePrinter.printRecord(Arrays.asList(entries));
            UserGroupRepository userGroupRepository = (UserGroupRepository)context.getBean(UserGroupRepository.class);
            for (User user : records) {
                String username = user.getUsername();
                String name = Optional.ofNullable(user.getName()).orElse("");
                String surname = Optional.ofNullable(user.getSurname()).orElse("");
                String email = Optional.ofNullable(user.getEmail()).orElse("");
                String lastLoginDate = user.getLastLoginDate();
                StringBuilder userGroupsList = new StringBuilder();
                List userGroups = userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)user.getId()));
                int i = 0;
                for (UserGroup ug : userGroups) {
                    Group g = ug.getGroup();
                    String groupName = (String)g.getLabelTranslations().get(context.getLanguage());
                    if (groupName == null) {
                        groupName = g.getName();
                    }
                    String groupProfile = ug.getId().getProfile().name();
                    if (i++ > 0) {
                        userGroupsList.append("-");
                    }
                    userGroupsList.append(groupName + "/" + groupProfile);
                }
                ArrayList<String> record = new ArrayList<String>();
                record.add(username);
                record.add(surname);
                record.add(name);
                record.add(email);
                record.add(userGroupsList.toString());
                record.add(lastLoginDate);
                csvFilePrinter.printRecord(record);
            }
        }
        finally {
            writer.flush();
            if (csvFilePrinter != null) {
                csvFilePrinter.flush();
            }
        }
    }
}

