/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.registries.vocabularies;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import net.sf.json.JSONObject;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.ThesaurusType;
import org.fao.geonet.kernel.rdf.Selectors;
import org.fao.geonet.kernel.search.KeywordsSearcher;
import org.fao.geonet.kernel.search.keyword.KeywordSearchParamsBuilder;
import org.fao.geonet.kernel.search.keyword.KeywordSearchType;
import org.fao.geonet.kernel.search.keyword.KeywordSort;
import org.fao.geonet.kernel.search.keyword.SortDirection;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.ThesaurusActivationRepository;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/registries/vocabularies"})
@Tag(name="registries", description="Registries related operations")
public class KeywordsApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    SettingManager settingManager;
    @Autowired
    ThesaurusManager thesaurusMan;
    @Autowired
    IsoLanguagesMapper languagesMapper;
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    @Autowired
    ThesaurusActivationRepository thesaurusActivationRepository;
    @Autowired
    GeonetHttpRequestFactory httpRequestFactory;
    @Autowired
    IsoLanguagesMapper mapper;
    @Autowired
    ThesaurusManager thesaurusManager;

    @Operation(summary="Search keywords", description="")
    @RequestMapping(path={"/search"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Object searchKeywords(@Parameter(description="Query", required=false) @RequestParam(required=false) String q, @Parameter(description="Query in that language", required=false) @RequestParam(value="lang", defaultValue="eng") String lang, @Parameter(description="Number of rows", required=false) @RequestParam(required=false, defaultValue="1000") int rows, @Parameter(description="Start from", required=false) @RequestParam(defaultValue="0", required=false) int start, @Parameter(description="Return keyword information in one or more languages", required=false) @RequestParam(value="pLang", required=false) List<String> targetLangs, @Parameter(description="Thesaurus identifier", required=false) @RequestParam(required=false) String[] thesaurus, @Parameter(description="Type of search", required=false) @RequestParam(defaultValue="CONTAINS") KeywordSearchType type, @Parameter(description="URI query", required=false) @RequestParam(required=false) String uri, @Parameter(description="Sort by", required=false) @RequestParam(required=false, defaultValue="DESC") String sort, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        UserSession session = ApiUtils.getUserSession(httpSession);
        if (Log.isDebugEnabled((String)"KeywordsManager")) {
            Log.debug((String)"KeywordsManager", (Object)"Creating new keywords searcher");
        }
        KeywordsSearcher searcher = new KeywordsSearcher(context, (ThesaurusFinder)this.thesaurusMan);
        String thesauriDomainName = null;
        List<String> thesauri = null;
        if (thesaurus != null) {
            thesauri = Arrays.asList(thesaurus);
        }
        KeywordSearchParamsBuilder builder = this.parseBuilder(lang, q, rows, start, targetLangs, thesauri, thesauriDomainName, type, uri, this.languagesMapper);
        if (q == null || q.trim().isEmpty()) {
            builder.setComparator(KeywordSort.defaultLabelSorter((SortDirection)SortDirection.parse((String)sort)));
        } else {
            builder.setComparator(KeywordSort.searchResultsSorter((String)q, (SortDirection)SortDirection.parse((String)sort)));
        }
        searcher.search(builder.build());
        session.setProperty("search.keywords.result", (Object)searcher);
        List keywords = searcher.getResults();
        if ("xml".equals(request.getParameter("_content_type"))) {
            Element root = new Element("response");
            for (KeywordBean kw : keywords) {
                root.addContent((Content)kw.toElement("eng", new String[0]));
            }
            return root;
        }
        return keywords;
    }

    @Operation(summary="Get keyword by id", description="Retrieve XML representation of keyword(s) from same thesaurususing different transformations. 'to-iso19139-keyword' is the default and return an ISO19139 snippet.'to-iso19139-keyword-as-xlink' return an XLinked element. Custom transformation can be create on a per schema basis.")
    @RequestMapping(path={"/keyword"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/xml", "application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="XML snippet with requested keywords.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Object getKeywordById(@Parameter(description="Keyword identifier or list of keyword identifiers comma separated.", required=true) @RequestParam(name="id") String uri, @Parameter(description="Thesaurus to look info for the keyword(s).", required=true) @RequestParam(name="thesaurus") String sThesaurusName, @Parameter(description="Languages.", required=false) @RequestParam(name="lang", required=false) String[] langs, @Parameter(description="Only print the keyword, no thesaurus information.", required=false) @RequestParam(required=false, defaultValue="false") boolean keywordOnly, @Parameter(description="XSL template to use (ISO19139 keyword by default, see convert.xsl).", required=false) @RequestParam(required=false) String transformation, @Parameter(description="langMap, that converts the values in the 'lang' parameter to how they will be actually represented in the record. {'fre':'fra'} or {'fre':'fr'}.  Missing/empty means to convert to iso 2 letter.", required=false) @RequestParam(name="langMap", required=false) String langMapJson, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, @RequestHeader(value="Accept", defaultValue="application/xml") String accept, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        Element descKeys;
        String SEPARATOR = ",";
        ServiceContext context = ApiUtils.createServiceContext(request);
        boolean isJson = "application/json".equals(accept);
        Thesaurus thesaurus = this.thesaurusManager.getThesaurusByName(sThesaurusName);
        if (thesaurus == null) {
            String finalSThesaurusName = sThesaurusName;
            Optional<Thesaurus> thesaurusEntry = this.thesaurusManager.getThesauriMap().values().stream().filter(t -> t.getKey().endsWith(finalSThesaurusName)).findFirst();
            if (!thesaurusEntry.isPresent()) {
                throw new IllegalArgumentException(String.format("Thesaurus '%s' not found.", sThesaurusName));
            }
            thesaurus = thesaurusEntry.get();
            sThesaurusName = thesaurusEntry.get().getKey();
        }
        if (langs == null) {
            langs = context.getLanguage().split(",");
        }
        CharSequence[] iso3langCodes = Arrays.copyOf(langs, langs.length);
        for (int i = 0; i < langs.length; ++i) {
            if (!StringUtils.isNotEmpty((String)langs[i])) continue;
            langs[i] = this.mapper.iso639_2_to_iso639_1(langs[i], langs[i].substring(0, 2));
        }
        HashMap<String, String> jsonResponse = new HashMap<String, String>();
        if ((uri = URLDecoder.decode(uri, "UTF-8")) == null) {
            descKeys = new Element("descKeys");
        } else {
            KeywordsSearcher searcher = new KeywordsSearcher(context, (ThesaurusFinder)this.thesaurusManager);
            String[] url = !uri.contains(",") ? new String[]{uri} : uri.split(",");
            ArrayList<KeywordBean> kbList = new ArrayList<KeywordBean>();
            for (String currentUri : url) {
                KeywordBean kb = searcher.searchById(currentUri, sThesaurusName, (String[])iso3langCodes);
                if (kb == null) {
                    kb = searcher.searchById(currentUri, sThesaurusName, langs);
                }
                if (kb == null) {
                    kb = searcher.searchById(ApiUtils.fixURIFragment(currentUri), sThesaurusName, (String[])iso3langCodes);
                }
                if (kb == null) {
                    kb = searcher.searchById(ApiUtils.fixURIFragment(currentUri), sThesaurusName, langs);
                }
                if (kb == null) continue;
                kbList.add(kb);
            }
            descKeys = new Element("descKeys");
            for (KeywordBean keywordBean : kbList) {
                if (isJson) {
                    jsonResponse.put(keywordBean.getUriCode(), keywordBean.getDefaultValue());
                    continue;
                }
                KeywordsSearcher.toRawElement((Element)descKeys, (KeywordBean)keywordBean);
            }
        }
        Element langConversion = null;
        if (langMapJson != null && !langMapJson.isEmpty()) {
            JSONObject obj = JSONObject.fromObject((Object)langMapJson);
            langConversion = new Element("languageConversions");
            for (Object entry : obj.entrySet()) {
                String key = ((Map.Entry)entry).getKey().toString();
                String value = ((Map.Entry)entry).getValue().toString();
                Element conv = new Element("conversion");
                conv.setAttribute("from", key.toString());
                conv.setAttribute("to", value.toString().replace("#", ""));
                langConversion.addContent((Content)conv);
            }
        }
        if (isJson) {
            return jsonResponse;
        }
        Path convertXsl = this.dataDirectory.getWebappDir().resolve("xslt/services/thesaurus/convert.xsl");
        Element gui = new Element("gui");
        Element nodeUrl = new Element("nodeUrl").setText(this.settingManager.getNodeURL());
        Element nodeId = new Element("nodeId").setText(context.getNodeId());
        Element thesaurusEl = new Element("thesaurus");
        Element root = new Element("root");
        gui.addContent((Content)thesaurusEl);
        thesaurusEl.addContent((Content)this.thesaurusManager.buildResultfromThTable(context));
        Element requestParams = new Element("request");
        for (Map.Entry<String, String> e : allRequestParams.entrySet()) {
            if (e.getKey().equals("lang")) {
                requestParams.addContent((Content)new Element(e.getKey()).setText(String.join((CharSequence)",", iso3langCodes)));
                continue;
            }
            requestParams.addContent((Content)new Element(e.getKey()).setText(e.getValue()));
        }
        if (langConversion != null) {
            requestParams.addContent((Content)langConversion);
        }
        root.addContent((Content)requestParams);
        root.addContent((Content)descKeys);
        root.addContent((Content)gui);
        root.addContent((Content)nodeUrl);
        root.addContent((Content)nodeId);
        Element transform = Xml.transform((Element)root, (Path)convertXsl);
        return transform;
    }

    @Operation(summary="Download a thesaurus by name", description="Download the thesaurus in SKOS format.")
    @RequestMapping(value={"/{thesaurus:.+}"}, method={RequestMethod.GET}, produces={"text/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Thesaurus in SKOS format."), @ApiResponse(responseCode="404", description="Resource not found.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void getThesaurus(@Parameter(description="Thesaurus to download.", required=true) @PathVariable(value="thesaurus") String thesaurus, HttpServletResponse response) throws Exception {
        Thesaurus directory = this.thesaurusMan.getThesaurusByName(thesaurus);
        if (directory == null) {
            throw new IllegalArgumentException("Thesaurus not found --> " + thesaurus);
        }
        Path directoryFile = directory.getFile();
        if (!Files.exists(directoryFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Thesaurus file not found --> " + thesaurus);
        }
        response.setContentType("text/xml");
        response.setHeader("Content-Disposition", "attachment;filename=" + directoryFile.getFileName());
        ServletOutputStream out = response.getOutputStream();
        BufferedReader reader1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(directoryFile.toFile()), StandardCharsets.UTF_8));
        IOUtils.copy((Reader)reader1, (OutputStream)out);
        out.flush();
        out.close();
    }

    @Operation(summary="Delete a thesaurus by name", description="Delete a thesaurus.")
    @RequestMapping(value={"/{thesaurus:.+}"}, method={RequestMethod.DELETE})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Thesaurus deleted."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it."), @ApiResponse(responseCode="404", description="Resource not found.")})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteThesaurus(@Parameter(description="Thesaurus to delete.", required=true) @PathVariable(value="thesaurus") String thesaurus) throws Exception {
        Thesaurus thesaurusObject = this.thesaurusMan.getThesaurusByName(thesaurus);
        if (thesaurusObject == null) {
            throw new ResourceNotFoundException(String.format("Thesaurus with identifier '%s' not found in the catalogue. Should be one of: %s", thesaurus, this.thesaurusMan.getThesauriMap().keySet().toString()));
        }
        Path item = thesaurusObject.getFile();
        this.thesaurusMan.remove(thesaurus);
        if (Files.exists(item, new LinkOption[0])) {
            IO.deleteFile((Path)item, (boolean)true, (String)"geonetwork.thesaurus");
            String thesaurusId = thesaurusObject.getFname();
            if (this.thesaurusActivationRepository.existsById((Object)thesaurusId)) {
                this.thesaurusActivationRepository.deleteById((Object)thesaurusId);
            }
        } else {
            throw new IllegalArgumentException(String.format("Thesaurus RDF file was not found for thesaurus with identifier '%s'.", thesaurus));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Uploads a new thesaurus from a file", description="Uploads a new thesaurus.")
    @RequestMapping(method={RequestMethod.POST}, produces={"text/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Thesaurus uploaded in SKOS format."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it.")})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public String uploadThesaurus(@Parameter(description="If set, do a file upload.") @RequestParam(value="file", required=false) MultipartFile file, @Parameter(description="Local or external (default).") @RequestParam(value="type", defaultValue="external") ThesaurusType type, @Parameter(description="Type of thesaurus, usually one of the ISO thesaurus type codelist value. Default is theme.") @RequestParam(value="dir", defaultValue="theme") String dir, @Parameter(description="XSL to be use to convert the thesaurus before load. Default _none_.") @RequestParam(value="stylesheet", defaultValue="_none_") String stylesheet, HttpServletRequest request) throws Exception {
        long start = System.currentTimeMillis();
        ServiceContext context = ApiUtils.createServiceContext(request);
        boolean fileUpload = file != null && !file.isEmpty();
        Path rdfFile = null;
        String fname = null;
        File tempDir = null;
        if (!fileUpload) {
            Log.debug((String)"geonetwork.thesaurus", (Object)"No file provided for thesaurus upload.");
            throw new MissingServletRequestParameterException("Thesaurus source not provided", "file");
        }
        Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus file: " + file.getOriginalFilename()));
        tempDir = Files.createTempDirectory("thesaurus", new FileAttribute[0]).toFile();
        Path tempFilePath = tempDir.toPath().resolve(file.getOriginalFilename());
        File convFile = tempFilePath.toFile();
        file.transferTo(convFile);
        rdfFile = convFile.toPath();
        fname = file.getOriginalFilename();
        try {
            if (StringUtils.isEmpty((String)fname)) {
                throw new Exception("File upload from URL or file return null");
            }
            if (rdfFile == null || !Files.exists(rdfFile, new LinkOption[0])) {
                throw new MissingServletRequestParameterException("Thesaurus file doesn't exist", "file");
            }
            long fsize = Files.size(rdfFile);
            if (fsize == 0L) {
                throw new MissingServletRequestParameterException("Thesaurus file has zero size", "file");
            }
            String extension = FilenameUtils.getExtension((String)fname);
            if (!extension.equalsIgnoreCase("rdf") && !extension.equalsIgnoreCase("xml")) {
                Log.debug((String)"geonetwork.thesaurus", (Object)("Incorrect extension for thesaurus named: " + fname));
                throw new Exception("Incorrect extension for thesaurus named: " + fname);
            }
            Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus: " + fname));
            fname = fname.replace(extension, "rdf");
            this.uploadThesaurus(rdfFile, stylesheet, context, fname, type.toString(), dir);
            long end = System.currentTimeMillis();
            long duration = (end - start) / 1000L;
            String string = String.format("Thesaurus '%s' loaded in %d sec.", fname, duration);
            return string;
        }
        finally {
            if (tempDir != null) {
                FileUtils.deleteQuietly((File)tempDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Uploads a CSV file and convert it to SKOS format", description="CSV file MUST contains columns at least for concept id and label. For multilingual thesaurus, consider using columns like label, label_fre, label_ita with languages parameter set to [en, fr, it]. Default language value is used if translations are empty. The thesaurus filename will be the filename of the CSV file (with .rdf extension). It is recommended to set the thesaurus title and namespace URL even if default values will be used based on the filename. Thesaurus dates are set to the date of import.")
    @RequestMapping(value={"/import/csv"}, method={RequestMethod.POST}, produces={"application/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Thesaurus converted and imported in SKOS format."), @ApiResponse(responseCode="200", description="Thesaurus converted and returned in response in SKOS format."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it.")})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseBody
    public void importCsvAsThesaurus(@Parameter(description="If set, do a file upload.") @RequestParam(value="file", required=false) MultipartFile file, @Parameter(description="Local or external (default).") @RequestParam(value="type", defaultValue="external") ThesaurusType type, @Parameter(description="Type of thesaurus, usually one of the ISO thesaurus type codelist value. Default is theme.") @RequestParam(value="dir", defaultValue="theme") String dir, @Parameter(description="Encoding. Default is UTF-8.") @RequestParam(value="encoding", defaultValue="UTF-8") String encoding, @Parameter(description="Thesaurus namespace. Default is filename.") @RequestParam(value="thesaurusNs", defaultValue="") String thesaurusNs, @Parameter(description="Thesaurus languages") @RequestParam(value="languages", defaultValue="en") String[] languages, @Parameter(description="Thesaurus title. Default is filename.") @RequestParam(value="thesaurusTitle", defaultValue="") String thesaurusTitle, @Parameter(description="Column name for concept id. Default is id.") @RequestParam(value="conceptIdColumn", defaultValue="id") String conceptIdColumn, @Parameter(description="Column name for concept label. Default is label.") @RequestParam(value="conceptLabelColumn", defaultValue="label") String conceptLabelColumn, @Parameter(description="Column name for concept description. Default is description.") @RequestParam(value="conceptDescriptionColumn", defaultValue="") String conceptDescriptionColumn, @Parameter(description="Column name for broader concept id. Default is broader.") @RequestParam(value="conceptBroaderIdColumn", defaultValue="broader") String conceptBroaderIdColumn, @Parameter(description="Column name for narrower concept id. Default is narrower.") @RequestParam(value="conceptNarrowerIdColumn", defaultValue="narrower") String conceptNarrowerIdColumn, @Parameter(description="Column name for related concept id. Default is related.") @RequestParam(value="conceptRelatedIdColumn", defaultValue="related") String conceptRelatedIdColumn, @Parameter(description="Separator used when multiple broader/narrower/related ids are in the same column. Default is '|'.") @RequestParam(value="conceptLinkSeparator", defaultValue="\\|") String conceptLinkSeparator, @Parameter(description="Import CSV file as thesaurus if true (detault) or return it in  SKOS format.") @RequestParam(value="importAsThesaurus", defaultValue="true") boolean importAsThesaurus, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        String fname = file.getOriginalFilename();
        Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading CSV file: " + fname));
        File tempDir = Files.createTempDirectory("thesaurus", new FileAttribute[0]).toFile();
        Path tempFilePath = tempDir.toPath().resolve(file.getOriginalFilename());
        File convFile = tempFilePath.toFile();
        file.transferTo(convFile);
        Path csvFile = convFile.toPath();
        try {
            if (StringUtils.isEmpty((String)fname)) {
                throw new Exception("File missing.");
            }
            if (csvFile == null || !Files.exists(csvFile, new LinkOption[0])) {
                throw new MissingServletRequestParameterException("CSV file doesn't exist", "file");
            }
            long fsize = Files.size(csvFile);
            if (fsize == 0L) {
                throw new MissingServletRequestParameterException("CSV file has zero size", "file");
            }
            String extension = FilenameUtils.getExtension((String)fname);
            Element element = this.convertCsvToSkos(csvFile, languages, encoding, thesaurusNs, thesaurusTitle, conceptIdColumn, conceptLabelColumn, conceptDescriptionColumn, conceptBroaderIdColumn, conceptNarrowerIdColumn, conceptRelatedIdColumn, conceptLinkSeparator);
            fname = fname.replace(extension, "rdf");
            if (importAsThesaurus) {
                Path rdfFile = tempDir.toPath().resolve(fname);
                XMLOutputter xmlOutput = new XMLOutputter();
                xmlOutput.setFormat(Format.getCompactFormat());
                xmlOutput.output(element, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(rdfFile.toFile().getCanonicalPath()), StandardCharsets.UTF_8));
                this.uploadThesaurus(rdfFile, "_none_", context, fname, type.toString(), dir);
                response.setStatus(201);
            } else {
                response.addHeader("Content-Disposition", "inline; filename=\"" + fname + "\"");
                response.setStatus(200);
                response.setCharacterEncoding(Constants.ENCODING);
                response.setContentType("application/xml");
                response.getOutputStream().write(Xml.getString((Element)element).getBytes());
            }
        }
        finally {
            if (tempDir != null) {
                FileUtils.deleteQuietly((File)tempDir);
            }
        }
    }

    public Element convertCsvToSkos(Path csvFile, String[] languages, String encoding, String thesaurusNs, String thesaurusTitle, String conceptIdColumn, String conceptLabelColumn, String conceptDescriptionColumn, String conceptBroaderIdColumn, String conceptNarrowerIdColumn, String conceptRelatedIdColumn, String conceptLinkSeparator) throws IOException {
        Log.debug((String)"geonetwork.thesaurus", (Object)("Convert CSV file SKOS" + csvFile.getFileName()));
        String thesaurusNamespaceUrl = StringUtils.isEmpty((String)thesaurusNs) ? csvFile.getFileName().toString() + "#" : thesaurusNs;
        Element thesaurus = new Element("RDF", Selectors.RDF_NAMESPACE);
        try (BufferedReader reader = Files.newBufferedReader(csvFile, Charset.forName(encoding));
             CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.withFirstRecordAsHeader().withIgnoreHeaderCase().withTrim());){
            LinkedHashMap<String, KeywordBean> allConcepts = new LinkedHashMap<String, KeywordBean>();
            HashMap<String, List<String>> broaderLinks = new HashMap<String, List<String>>();
            HashMap<String, List<String>> narrowerLinks = new HashMap<String, List<String>>();
            HashMap<String, List<String>> relatedLinks = new HashMap<String, List<String>>();
            ArrayList<String> topConcepts = new ArrayList<String>();
            for (CSVRecord csvRecord : csvParser) {
                try {
                    KeywordBean keyword2 = new KeywordBean(this.languagesMapper);
                    keyword2.setNamespaceCode(thesaurusNamespaceUrl);
                    keyword2.setKeywordUrl(thesaurusNamespaceUrl);
                    keyword2.setUriCode(csvRecord.get(conceptIdColumn));
                    Arrays.stream(languages).forEach(l -> {
                        String column = conceptLabelColumn + "_" + l;
                        Integer position = (Integer)csvParser.getHeaderMap().get(column);
                        if (position != null) {
                            keyword2.setValue(csvRecord.get(column), l);
                        } else {
                            keyword2.setValue(csvRecord.get(conceptLabelColumn), l);
                        }
                        if (StringUtils.isNotEmpty((String)conceptDescriptionColumn)) {
                            String desccolumn = conceptDescriptionColumn + "_" + l;
                            Integer descColumnPosition = (Integer)csvParser.getHeaderMap().get(desccolumn);
                            if (descColumnPosition != null) {
                                keyword2.setDefinition(csvRecord.get(desccolumn), l);
                            } else if (csvParser.getHeaderMap().get(conceptDescriptionColumn) != null) {
                                keyword2.setDefinition(csvRecord.get(conceptDescriptionColumn), l);
                            }
                        }
                    });
                    String key = keyword2.getKeywordUrl() + keyword2.getUriCode();
                    this.extractRelated(key, thesaurusNamespaceUrl, csvParser, csvRecord, conceptLinkSeparator, conceptBroaderIdColumn, broaderLinks);
                    if (broaderLinks.get(key) == null || ((List)broaderLinks.get(key)).size() == 0) {
                        topConcepts.add(key);
                    }
                    this.extractRelated(key, thesaurusNamespaceUrl, csvParser, csvRecord, conceptLinkSeparator, conceptNarrowerIdColumn, narrowerLinks);
                    this.extractRelated(key, thesaurusNamespaceUrl, csvParser, csvRecord, conceptLinkSeparator, conceptRelatedIdColumn, relatedLinks);
                    allConcepts.put(key, keyword2);
                }
                catch (Exception ex) {
                    Log.error((String)"geonetwork.thesaurus", (Object)String.format("Error reading CSV line '%s'. Error is %s", csvRecord.toString(), ex.getMessage()));
                }
            }
            Element scheme = this.buildConceptScheme(csvFile, thesaurusTitle, thesaurusNamespaceUrl);
            if (broaderLinks.size() > 0 && topConcepts.size() > 0) {
                topConcepts.forEach(t -> {
                    Element topConcept = new Element("hasTopConcept", Selectors.SKOS_NAMESPACE);
                    topConcept.setAttribute("resource", t, Selectors.RDF_NAMESPACE);
                    scheme.addContent((Content)topConcept);
                });
            }
            thesaurus.addContent((Content)scheme);
            allConcepts.forEach((uri, keyword) -> {
                Element keywordSkos = keyword.getSkos();
                this.addRelated((String)uri, keywordSkos, "broader", (Map<String, List<String>>)broaderLinks);
                this.addRelated((String)uri, keywordSkos, "narrower", (Map<String, List<String>>)narrowerLinks);
                this.addRelated((String)uri, keywordSkos, "related", (Map<String, List<String>>)relatedLinks);
                thesaurus.addContent((Content)keywordSkos);
            });
        }
        return thesaurus;
    }

    private void extractRelated(String key, String thesaurusNamespaceUrl, CSVParser csvParser, CSVRecord csvRecord, String conceptLinkSeparator, String column, Map<String, List<String>> list) {
        if (csvParser.getHeaderMap().get(column) != null) {
            list.put(key, Arrays.stream(csvRecord.get(column).split(conceptLinkSeparator)).filter(StringUtils::isNotEmpty).map(c -> thesaurusNamespaceUrl + c).collect(Collectors.toList()));
        }
    }

    private void addRelated(String uri, Element keywordSkos, String type, Map<String, List<String>> broaderLinks) {
        Optional.ofNullable(broaderLinks.get(uri)).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).forEach(b -> {
            Element broader = new Element(type, Selectors.SKOS_NAMESPACE);
            broader.setAttribute("resource", b, Selectors.RDF_NAMESPACE);
            keywordSkos.addContent((Content)broader);
        });
    }

    public Element buildConceptScheme(Path csvFile, String thesaurusTitle, String thesaurusNamespaceUrl) {
        Element conceptScheme = new Element("ConceptScheme", Selectors.SKOS_NAMESPACE);
        conceptScheme.setAttribute("about", thesaurusNamespaceUrl, Selectors.RDF_NAMESPACE);
        Element conceptSchemeTitle = new Element("title", Csw.NAMESPACE_DC);
        conceptSchemeTitle.setText(StringUtils.isEmpty((String)thesaurusTitle) ? csvFile.getFileName().toString() : thesaurusTitle);
        conceptScheme.addContent((Content)conceptSchemeTitle);
        Element conceptSchemeDateIssued = new Element("issued", Csw.NAMESPACE_DCT);
        Element conceptSchemeDateModified = new Element("issued", Csw.NAMESPACE_DCT);
        String now = new ISODate().toString();
        conceptSchemeDateIssued.setText(now);
        conceptSchemeDateModified.setText(now);
        conceptScheme.addContent((Content)conceptSchemeDateIssued);
        conceptScheme.addContent((Content)conceptSchemeDateModified);
        return conceptScheme;
    }

    @Operation(summary="Uploads a new thesaurus from URL or Registry", description="Uploads a new thesaurus.")
    @RequestMapping(method={RequestMethod.PUT}, produces={"text/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Thesaurus uploaded in SKOS format."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it.")})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public String uploadThesaurusFromUrl(@Parameter(description="If set, try to download from the Internet.") @RequestParam(value="url", required=false) String url, @Parameter(description="If set, try to download from a registry.") @RequestParam(value="registryUrl", required=false) String registryUrl, @Parameter(description="If using registryUrl, then define the type of registry. If not set, default mode is re3gistry.") @RequestParam(value="registryType", required=false) REGISTRY_TYPE registryType, @Parameter(description="Languages to download from a registry.") @RequestParam(value="registryLanguage", required=false) String[] registryLanguage, @Parameter(description="Local or external (default).") @RequestParam(value="type", defaultValue="external") ThesaurusType type, @Parameter(description="Type of thesaurus, usually one of the ISO thesaurus type codelist value. Default is theme.") @RequestParam(value="dir", defaultValue="theme") String dir, @Parameter(description="XSL to be use to convert the thesaurus before load. Default _none_.") @RequestParam(value="stylesheet", defaultValue="_none_") String stylesheet, HttpServletRequest request) throws Exception {
        long start = System.currentTimeMillis();
        ServiceContext context = ApiUtils.createServiceContext(request);
        boolean urlUpload = !StringUtils.isEmpty((String)url);
        boolean registryUpload = !StringUtils.isEmpty((String)registryUrl);
        Path rdfFile = null;
        String fname = null;
        if (urlUpload) {
            Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus from URL: " + url));
            rdfFile = this.getXMLContentFromUrl(url, context);
            fname = url.substring(url.lastIndexOf("/") + 1).replaceAll("\\s+", "");
            if (fname.lastIndexOf(46) == -1) {
                fname = fname + ".rdf";
            }
        } else if (registryUpload) {
            if (ArrayUtils.isEmpty((Object[])registryLanguage)) {
                throw new MissingServletRequestParameterException("Select at least one language.", "language");
            }
            Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus from registry : " + registryUrl));
            String itemName = registryUrl.substring(registryUrl.lastIndexOf("/") + 1);
            rdfFile = this.extractSKOSFromRegistry(registryUrl, registryType, itemName, registryLanguage, context);
            fname = registryUrl.replaceAll("[^A-Za-z]+", "") + "-" + itemName + ".rdf";
        } else {
            Log.debug((String)"geonetwork.thesaurus", (Object)"No URL or file name provided for thesaurus upload.");
            throw new MissingServletRequestParameterException("Thesaurus source not provided", "url");
        }
        if (StringUtils.isEmpty((String)fname)) {
            throw new ResourceNotFoundException("File upload from URL or file return null");
        }
        if (rdfFile == null || !Files.exists(rdfFile, new LinkOption[0])) {
            throw new ResourceNotFoundException("Thesaurus file doesn't exist");
        }
        long fsize = Files.size(rdfFile);
        if (fsize == 0L) {
            throw new ResourceNotFoundException("Thesaurus file has zero size");
        }
        String extension = FilenameUtils.getExtension((String)fname);
        if (!extension.equalsIgnoreCase("rdf") && !extension.equalsIgnoreCase("xml")) {
            Log.debug((String)"geonetwork.thesaurus", (Object)("Incorrect extension for thesaurus named: " + fname));
            throw new MissingServletRequestParameterException("Incorrect extension for thesaurus", fname);
        }
        Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus: " + fname));
        fname = fname.replace(extension, "rdf");
        this.uploadThesaurus(rdfFile, stylesheet, context, fname, type.toString(), dir);
        long end = System.currentTimeMillis();
        long duration = (end - start) / 1000L;
        return String.format("Thesaurus '%s' loaded in %d sec.", fname, duration);
    }

    private Path extractSKOSFromRegistry(String registryUrl, REGISTRY_TYPE registryType, String itemName, String[] lang, ServiceContext context) throws Exception {
        if (lang != null) {
            Element documents = new Element("documents");
            if (registryType == REGISTRY_TYPE.ldRegistry) {
                Path path = this.getXMLContentFromUrl(registryUrl + "?_view=with_metadata&_format=rdf", context);
                Element ldRegistryCodelistAsRdf = Xml.loadFile((Path)path);
                documents.addContent((Content)ldRegistryCodelistAsRdf);
            } else {
                for (String language : lang) {
                    try {
                        String languageFileUrl = registryUrl + "/" + itemName + "." + language + ".xml";
                        Path localRdf = this.getXMLContentFromUrl(languageFileUrl, context);
                        Element codeList = Xml.loadFile((Path)localRdf);
                        documents.addContent((Content)codeList);
                    }
                    catch (Exception e) {
                        Log.debug((String)"geonetwork.thesaurus", (Object)("Thesaurus not found for the requested translation: " + itemName + " " + language));
                        throw new ResourceNotFoundException("Thesaurus not found for the requested translation: " + itemName + " " + language);
                    }
                }
            }
            Path path = this.dataDirectory.getWebappDir().resolve(String.format("xslt/services/thesaurus/%s-to-skos.xsl", registryType == REGISTRY_TYPE.ldRegistry ? "ldregistry" : "registry"));
            Element transform = Xml.transform((Element)documents, (Path)path);
            Path rdfFile = Files.createTempFile("thesaurus", ".rdf", new FileAttribute[0]);
            XMLOutputter xmlOutput = new XMLOutputter();
            xmlOutput.setFormat(Format.getCompactFormat());
            xmlOutput.output(transform, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(rdfFile.toFile().getCanonicalPath()), StandardCharsets.UTF_8));
            return rdfFile;
        }
        return null;
    }

    private Path getXMLContentFromUrl(String url, ServiceContext context) throws URISyntaxException, IOException, MalformedURLException {
        URI uri = new URI(url);
        Path rdfFile = Files.createTempFile("thesaurus", ".rdf", new FileAttribute[0]);
        XmlRequest httpReq = this.httpRequestFactory.createXmlRequest(uri.toURL());
        httpReq.setAddress(uri.getPath());
        Lib.net.setupProxy(context, httpReq);
        httpReq.executeLarge(rdfFile);
        return rdfFile;
    }

    private void uploadThesaurus(Path rdfFile, String style, ServiceContext context, String fname, String type, String dir) throws Exception {
        Path path;
        Element tsXml;
        Path stylePath = context.getAppPath().resolve("xsl");
        Element xml = Xml.loadFile((Path)rdfFile);
        xml.detach();
        if (!"_none_".equals(style)) {
            FilePathChecker.verify((String)style);
            tsXml = Xml.transform((Element)xml, (Path)stylePath.resolve(style));
            tsXml.detach();
        } else {
            tsXml = xml;
        }
        if (tsXml.getNamespacePrefix().equals("rdf") && tsXml.getName().equals("RDF")) {
            path = this.thesaurusMan.buildThesaurusFilePath(fname, type, dir);
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                Xml.writeResponse((Document)new Document(tsXml), (OutputStream)out);
            }
        } else {
            IO.deleteFile((Path)rdfFile, (boolean)false, (String)"geonetwork.thesaurus");
            throw new WebApplicationException("Unknown format (Must be in SKOS format).");
        }
        String siteURL = this.settingManager.getSiteURL(context);
        Thesaurus gst = new Thesaurus(this.languagesMapper, fname, type, dir, path, siteURL);
        this.thesaurusMan.addThesaurus(gst, false);
    }

    private KeywordSearchParamsBuilder parseBuilder(String uiLang, String q, int maxResults, int offset, List<String> targetLangs, List<String> thesauri, String thesauriDomainName, KeywordSearchType typeSearch, String uri, IsoLanguagesMapper mapper) {
        KeywordSearchParamsBuilder parsedParams = new KeywordSearchParamsBuilder(mapper).lenient(true);
        if (q != null) {
            parsedParams.keyword(q, typeSearch, true);
        }
        if (uri != null) {
            parsedParams.uri(uri);
        }
        parsedParams.maxResults(maxResults);
        parsedParams.offset(offset);
        if (thesauriDomainName != null) {
            parsedParams.thesauriDomainName(thesauriDomainName);
        }
        if (thesauri == null) {
            Map listOfThesaurus = this.thesaurusMan.getThesauriMap();
            for (String t : listOfThesaurus.keySet()) {
                parsedParams.addThesaurus(((Thesaurus)listOfThesaurus.get(t)).getKey());
            }
        } else {
            for (String thesaurusName : thesauri) {
                if (thesaurusName.trim().isEmpty()) continue;
                parsedParams.addThesaurus(thesaurusName.trim());
            }
        }
        boolean addedLang = false;
        if (targetLangs != null) {
            for (String targetLang : targetLangs) {
                if (targetLang.trim().isEmpty()) continue;
                parsedParams.addLang(targetLang.trim());
                addedLang = true;
            }
        }
        if (!addedLang) {
            parsedParams.addLang(uiLang);
        }
        return parsedParams;
    }

    public static enum REGISTRY_TYPE {
        re3gistry,
        ldRegistry;

    }
}

