/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.rdf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.records.rdf.RdfSearcher;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.context.ConfigurableApplicationContext;

public class RdfOutputManager {
    private int PAGE_SIZE = 10;
    private final Element thesaurusEl;

    public RdfOutputManager(Element thesaurusEl) {
        this.thesaurusEl = thesaurusEl;
    }

    public RdfOutputManager(Element thesaurusEl, int pageSize) {
        this.thesaurusEl = thesaurusEl;
        this.PAGE_SIZE = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createRdfFile(ServiceContext context, RdfSearcher searcher) throws Exception {
        try {
            List results = searcher.search(context);
            File file = this.createRdfFile(context, results, 1, "");
            return file;
        }
        finally {
            searcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createRdfFile(ServiceContext context, List<Element> results, int page, String pagingInformation) throws Exception {
        File rdfFile;
        File catalogFile;
        File recordsFile;
        BufferedWriter outputRdfFile;
        BufferedWriter outputCatalogFile;
        BufferedWriter outputRecordsFile;
        block6: {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            DataManager dm = (DataManager)applicationContext.getBean(DataManager.class);
            Element records = this.createXsltModel(context);
            outputRecordsFile = null;
            outputCatalogFile = null;
            outputRdfFile = null;
            recordsFile = null;
            catalogFile = null;
            rdfFile = null;
            try {
                recordsFile = File.createTempFile("records-", ".rdf");
                outputRecordsFile = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(recordsFile), StandardCharsets.UTF_8));
                catalogFile = File.createTempFile("catalog-", ".rdf");
                outputCatalogFile = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(catalogFile), StandardCharsets.UTF_8));
                Path xslPath = context.getAppPath().resolve("xslt").resolve("services").resolve("dcat").resolve("rdf.xsl");
                int size = results.size();
                Log.info((String)"geonetwork", (Object)("DCAT - Processing " + size + " results"));
                if (size == 0) {
                    Element recordsRdf = Xml.transform((Element)records, (Path)xslPath);
                    this.writeCatalogResults(outputCatalogFile, recordsRdf, page, pagingInformation);
                    this.writeFileResults(outputRecordsFile, recordsRdf, page);
                    break block6;
                }
                for (int i = 0; i < size; ++i) {
                    Element mdInfo = results.get(i);
                    Element info = mdInfo.getChild("info", Edit.NAMESPACE);
                    String id = info.getChildText("id");
                    boolean forEditing = false;
                    boolean withValidationErrors = false;
                    boolean keepXlinkAttributes = false;
                    Element md = dm.getMetadata(context, id, forEditing, withValidationErrors, keepXlinkAttributes);
                    records.addContent(md.detach());
                    if (!this.hasToWriteResults(i, size)) continue;
                    Log.info((String)"geonetwork", (Object)("DCAT - Processing results from page " + page));
                    Element recordsRdf = Xml.transform((Element)records, (Path)xslPath);
                    this.writeCatalogResults(outputCatalogFile, recordsRdf, page, pagingInformation);
                    this.writeFileResults(outputRecordsFile, recordsRdf, page);
                    records = this.createXsltModel(context);
                    ++page;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputRecordsFile);
                IOUtils.closeQuietly(outputCatalogFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)outputRecordsFile);
        IOUtils.closeQuietly((Writer)outputCatalogFile);
        Log.info((String)"geonetwork", (Object)"DCAT - Creating RDF file with results");
        BufferedReader reader1 = null;
        BufferedReader reader2 = null;
        try {
            rdfFile = File.createTempFile("rdf-", ".rdf");
            outputRdfFile = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rdfFile), StandardCharsets.UTF_8));
            Log.info((String)"geonetwork", (Object)"DCAT - ... Writing file header and dcat:Catalog section");
            this.writeFileHeader(outputRdfFile);
            reader1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(catalogFile), StandardCharsets.UTF_8));
            IOUtils.copy((Reader)reader1, (Writer)outputRdfFile);
            Log.info((String)"geonetwork", (Object)"DCAT - ... Writing catalog records");
            reader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(recordsFile), StandardCharsets.UTF_8));
            IOUtils.copy((Reader)reader2, (Writer)outputRdfFile);
            outputRdfFile.write("</dcat:Catalog>");
            outputRdfFile.write("\n");
            Log.info((String)"geonetwork", (Object)"DCAT - ... Writing file footer");
            this.writeFileFooter(outputRdfFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputRdfFile);
            IOUtils.closeQuietly(reader1);
            IOUtils.closeQuietly(reader2);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)outputRdfFile);
        IOUtils.closeQuietly((Reader)reader1);
        IOUtils.closeQuietly((Reader)reader2);
        FileUtils.deleteQuietly((File)recordsFile);
        FileUtils.deleteQuietly((File)catalogFile);
        return rdfFile;
    }

    private boolean hasToWriteResults(int pos, int total) {
        return (pos + 1) % this.PAGE_SIZE == 0 || pos == total - 1;
    }

    private void writeCatalogResults(BufferedWriter output, Element rdf, int page, String pagingInformation) throws Exception {
        if (page > 1) {
            Namespace nsDcat = Namespace.getNamespace((String)"dcat", (String)"http://www.w3.org/ns/dcat#");
            List mdDcatDatasets = rdf.getChild("Catalog", nsDcat).getChildren("dataset", nsDcat);
            for (Element mdDcatDataset : mdDcatDatasets) {
                String dataset = Xml.getString((Element)mdDcatDataset);
                output.write(this.removeNamespaces(dataset));
                output.write("\n");
            }
        } else {
            output.write(pagingInformation);
            Namespace nsDcat = Namespace.getNamespace((String)"dcat", (String)"http://www.w3.org/ns/dcat#");
            output.write("\n");
            Element mdDcatCatalog = rdf.getChild("Catalog", nsDcat);
            output.write(this.removeNamespaces(Xml.getString((Element)mdDcatCatalog)).replace("</dcat:Catalog>", ""));
            output.write("\n");
        }
    }

    private void writeFileResults(BufferedWriter output, Element rdf, int page) throws Exception {
        List mdDcatList = rdf.getChildren();
        boolean recordsSectionStarted = false;
        for (Element mdDcat : mdDcatList) {
            String result;
            String elementName = mdDcat.getName();
            if (elementName.equalsIgnoreCase("Catalog")) continue;
            if (elementName.equalsIgnoreCase("CatalogRecord")) {
                recordsSectionStarted = true;
            }
            if (page == 1) {
                output.write("<dcat:dataset>");
                output.write("\n");
                result = Xml.getString((Element)mdDcat);
                output.write(this.removeNamespaces(result));
                output.write("</dcat:dataset>");
                output.write("\n");
                continue;
            }
            if (!recordsSectionStarted) continue;
            result = Xml.getString((Element)mdDcat);
            output.write(this.removeNamespaces(result));
            output.write("\n");
        }
    }

    private void writeFileHeader(BufferedWriter output) throws Exception {
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        output.write("\n");
        output.write("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" xmlns:foaf=\"http://xmlns.com/foaf/0.1/\" xmlns:void=\"http://www.w3.org/TR/void/\" xmlns:dcat=\"http://www.w3.org/ns/dcat#\" xmlns:dctype=\"http://purl.org/dc/dcmitype/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:skos=\"http://www.w3.org/2004/02/skos/core#\" xmlns:locn=\"http://www.w3.org/ns/locn#\" xmlns:time=\"http://www.w3.org/2006/time#\" xmlns:dct=\"http://purl.org/dc/terms/\">");
        output.write("\n");
    }

    private void writeFileFooter(BufferedWriter output) throws Exception {
        output.write("</rdf:RDF>");
    }

    private Element createXsltModel(ServiceContext context) {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = (SettingManager)gc.getBean(SettingManager.class);
        Element modelEl = new Element("root");
        Element serverEl = new Element("server");
        serverEl.addContent((Content)new Element("port").setText(sm.getValue("system/server/port")));
        serverEl.addContent((Content)new Element("host").setText(sm.getValue("system/server/host")));
        serverEl.addContent((Content)new Element("protocol").setText(sm.getValue("system/server/protocol")));
        Element siteEl = new Element("site");
        siteEl.addContent((Content)new Element("siteId").setText(sm.getValue("system/site/siteId")));
        siteEl.addContent((Content)new Element("name").setText(sm.getValue("system/site/name")));
        siteEl.addContent((Content)new Element("organization").setText(sm.getValue("system/site/organization")));
        Element metadataEl = new Element("metadata");
        metadataEl.addContent((Content)new Element("resourceIdentifierPrefix").setText(sm.getValue("metadata/resourceIdentifierPrefix")));
        Element guiEl = new Element("gui");
        Element systemConfigEl = new Element("systemConfig");
        systemConfigEl.addContent((Content)metadataEl);
        Element systemEl = new Element("system");
        systemEl.addContent((Content)serverEl);
        systemEl.addContent((Content)siteEl);
        systemConfigEl.addContent((Content)systemEl);
        guiEl.addContent((Content)systemConfigEl);
        guiEl.addContent((Content)new Element("language").setText(context.getLanguage()));
        guiEl.addContent((Content)new Element("url").setText(context.getBaseUrl()));
        guiEl.addContent((Content)new Element("thesaurus").setContent(this.thesaurusEl.detach()));
        modelEl.addContent((Content)guiEl);
        return modelEl;
    }

    private String removeNamespaces(String xml) {
        return xml.replace("xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"", "").replace("xmlns:dct=\"http://purl.org/dc/terms/\"", "").replace("xmlns:dcat=\"http://www.w3.org/ns/dcat#\"", "").replace("xmlns:skos=\"http://www.w3.org/2004/02/skos/core#\"", "").replace("xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"", "").replace("xmlns:void=\"http://www.w3.org/TR/void/\"", "").replace("xmlns:foaf=\"http://xmlns.com/foaf/0.1/\"", "").replace("xmlns:locn=\"http://www.w3.org/ns/locn#\"", "");
    }
}

