/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.FileWatcher;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpendesktopMimeDetector
extends MimeDetector {
    private static Logger log;
    private static String mimeCacheFile;
    private static String internalMimeCacheFile;
    private ByteBuffer content;
    private Timer timer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("eu.medsea.mimeutil.detector.OpendesktopMimeDetector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        mimeCacheFile = "/usr/share/mime/mime.cache";
        internalMimeCacheFile = "src/main/resources/mime.cache";
    }

    public OpendesktopMimeDetector(String mimeCacheFile) {
        this.init(mimeCacheFile);
    }

    public OpendesktopMimeDetector() {
        this.init(mimeCacheFile);
    }

    private void init(String mimeCacheFile) {
        String cacheFile = mimeCacheFile;
        if (!new File(cacheFile).exists()) {
            cacheFile = internalMimeCacheFile;
        }
        AbstractInterruptibleChannel rCh = null;
        try {
            try {
                RandomAccessFile raf = null;
                raf = new RandomAccessFile(cacheFile, "r");
                rCh = raf.getChannel();
                this.content = ((FileChannel)rCh).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)rCh).size());
                this.initMimeTypes();
                if (log.isDebugEnabled()) {
                    log.debug("Registering a FileWatcher for [" + cacheFile + "]");
                }
                FileWatcher task = new FileWatcher(new File(cacheFile)){

                    protected void onChange(File file) {
                        OpendesktopMimeDetector.this.initMimeTypes();
                    }
                };
                this.timer = new Timer();
                this.timer.schedule((TimerTask)task, new Date(), 10000L);
            }
            catch (Exception e) {
                throw new MimeException(e);
            }
        }
        finally {
            if (rCh != null) {
                try {
                    rCh.close();
                }
                catch (Exception e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    public void delete() {
        this.timer.cancel();
    }

    public String getDescription() {
        return "Resolve mime types for files and streams using the Opendesktop shared mime.cache file. Version [" + this.getMajorVersion() + "." + this.getMinorVersion() + "].";
    }

    public Collection getMimeTypesFileName(String fileName) {
        Collection mimeTypes = new ArrayList();
        this.lookupMimeTypesForGlobFileName(fileName, mimeTypes);
        if (!mimeTypes.isEmpty()) {
            mimeTypes = this.normalizeWeightedMimeList(mimeTypes);
        }
        return mimeTypes;
    }

    public Collection getMimeTypesURL(URL url) {
        Collection mimeTypes = this.getMimeTypesFileName(url.getPath());
        return this._getMimeTypes(mimeTypes, this.getInputStream(url));
    }

    public Collection getMimeTypesFile(File file) throws UnsupportedOperationException {
        Collection mimeTypes = this.getMimeTypesFileName(file.getName());
        if (!file.exists()) {
            return mimeTypes;
        }
        return this._getMimeTypes(mimeTypes, this.getInputStream(file));
    }

    public Collection getMimeTypesInputStream(InputStream in) throws UnsupportedOperationException {
        return this.lookupMimeTypesForMagicData(in);
    }

    public Collection getMimeTypesByteArray(byte[] data) throws UnsupportedOperationException {
        return this.lookupMagicData(data);
    }

    public String dump() {
        return "{MAJOR_VERSION=" + this.getMajorVersion() + " MINOR_VERSION=" + this.getMinorVersion() + " ALIAS_LIST_OFFSET=" + this.getAliasListOffset() + " PARENT_LIST_OFFSET=" + this.getParentListOffset() + " LITERAL_LIST_OFFSET=" + this.getLiteralListOffset() + " REVERSE_SUFFIX_TREE_OFFSET=" + this.getReverseSuffixTreeOffset() + " GLOB_LIST_OFFSET=" + this.getGlobListOffset() + " MAGIC_LIST_OFFSET=" + this.getMagicListOffset() + " NAMESPACE_LIST_OFFSET=" + this.getNameSpaceListOffset() + " ICONS_LIST_OFFSET=" + this.getIconListOffset() + " GENERIC_ICONS_LIST_OFFSET=" + this.getGenericIconListOffset() + "}";
    }

    private Collection lookupMimeTypesForMagicData(InputStream in) {
        int offset = 0;
        int len = this.getMaxExtents();
        byte[] data = new byte[len];
        in.mark(len);
        try {
            try {
                int restBytesToRead = len;
                while (restBytesToRead > 0) {
                    int bytesRead = in.read(data, offset, restBytesToRead);
                    if (bytesRead < 0) {
                        break;
                    }
                    offset += bytesRead;
                    restBytesToRead -= bytesRead;
                }
            }
            catch (IOException ioe) {
                throw new MimeException(ioe);
            }
        }
        finally {
            try {
                in.reset();
            }
            catch (Exception e) {
                throw new MimeException(e);
            }
        }
        return this.lookupMagicData(data);
    }

    private Collection lookupMagicData(byte[] data) {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        int listOffset = this.getMagicListOffset();
        int numEntries = this.content.getInt(listOffset);
        int offset = this.content.getInt(listOffset + 8);
        int i = 0;
        while (i < numEntries) {
            String mimeType = this.compareToMagicData(offset + 16 * i, data);
            if (mimeType != null) {
                mimeTypes.add(mimeType);
            } else {
                String nonMatch = this.getMimeType(this.content.getInt(offset + 16 * i + 4));
                mimeTypes.remove(nonMatch);
            }
            ++i;
        }
        return mimeTypes;
    }

    private String compareToMagicData(int offset, byte[] data) {
        int mimeOffset = this.content.getInt(offset + 4);
        int numMatches = this.content.getInt(offset + 8);
        int matchletOffset = this.content.getInt(offset + 12);
        int i = 0;
        while (i < numMatches) {
            if (this.matchletMagicCompare(matchletOffset + i * 32, data)) {
                return this.getMimeType(mimeOffset);
            }
            ++i;
        }
        return null;
    }

    private boolean matchletMagicCompare(int offset, byte[] data) {
        int rangeStart = this.content.getInt(offset);
        int rangeLength = this.content.getInt(offset + 4);
        int dataLength = this.content.getInt(offset + 12);
        int dataOffset = this.content.getInt(offset + 16);
        int maskOffset = this.content.getInt(offset + 20);
        int i = rangeStart;
        while (i <= rangeStart + rangeLength) {
            int j;
            boolean validMatch = true;
            if (i + dataLength > data.length) {
                return false;
            }
            if (maskOffset != 0) {
                j = 0;
                while (j < dataLength) {
                    if ((this.content.get(dataOffset + j) & this.content.get(maskOffset + j)) != (data[j + i] & this.content.get(maskOffset + j))) {
                        validMatch = false;
                        break;
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < dataLength) {
                    if (this.content.get(dataOffset + j) != data[j + i]) {
                        validMatch = false;
                        break;
                    }
                    ++j;
                }
            }
            if (validMatch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void lookupGlobLiteral(String fileName, Collection mimeTypes) {
        int listOffset = this.getLiteralListOffset();
        int numEntries = this.content.getInt(listOffset);
        int min = 0;
        int max = numEntries - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            String literal = this.getString(this.content.getInt(listOffset + 4 + 12 * mid));
            int cmp = literal.compareTo(fileName);
            if (cmp < 0) {
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                max = mid - 1;
                continue;
            }
            String mimeType = this.getMimeType(this.content.getInt(listOffset + 4 + 12 * mid + 4));
            int weight = this.content.getInt(listOffset + 4 + 12 * mid + 8);
            mimeTypes.add(new WeightedMimeType(mimeType, literal, weight));
            return;
        }
    }

    private void lookupGlobFileNameMatch(String fileName, Collection mimeTypes) {
        int listOffset = this.getGlobListOffset();
        int numEntries = this.content.getInt(listOffset);
        int i = 0;
        while (i < numEntries) {
            int offset = this.content.getInt(listOffset + 4 + 12 * i);
            int mimeTypeOffset = this.content.getInt(listOffset + 4 + 12 * i + 4);
            int weight = this.content.getInt(listOffset + 4 + 12 * i + 8);
            String pattern = this.getString(offset, true);
            String mimeType = this.getMimeType(mimeTypeOffset);
            if (fileName.matches(pattern)) {
                mimeTypes.add(new WeightedMimeType(mimeType, pattern, weight));
            }
            ++i;
        }
    }

    private Collection normalizeWeightedMimeList(Collection weightedMimeTypes) {
        WeightedMimeType mw;
        LinkedHashSet<WeightedMimeType> mimeTypes = new LinkedHashSet<WeightedMimeType>();
        Collections.sort((List)weightedMimeTypes, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return ((WeightedMimeType)obj1).weight - ((WeightedMimeType)obj2).weight;
            }
        });
        int weight = 0;
        int patternLen = 0;
        Iterator it = weightedMimeTypes.iterator();
        while (it.hasNext()) {
            mw = (WeightedMimeType)it.next();
            if (weight < mw.weight) {
                weight = mw.weight;
            }
            if (weight < mw.weight) continue;
            if (mw.pattern.length() > patternLen) {
                patternLen = mw.pattern.length();
            }
            mimeTypes.add(mw);
        }
        it = weightedMimeTypes.iterator();
        while (it.hasNext()) {
            mw = (WeightedMimeType)it.next();
            if (mw.pattern.length() >= patternLen) continue;
            mimeTypes.remove(mw);
        }
        HashSet<String> _mimeTypes = new HashSet<String>();
        Iterator it2 = mimeTypes.iterator();
        while (it2.hasNext()) {
            _mimeTypes.add(((WeightedMimeType)it2.next()).toString());
        }
        return _mimeTypes;
    }

    private void lookupMimeTypesForGlobFileName(String fileName, Collection mimeTypes) {
        if (fileName == null) {
            return;
        }
        this.lookupGlobLiteral(fileName, mimeTypes);
        if (!mimeTypes.isEmpty()) {
            return;
        }
        int len = fileName.length();
        this.lookupGlobSuffix(fileName, false, len, mimeTypes);
        if (mimeTypes.isEmpty()) {
            this.lookupGlobSuffix(fileName, true, len, mimeTypes);
        }
        if (mimeTypes.isEmpty()) {
            this.lookupGlobFileNameMatch(fileName, mimeTypes);
        }
    }

    private void lookupGlobSuffix(String fileName, boolean ignoreCase, int len, Collection mimeTypes) {
        int listOffset = this.getReverseSuffixTreeOffset();
        int numEntries = this.content.getInt(listOffset);
        int offset = this.content.getInt(listOffset + 4);
        this.lookupGlobNodeSuffix(fileName, numEntries, offset, ignoreCase, len, mimeTypes, new StringBuffer());
    }

    private void lookupGlobNodeSuffix(String fileName, int numEntries, int offset, boolean ignoreCase, int len, Collection mimeTypes, StringBuffer pattern) {
        char character;
        char c = character = ignoreCase ? fileName.toLowerCase().charAt(len - 1) : fileName.charAt(len - 1);
        if (character == '\u0000') {
            return;
        }
        int min = 0;
        int max = numEntries - 1;
        while (max >= min && len >= 0) {
            int mid = (min + max) / 2;
            char matchChar = (char)this.content.getInt(offset + 12 * mid);
            if (matchChar < character) {
                min = mid + 1;
                continue;
            }
            if (matchChar > character) {
                max = mid - 1;
                continue;
            }
            int numChildren = this.content.getInt(offset + 12 * mid + 4);
            int childOffset = this.content.getInt(offset + 12 * mid + 8);
            if (--len > 0) {
                pattern.append(matchChar);
                this.lookupGlobNodeSuffix(fileName, numChildren, childOffset, ignoreCase, len, mimeTypes, pattern);
            }
            if (mimeTypes.isEmpty()) {
                int i = 0;
                while (i < numChildren) {
                    matchChar = (char)this.content.getInt(childOffset + 12 * i);
                    if (matchChar != '\u0000') break;
                    int mimeOffset = this.content.getInt(childOffset + 12 * i + 4);
                    int weight = this.content.getInt(childOffset + 12 * i + 8);
                    mimeTypes.add(new WeightedMimeType(this.getMimeType(mimeOffset), pattern.toString(), weight));
                    ++i;
                }
            }
            return;
        }
    }

    private int getMaxExtents() {
        return this.content.getInt(this.getMagicListOffset() + 4);
    }

    private String aliasLookup(String alias) {
        int aliasListOffset = this.getAliasListOffset();
        int min = 0;
        int max = this.content.getInt(aliasListOffset) - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            int aliasOffset = this.content.getInt(aliasListOffset + 4 + mid * 8);
            int mimeOffset = this.content.getInt(aliasListOffset + 4 + mid * 8 + 4);
            int cmp = this.getMimeType(aliasOffset).compareTo(alias);
            if (cmp < 0) {
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                max = mid - 1;
                continue;
            }
            return this.getMimeType(mimeOffset);
        }
        return null;
    }

    private String unaliasMimeType(String mimeType) {
        String lookup = this.aliasLookup(mimeType);
        return lookup == null ? mimeType : lookup;
    }

    private boolean isMimeTypeSubclass(String mimeType, String subClass) {
        String umimeType = this.unaliasMimeType(mimeType);
        String usubClass = this.unaliasMimeType(subClass);
        MimeType _mimeType = new MimeType(umimeType);
        MimeType _subClass = new MimeType(usubClass);
        if (umimeType.compareTo(usubClass) == 0) {
            return true;
        }
        if (this.isSuperType(usubClass) && _mimeType.getMediaType().equals(_subClass.getMediaType())) {
            return true;
        }
        if (usubClass.equals("text/plain") && _mimeType.getMediaType().equals("text")) {
            return true;
        }
        if (usubClass.equals("application/octet-stream")) {
            return true;
        }
        int parentListOffset = this.getParentListOffset();
        int numParents = this.content.getInt(parentListOffset);
        int min = 0;
        int max = numParents - 1;
        while (max >= min) {
            int med = (min + max) / 2;
            int offset = this.content.getInt(parentListOffset + 4 + 8 * med);
            String parentMime = this.getMimeType(offset);
            int cmp = parentMime.compareTo(umimeType);
            if (cmp < 0) {
                min = med + 1;
                continue;
            }
            if (cmp > 0) {
                max = med - 1;
                continue;
            }
            offset = this.content.getInt(parentListOffset + 4 + 8 * med + 4);
            int _numParents = this.content.getInt(offset);
            int i = 0;
            while (i < _numParents) {
                int parentOffset = this.content.getInt(offset + 4 + 4 * i);
                if (this.isMimeTypeSubclass(this.getMimeType(parentOffset), usubClass)) {
                    return true;
                }
                ++i;
            }
            break block0;
        }
        return false;
    }

    private boolean isSuperType(String mimeType) {
        String type = mimeType.substring(mimeType.length() - 2);
        return type.equals("/*");
    }

    private int getGenericIconListOffset() {
        return this.content.getInt(36);
    }

    private int getIconListOffset() {
        return this.content.getInt(32);
    }

    private int getNameSpaceListOffset() {
        return this.content.getInt(28);
    }

    private int getMagicListOffset() {
        return this.content.getInt(24);
    }

    private int getGlobListOffset() {
        return this.content.getInt(20);
    }

    private int getReverseSuffixTreeOffset() {
        return this.content.getInt(16);
    }

    private int getLiteralListOffset() {
        return this.content.getInt(12);
    }

    private int getParentListOffset() {
        return this.content.getInt(8);
    }

    private int getAliasListOffset() {
        return this.content.getInt(4);
    }

    private short getMinorVersion() {
        return this.content.getShort(2);
    }

    private short getMajorVersion() {
        return this.content.getShort(0);
    }

    private String getMimeType(int offset) {
        return this.getString(offset);
    }

    private String getString(int offset) {
        return this.getString(offset, false);
    }

    private String getString(int offset, boolean regularExpression) {
        int position = this.content.position();
        this.content.position(offset);
        StringBuffer buf = new StringBuffer();
        char c = '\u0000';
        while ((c = (char)this.content.get()) != '\u0000') {
            if (regularExpression) {
                switch (c) {
                    case '.': {
                        buf.append("\\");
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '?': {
                        buf.append(".");
                    }
                }
            }
            buf.append(c);
        }
        this.content.position(position + 4);
        if (regularExpression) {
            buf.insert(0, '^');
            buf.append('$');
        }
        return buf.toString();
    }

    private InputStream getInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (Exception e) {
            log.error("Error getting InputStream for file [" + file.getAbsolutePath() + "]", (Throwable)e);
            return null;
        }
    }

    private InputStream getInputStream(URL url) {
        try {
            return MimeUtil.getInputStreamForURL(url);
        }
        catch (Exception e) {
            throw new MimeException("Error getting InputStream for URL [" + url.getPath() + "]", e);
        }
    }

    private Collection _getMimeTypes(Collection mimeTypes, InputStream in) {
        block10: {
            if (mimeTypes.isEmpty() || mimeTypes.size() > 1) {
                try {
                    in = new BufferedInputStream(in);
                    Collection _mimeTypes = this.getMimeTypesInputStream(in);
                    if (_mimeTypes.isEmpty()) break block10;
                    if (!mimeTypes.isEmpty()) {
                        Iterator it = mimeTypes.iterator();
                        while (it.hasNext()) {
                            String mimeType = (String)it.next();
                            if (_mimeTypes.contains(mimeType)) {
                                mimeTypes.add(mimeType);
                            }
                            Iterator _it = _mimeTypes.iterator();
                            while (_it.hasNext()) {
                                String _mimeType = (String)_it.next();
                                if (!this.isMimeTypeSubclass(mimeType, _mimeType)) continue;
                                mimeTypes.add(mimeType);
                            }
                        }
                        break block10;
                    }
                    Collection collection = _mimeTypes;
                    return collection;
                }
                catch (Exception e) {
                    throw new MimeException(e);
                }
                finally {
                    OpendesktopMimeDetector.closeStream(in);
                }
            }
        }
        return mimeTypes;
    }

    private void initMimeTypes() {
        int listOffset = this.getAliasListOffset();
        int numAliases = this.content.getInt(listOffset);
        int i = 0;
        while (i < numAliases) {
            MimeUtil.addKnownMimeType(this.getString(this.content.getInt(listOffset + 4 + i * 8)));
            MimeUtil.addKnownMimeType(this.getString(this.content.getInt(listOffset + 8 + i * 8)));
            ++i;
        }
    }

    class WeightedMimeType
    extends MimeType {
        private static final long serialVersionUID = 1L;
        String pattern;
        int weight;

        WeightedMimeType(String mimeType, String pattern, int weight) {
            super(mimeType);
            this.pattern = pattern;
            this.weight = weight;
        }
    }
}

