/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery.plan;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.ShardSnapshotInfo;

class ShardSnapshot {
    private final ShardSnapshotInfo shardSnapshotInfo;
    private final Map<String, BlobStoreIndexShardSnapshot.FileInfo> snapshotFiles;
    private final Store.MetadataSnapshot metadataSnapshot;

    ShardSnapshot(ShardSnapshotInfo shardSnapshotInfo, List<BlobStoreIndexShardSnapshot.FileInfo> snapshotFiles) {
        this.shardSnapshotInfo = shardSnapshotInfo;
        this.snapshotFiles = snapshotFiles.stream().collect(Collectors.toMap(snapshotFile -> snapshotFile.metadata().name(), Function.identity()));
        this.metadataSnapshot = ShardSnapshot.convertToMetadataSnapshot(snapshotFiles);
    }

    String getShardStateIdentifier() {
        return this.shardSnapshotInfo.getShardStateIdentifier();
    }

    String getRepository() {
        return this.shardSnapshotInfo.getRepository();
    }

    Store.MetadataSnapshot getMetadataSnapshot() {
        return this.metadataSnapshot;
    }

    IndexId getIndexId() {
        return this.shardSnapshotInfo.getIndexId();
    }

    long getStartedAt() {
        return this.shardSnapshotInfo.getStartedAt();
    }

    ShardSnapshotInfo getShardSnapshotInfo() {
        return this.shardSnapshotInfo;
    }

    List<BlobStoreIndexShardSnapshot.FileInfo> getSnapshotFiles(List<StoreFileMetadata> segmentFiles) {
        return segmentFiles.stream().map(storeFileMetadata -> this.snapshotFiles.get(storeFileMetadata.name())).collect(Collectors.toList());
    }

    static Store.MetadataSnapshot convertToMetadataSnapshot(List<BlobStoreIndexShardSnapshot.FileInfo> snapshotFiles) {
        return new Store.MetadataSnapshot(snapshotFiles.stream().map(BlobStoreIndexShardSnapshot.FileInfo::metadata).collect(Collectors.toMap(StoreFileMetadata::name, Function.identity())), Collections.emptyMap(), 0L);
    }
}

