/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui.treeview;

import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class TreeViewNode
extends DefaultMutableTreeNode {
    private Object oUserData;
    private String toolTip;
    private Vector vColumns = new Vector();
    private boolean bDnDSelected = false;
    private boolean bEditable = true;
    private JTree jTree;
    private DefaultTreeModel defTreeMod;

    public TreeViewNode() {
        this("");
    }

    public TreeViewNode(String string) {
        this(string, null);
    }

    public TreeViewNode(String string, Object object) {
        this.setText(string);
        this.setUserData(object);
    }

    public void setEditable(boolean bl) {
        this.bEditable = bl;
    }

    public boolean isEditable() {
        return this.bEditable;
    }

    public TreeViewNode duplicate() {
        TreeViewNode treeViewNode = this.getNewInstance();
        this.copyTo(treeViewNode);
        for (int i = 0; i < this.getChildCount(); ++i) {
            treeViewNode.add(this.getChild(i).duplicate());
        }
        return treeViewNode;
    }

    public void copyTo(TreeViewNode treeViewNode) {
        treeViewNode.toolTip = this.toolTip;
        treeViewNode.setText(this.getText());
    }

    public void setText(String string) {
        this.setUserObject(string);
    }

    public String getText() {
        return (String)this.getUserObject();
    }

    public void setUserData(Object object) {
        this.oUserData = object;
    }

    public Object getUserData() {
        return this.oUserData;
    }

    public TreeViewNode addChild(TreeViewNode treeViewNode) {
        return this.addChild(treeViewNode, true);
    }

    public TreeViewNode addChild(TreeViewNode treeViewNode, boolean bl) {
        if (this.tree() != null) {
            this.model().insertNodeInto(treeViewNode, this, this.getChildCount());
            if (bl) {
                treeViewNode.select();
            }
        } else {
            this.add(treeViewNode);
        }
        return this;
    }

    public TreeViewNode removeChild(TreeViewNode treeViewNode) {
        if (this.model() != null) {
            this.model().removeNodeFromParent(treeViewNode);
        } else {
            this.remove(treeViewNode);
        }
        return this;
    }

    public void insertChild(TreeViewNode treeViewNode, int n) {
        this.insertChild(treeViewNode, n, true);
    }

    public void insertChild(TreeViewNode treeViewNode, int n, boolean bl) {
        if (this.tree() != null) {
            this.model().insertNodeInto(treeViewNode, this, n);
            if (bl) {
                treeViewNode.select();
            }
        } else {
            this.insert(treeViewNode, n);
        }
    }

    public void refresh() {
        this.model().nodeChanged(this);
    }

    public void refreshIcon() {
        this.model().nodeStructureChanged(this.getParent());
        this.select();
    }

    public void recalcChildren() {
        if (this.model() != null) {
            this.model().nodeStructureChanged(this);
        }
    }

    public void select() {
        JTree jTree = this.tree();
        if (jTree == null) {
            return;
        }
        TreePath treePath = new TreePath(this.getPath());
        jTree.setSelectionPath(treePath);
        jTree.scrollPathToVisible(treePath);
    }

    public void makeVisible() {
        TreePath treePath = new TreePath(this.getPath());
        this.tree().scrollPathToVisible(treePath);
    }

    public boolean isSelected() {
        JTree jTree = this.tree();
        if (jTree == null) {
            return false;
        }
        return this == (TreeViewNode)jTree.getLastSelectedPathComponent();
    }

    public void expand(boolean bl) {
        if (bl) {
            this.tree().expandPath(new TreePath(this.getPath()));
        } else {
            this.tree().collapsePath(new TreePath(this.getPath()));
        }
    }

    public void expand(boolean bl, int n) {
        this.expand(bl, n, this);
    }

    private void expand(boolean bl, int n, TreeViewNode treeViewNode) {
        treeViewNode.expand(bl);
        if (n > 0) {
            for (int i = 0; i < treeViewNode.getChildCount(); ++i) {
                this.expand(bl, n - 1, treeViewNode.getChild(i));
            }
        }
    }

    public boolean isExpanded() {
        JTree jTree = this.tree();
        if (jTree == null) {
            return false;
        }
        return jTree.isExpanded(new TreePath(this.getPath()));
    }

    public TreeViewNode getChild(int n) {
        return (TreeViewNode)this.getChildAt(n);
    }

    public void swapNodes(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n < 0 || n >= this.getChildCount()) {
            return;
        }
        if (n2 < 0 || n2 >= this.getChildCount()) {
            return;
        }
        TreeViewNode treeViewNode = (TreeViewNode)this.getChildAt(n);
        TreeViewNode treeViewNode2 = (TreeViewNode)this.getChildAt(n2);
        this.children.setElementAt(treeViewNode2, n);
        this.children.setElementAt(treeViewNode, n2);
        int[] nArray = new int[]{n, n2};
        if (this.model() != null) {
            this.model().nodesChanged(this, nArray);
        }
        treeViewNode.recalcChildren();
        treeViewNode2.recalcChildren();
    }

    public void swapNodes(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
        int n = this.getIndex(treeViewNode);
        int n2 = this.getIndex(treeViewNode2);
        this.swapNodes(n, n2);
    }

    public void sortChildren() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < this.getChildCount() - 1; ++i) {
                TreeViewNode treeViewNode = this.getChild(i);
                TreeViewNode treeViewNode2 = this.getChild(i + 1);
                if (treeViewNode.getText().compareToIgnoreCase(treeViewNode2.getText()) <= 0) continue;
                bl = true;
                this.children.setElementAt(treeViewNode2, i);
                this.children.setElementAt(treeViewNode, i + 1);
            }
        }
        this.recalcChildren();
    }

    public void textChanged() {
    }

    public void nodeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void nodeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void setToolTipText(String string) {
        this.toolTip = string;
    }

    public String getToolTipText() {
        return this.toolTip;
    }

    public void setTree(JTree jTree) {
        this.jTree = jTree;
        this.defTreeMod = jTree == null ? null : (DefaultTreeModel)jTree.getModel();
    }

    public JTree getTree() {
        return this.tree();
    }

    public void addColumn(Object object) {
        this.vColumns.addElement(object);
    }

    public void removeColumn(int n) {
        this.vColumns.removeElementAt(n);
    }

    public Object getColumnAt(int n) {
        return this.vColumns.elementAt(n);
    }

    public void setColumnAt(Object object, int n) {
        this.vColumns.setElementAt(object, n);
    }

    protected TreeViewNode getNewInstance() {
        return new TreeViewNode();
    }

    private JTree tree() {
        return ((TreeViewNode)this.getRoot()).jTree;
    }

    private DefaultTreeModel model() {
        return ((TreeViewNode)this.getRoot()).defTreeMod;
    }

    void setDnDSelection(boolean bl) {
        this.bDnDSelected = bl;
    }

    boolean isDndSelected() {
        return this.bDnDSelected;
    }
}

