/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.sesame.config.DefaultRepositoryInfo;
import org.openrdf.sesame.config.RepositoryInfo;
import org.openrdf.sesame.repository.RepositoryList;

public class RepositoryListImpl
implements RepositoryList {
    private List _repositoryInfoList = new ArrayList();

    public RepositoryListImpl() {
    }

    public RepositoryListImpl(List repInfoList) {
        this();
        for (int i = 0; i < repInfoList.size(); ++i) {
            RepositoryInfo repInfo = (RepositoryInfo)repInfoList.get(i);
            this.addRepository(repInfo);
        }
    }

    public int getRepositoryCount() {
        return this._repositoryInfoList.size();
    }

    public List getRepositories() {
        return new ArrayList(this._repositoryInfoList);
    }

    public List getReadableRepositories() {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        for (int i = 0; i < this._repositoryInfoList.size(); ++i) {
            RepositoryInfo repInfo = (RepositoryInfo)this._repositoryInfoList.get(i);
            if (!repInfo.isReadable()) continue;
            result.add(repInfo);
        }
        return result;
    }

    public List getWritableRepositories() {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        for (int i = 0; i < this._repositoryInfoList.size(); ++i) {
            RepositoryInfo repInfo = (RepositoryInfo)this._repositoryInfoList.get(i);
            if (!repInfo.isWriteable()) continue;
            result.add(repInfo);
        }
        return result;
    }

    public List getReadWriteRepositories() {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        for (int i = 0; i < this._repositoryInfoList.size(); ++i) {
            RepositoryInfo repInfo = (RepositoryInfo)this._repositoryInfoList.get(i);
            if (!repInfo.isReadable() || !repInfo.isWriteable()) continue;
            result.add(repInfo);
        }
        return result;
    }

    public RepositoryInfo getRepository(String repositoryId) {
        for (int i = 0; i < this._repositoryInfoList.size(); ++i) {
            RepositoryInfo repInfo = (RepositoryInfo)this._repositoryInfoList.get(i);
            if (!repInfo.getRepositoryId().equals(repositoryId)) continue;
            return repInfo;
        }
        return null;
    }

    public void addRepository(String id, String title, boolean readable, boolean writeable) {
        this._repositoryInfoList.add(new DefaultRepositoryInfo(id, title, readable, writeable));
    }

    public void addRepository(RepositoryInfo repInfo) {
        this._repositoryInfoList.add(repInfo);
    }
}

