/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.Embeddable;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.XmlEmbeddable;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.InvalidPropertyException;

public class GeonetEntity {
    public static final String LABEL_EL_NAME = "label";
    public static final String RECORD_EL_NAME = "record";

    private static Element asXml(Object obj, IdentityHashMap<Object, Void> alreadyEncoded, Set<String> exclude) {
        alreadyEncoded.put(obj, null);
        Element record = new Element(RECORD_EL_NAME);
        Class<Object> objclass = obj.getClass();
        while (objclass != null) {
            for (Method method : objclass.getDeclaredMethods()) {
                try {
                    String descName;
                    if (!GeonetEntity.shouldBeAdded(exclude, objclass, method)) continue;
                    if (GeonetEntity.isGetter(method)) {
                        descName = method.getName().substring(3);
                        if (GeonetEntity.isLabel(descName) && !objclass.equals(Localized.class)) {
                            GeonetEntity.addLabels(obj, record, method);
                            continue;
                        }
                        if (GeonetEntity.isADuplicatedMethodWithAnotherReturnType(descName) || GeonetEntity.isLabel(descName)) continue;
                        GeonetEntity.addPropertyToElement(obj, alreadyEncoded, exclude, record, method, descName);
                        continue;
                    }
                    if (!GeonetEntity.isBooleanGetter(method) || GeonetEntity.isADuplicatedMethodWithAnotherReturnType(descName = method.getName().substring(2))) continue;
                    GeonetEntity.addPropertyToElement(obj, alreadyEncoded, exclude, record, method, descName);
                }
                catch (InvalidPropertyException descName) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            objclass = GeonetEntity.getNextSignificantAncestor(objclass);
        }
        return record;
    }

    protected static void addLabels(Object obj, Element record, Method method) throws IllegalAccessException, InvocationTargetException {
        Element labelEl = new Element(LABEL_EL_NAME);
        Map labels = (Map)method.invoke(obj, new Object[0]);
        if (labels != null) {
            for (Map.Entry entry : labels.entrySet()) {
                labelEl.addContent((Content)new Element(((String)entry.getKey()).toLowerCase()).setText((String)entry.getValue()));
            }
        }
        record.addContent((Content)labelEl);
    }

    protected static void addPropertyToElement(Object obj, IdentityHashMap<Object, Void> alreadyEncoded, Set<String> exclude, Element record, Method method, String descName) throws IllegalAccessException, InvocationTargetException {
        Object rawData = method.invoke(obj, new Object[0]);
        if (rawData != null) {
            Element element = GeonetEntity.propertyToElement(alreadyEncoded, descName, rawData, exclude);
            record.addContent((Content)element);
        }
    }

    protected static boolean shouldBeAdded(Set<String> exclude, Class<? extends Object> objclass, Method method) {
        return method.getDeclaringClass() == objclass && !exclude.contains(method.getName());
    }

    protected static boolean isBooleanGetter(Method method) {
        return method.getName().startsWith("is") && method.getGenericParameterTypes().length == 0;
    }

    protected static boolean isGetter(Method method) {
        return method.getName().startsWith("get") && method.getGenericParameterTypes().length == 0;
    }

    protected static Class<? extends Object> getNextSignificantAncestor(Class<? extends Object> objclass) {
        if ((objclass = objclass.getSuperclass()) != null && (objclass.equals(GeonetEntity.class) || objclass.equals(Object.class))) {
            objclass = null;
        }
        return objclass;
    }

    protected static boolean isLabel(String descName) {
        return descName.equals("LabelTranslations");
    }

    protected static boolean isADuplicatedMethodWithAnotherReturnType(String descName) {
        return descName.endsWith("AsInt") || descName.endsWith("AsBool");
    }

    private static Element propertyToElement(IdentityHashMap<Object, Void> alreadyEncoded, String descName, Object rawData, Set<String> exclude) {
        Element element = new Element(descName.toLowerCase());
        if (rawData instanceof GeonetEntity) {
            if (!alreadyEncoded.containsKey(rawData)) {
                Element element1 = ((GeonetEntity)rawData).asXml(alreadyEncoded);
                List list = element1.removeContent();
                element.addContent((Collection)list);
            }
        } else if (rawData instanceof XmlEmbeddable) {
            ((XmlEmbeddable)rawData).addToXml(element);
        } else if (GeonetEntity.hasEmbeddableAnnotation(rawData)) {
            Element element1 = GeonetEntity.asXml(rawData, alreadyEncoded, exclude);
            List list = element1.removeContent();
            element.addContent((Collection)list);
        } else if (rawData instanceof Iterable) {
            String childName = GeonetEntity.pluralToSingular(descName);
            for (Object o : (Iterable)rawData) {
                element.addContent((Content)GeonetEntity.propertyToElement(alreadyEncoded, childName, o, exclude));
            }
        } else {
            element.addContent(rawData.toString());
        }
        return element;
    }

    private static boolean hasEmbeddableAnnotation(Object obj) {
        return obj.getClass().getAnnotation(Embeddable.class) != null;
    }

    private static String pluralToSingular(String descName) {
        if (descName.endsWith("es")) {
            return descName.substring(0, descName.length() - 2);
        }
        if (descName.endsWith("s")) {
            return descName.substring(0, descName.length() - 1);
        }
        return descName;
    }

    @Nonnull
    public final Element asXml() {
        IdentityHashMap<Object, Void> alreadyEncoded = new IdentityHashMap<Object, Void>();
        Element record = this.asXml(alreadyEncoded);
        return record;
    }

    protected Set<String> propertiesToExcludeFromXml() {
        return Collections.emptySet();
    }

    protected Element asXml(IdentityHashMap<Object, Void> alreadyEncoded) {
        return GeonetEntity.asXml(this, alreadyEncoded, this.propertiesToExcludeFromXml());
    }
}

