/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.yammer.metrics.HealthChecks;
import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.HealthCheckRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.SortedMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HealthCheckServlet
extends HttpServlet {
    public static final String REGISTRY_ATTRIBUTE = HealthCheckServlet.class.getName() + ".registry";
    private static final String CONTENT_TYPE = "text/plain";
    private HealthCheckRegistry registry;

    public HealthCheckServlet(HealthCheckRegistry registry) {
        this.registry = registry;
    }

    public HealthCheckServlet() {
        this(HealthChecks.defaultRegistry());
    }

    public void init(ServletConfig config) throws ServletException {
        Object o = config.getServletContext().getAttribute(REGISTRY_ATTRIBUTE);
        if (o instanceof HealthCheckRegistry) {
            this.registry = (HealthCheckRegistry)o;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SortedMap results = this.registry.runHealthChecks();
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        PrintWriter writer = resp.getWriter();
        if (results.isEmpty()) {
            resp.setStatus(501);
            writer.println("! No health checks registered.");
        } else {
            if (HealthCheckServlet.isAllHealthy(results)) {
                resp.setStatus(200);
            } else {
                resp.setStatus(500);
            }
            for (Map.Entry entry : results.entrySet()) {
                Throwable error;
                HealthCheck.Result result = (HealthCheck.Result)entry.getValue();
                if (result.isHealthy()) {
                    if (result.getMessage() != null) {
                        writer.format("* %s: OK\n  %s\n", entry.getKey(), result.getMessage());
                        continue;
                    }
                    writer.format("* %s: OK\n", entry.getKey());
                    continue;
                }
                if (result.getMessage() != null) {
                    writer.format("! %s: ERROR\n!  %s\n", entry.getKey(), result.getMessage());
                }
                if ((error = result.getError()) == null) continue;
                writer.println();
                error.printStackTrace(writer);
                writer.println();
            }
        }
        writer.close();
    }

    private static boolean isAllHealthy(Map<String, HealthCheck.Result> results) {
        for (HealthCheck.Result result : results.values()) {
            if (result.isHealthy()) continue;
            return false;
        }
        return true;
    }
}

