/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.util.SortedMap;
import java.util.TreeMap;
import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.NameException;
import ucar.units.UnitName;

public final class UnknownUnit
extends BaseUnit {
    private static final long serialVersionUID = 1L;
    private static final SortedMap<String, UnknownUnit> map = new TreeMap<String, UnknownUnit>();

    private UnknownUnit(String name) throws NameException {
        super(UnitName.newUnitName(name, null, name), BaseQuantity.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnknownUnit create(String name) throws NameException {
        UnknownUnit unit;
        name = name.toLowerCase();
        SortedMap<String, UnknownUnit> sortedMap = map;
        synchronized (sortedMap) {
            unit = (UnknownUnit)map.get(name);
            if (unit == null) {
                unit = new UnknownUnit(name);
                map.put(unit.getName(), unit);
                map.put(unit.getPlural(), unit);
            }
        }
        return unit;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnknownUnit)) {
            return false;
        }
        UnknownUnit that = (UnknownUnit)object;
        return this.getName().equalsIgnoreCase(that.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().toLowerCase().hashCode();
    }

    @Override
    public boolean isDimensionless() {
        return false;
    }

    public static void main(String[] args) throws Exception {
        UnknownUnit unit1 = UnknownUnit.create("a");
        System.out.println("unit_a.equals(unit_a)=" + unit1.equals(unit1));
        System.out.println("unit_a.isDimensionless()=" + unit1.isDimensionless());
        UnknownUnit unit2 = UnknownUnit.create("b");
        System.out.println("unit_a.equals(unit_b)=" + unit1.equals(unit2));
        unit2 = UnknownUnit.create("A");
        System.out.println("unit_a.equals(unit_A)=" + unit1.equals(unit2));
    }
}

