/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import jeeves.server.dispatchers.guiservices.XmlCacheManager;
import org.fao.geonet.Constants;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

public class LangUtils {
    protected static final Map<TranslationKey, Map<String, String>> translationsCache = Maps.newConcurrentMap();

    public static Map<String, String> translate(ApplicationContext context, String type, String key) throws JDOMException, IOException {
        TranslationKey translationKey = new TranslationKey(type, key);
        Map<String, String> translations = translationsCache.get(translationKey);
        if (translations == null || ((SystemInfo)context.getBean(SystemInfo.class)).isDevMode()) {
            Path webappDir = ((GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class)).getWebappDir();
            Path loc = webappDir.resolve("loc");
            XmlCacheManager cacheManager = (XmlCacheManager)context.getBean(XmlCacheManager.class);
            String xmlTypeWithExtension = "xml/" + type + ".xml";
            String jsonTypeWithExtension = "json/" + type + ".json";
            HashMap<String, String> translations1 = new HashMap<String, String>();
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(loc, IO.DIRECTORIES_FILTER);){
                for (Path path : paths) {
                    String lang = path.getFileName().toString();
                    String translation = null;
                    if (Files.exists(path.resolve(jsonTypeWithExtension), new LinkOption[0])) {
                        Path jsonFile = path.resolve(jsonTypeWithExtension);
                        try {
                            JSONObject json = new JSONObject(new String(Files.readAllBytes(jsonFile), Constants.CHARSET));
                            translation = json.optString(key);
                        }
                        catch (JSONException e) {
                            throw new RuntimeException("Failed to parse the following file as a json file: " + jsonFile, e);
                        }
                    } else if (Files.exists(path.resolve(xmlTypeWithExtension), new LinkOption[0])) {
                        Element xml = cacheManager.get(context, true, loc, xmlTypeWithExtension, lang, lang, false);
                        translation = key.contains("/") || key.contains("[") || key.contains(":") ? Xml.selectString((Element)xml, (String)key) : xml.getChildText(key);
                    }
                    if (translation == null || translation.trim().isEmpty()) continue;
                    translations1.put(lang, translation);
                }
            }
            translations = translations1;
            translationsCache.put(translationKey, translations);
        }
        return translations;
    }

    public static Map<String, String> translate(ApplicationContext context, String key) throws JDOMException, IOException {
        return LangUtils.translate(context, "strings", key);
    }

    protected static final class TranslationKey {
        private String type;
        private String key;

        public TranslationKey(String type, String key) {
            this.type = type;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TranslationKey that = (TranslationKey)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }
    }
}

