/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.resources;

import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;

public class JCloudConfiguration {
    private BlobStoreContext client = null;
    private ContextBuilder builder = null;
    private String DEFAULT_CLOUD_FOLDER_SEPARATOR = "/";
    private final String DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_WINDOW_PARAMETERS = "toolbar=0,width=600,height=600";
    private final Boolean DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_MODAL_ENABLED = true;
    private final Boolean DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_FOLDER_ENABLED = true;
    private final Boolean DEFAULT_VERSIONING_ENABLED = false;
    private String provider;
    private String baseFolder;
    private String storageAccountName;
    private String storageAccountKey;
    private String containerName;
    private String endpoint;
    private String folderDelimiter = null;
    private String externalResourceManagementUrl;
    private String externalResourceManagementWindowParameters;
    private Boolean externalResourceManagementModalEnabled;
    private Boolean externalResourceManagementFolderEnabled;
    private String externalResourceManagementFolderRoot;
    private Boolean versioningEnabled;

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
    }

    public void setStorageAccountKey(String storageAccountKey) {
        this.storageAccountKey = storageAccountKey;
    }

    public void setBaseFolder(String baseFolder) {
        if (this.folderDelimiter == null) {
            this.folderDelimiter = this.DEFAULT_CLOUD_FOLDER_SEPARATOR;
        }
        this.baseFolder = StringUtils.isEmpty((String)baseFolder) ? this.folderDelimiter : (baseFolder.endsWith(this.folderDelimiter) ? baseFolder : baseFolder + this.folderDelimiter);
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public void setFolderDelimiter(String folderDelimiter) {
        if (this.folderDelimiter != null && !this.folderDelimiter.equals(folderDelimiter)) {
            throw new RuntimeException("Folder delimiter cannot be changed once set. Ensure that it is set prior to setting base folder");
        }
        this.folderDelimiter = folderDelimiter;
    }

    @Nonnull
    public String getExternalResourceManagementUrl() {
        return this.externalResourceManagementUrl;
    }

    public void setExternalResourceManagementUrl(String externalResourceManagementUrl) {
        this.externalResourceManagementUrl = externalResourceManagementUrl;
    }

    @Nonnull
    public String getExternalResourceManagementWindowParameters() {
        if (this.externalResourceManagementWindowParameters == null) {
            return "toolbar=0,width=600,height=600";
        }
        return this.externalResourceManagementWindowParameters;
    }

    public void setExternalResourceManagementWindowParameters(String externalResourceManagementWindowParameters) {
        this.externalResourceManagementWindowParameters = externalResourceManagementWindowParameters;
    }

    @Nonnull
    public Boolean isExternalResourceManagementModalEnabled() {
        if (this.externalResourceManagementModalEnabled == null) {
            return this.DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_MODAL_ENABLED;
        }
        return this.externalResourceManagementModalEnabled;
    }

    public void setExternalResourceManagementModalEnabled(Boolean externalResourceManagementModalEnabled) {
        this.externalResourceManagementModalEnabled = externalResourceManagementModalEnabled;
    }

    public void setExternalResourceManagementModalEnabled(String externalResourceManagementModalEnabled) {
        this.externalResourceManagementModalEnabled = BooleanUtils.toBooleanObject((String)externalResourceManagementModalEnabled);
    }

    public Boolean isExternalResourceManagementFolderEnabled() {
        if (this.externalResourceManagementFolderEnabled == null) {
            return this.DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_FOLDER_ENABLED;
        }
        return this.externalResourceManagementFolderEnabled;
    }

    public void setExternalResourceManagementFolderEnabled(Boolean externalResourceManagementFolderEnabled) {
        this.externalResourceManagementFolderEnabled = externalResourceManagementFolderEnabled;
    }

    public String getExternalResourceManagementFolderRoot() {
        return this.externalResourceManagementFolderRoot;
    }

    public void setExternalResourceManagementFolderRoot(String externalResourceManagementFolderRoot) {
        String folderRoot = externalResourceManagementFolderRoot;
        if (folderRoot != null) {
            if (!folderRoot.startsWith(this.getFolderDelimiter())) {
                folderRoot = this.getFolderDelimiter() + folderRoot;
            }
            if (folderRoot.endsWith(this.getFolderDelimiter())) {
                folderRoot = folderRoot.substring(0, folderRoot.length() - 1);
            }
        }
        this.externalResourceManagementFolderRoot = folderRoot;
    }

    @Nonnull
    public Boolean isVersioningEnabled() {
        if (this.versioningEnabled == null) {
            return this.DEFAULT_VERSIONING_ENABLED;
        }
        return this.versioningEnabled;
    }

    public void setVersioningEnabled(Boolean versioningEnabled) {
        this.versioningEnabled = versioningEnabled;
    }

    public void setVersioningEnabled(String versioningEnabled) {
        this.versioningEnabled = BooleanUtils.toBooleanObject((String)versioningEnabled);
    }

    @PostConstruct
    public void init() {
        if (this.folderDelimiter == null) {
            this.folderDelimiter = this.DEFAULT_CLOUD_FOLDER_SEPARATOR;
        }
        this.setBaseFolder(this.baseFolder);
        if (this.storageAccountName != null && this.provider != null) {
            this.builder = ContextBuilder.newBuilder((String)this.provider).credentials(this.storageAccountName, this.storageAccountKey);
            this.storageAccountName = null;
            this.storageAccountKey = null;
        }
        if (this.endpoint != null) {
            this.builder.endpoint(this.endpoint);
        }
        this.client = (BlobStoreContext)this.builder.buildView(BlobStoreContext.class);
        this.builder = null;
        if (this.containerName == null) {
            throw new RuntimeException("Missing the container Name configuration");
        }
    }

    @Nonnull
    public BlobStoreContext getClient() {
        return this.client;
    }

    @Nonnull
    public String getProvider() {
        return this.provider;
    }

    @Nonnull
    public String getContainerName() {
        return this.containerName;
    }

    public String getBaseFolder() {
        return this.baseFolder;
    }

    public String getFolderDelimiter() {
        return this.folderDelimiter;
    }
}

